/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.plain;

import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PlainTokenList
implements TokenList {
    private final Document doc;
    private String currentWord;
    private int currentStartOffset;
    private int nextSearchOffset;
    private boolean hidden;

    public PlainTokenList(Document doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentWord = null;
        this.currentStartOffset = -1;
        this.nextSearchOffset = offset;
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/Plain");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    public int getCurrentWordStartOffset() {
        return this.currentStartOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public boolean nextWord() {
        if (this.hidden) {
            return false;
        }
        try {
            boolean searching = true;
            CharSequence content = DocumentUtilities.getText((Document)this.doc);
            for (int offset = this.nextSearchOffset; offset < content.length(); ++offset) {
                char c = content.charAt(offset);
                if (searching) {
                    if (!Character.isLetter(c)) continue;
                    searching = false;
                    this.currentStartOffset = offset;
                    continue;
                }
                if (Character.isLetter(c)) continue;
                this.nextSearchOffset = offset;
                this.currentWord = this.doc.getText(this.currentStartOffset, offset - this.currentStartOffset);
                return true;
            }
            this.nextSearchOffset = this.doc.getLength();
            if (searching) {
                return false;
            }
            this.currentWord = this.doc.getText(this.currentStartOffset, this.doc.getLength() - this.currentStartOffset);
            return true;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

