/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.OpenTaskAction;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.FiltersMenuButton;
import org.netbeans.modules.tasklist.ui.TaskListTable;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.NbBundle;

class Util {
    private Util() {
    }

    public static Action getDefaultAction(Task t) {
        return new OpenTaskAction(t);
    }

    public static JPopupMenu createPopup(TaskListTable table) {
        JPopupMenu popup = new JPopupMenu();
        Task t = table.getSelectedTask();
        if (null != t) {
            popup.add(Util.getDefaultAction(t));
            popup.addSeparator();
            Action[] actions = Accessor.getActions(t);
            if (null != actions) {
                for (Action a : actions) {
                    if (null != a) {
                        popup.add(a);
                        continue;
                    }
                    popup.addSeparator();
                }
                if (actions.length > 0 && actions[actions.length - 1] != null) {
                    popup.addSeparator();
                }
            }
        }
        JMenu scopeMenu = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_Scope"));
        ScanningScopeList scopeList = ScanningScopeList.getDefault();
        for (TaskScanningScope scope : scopeList.getTaskScanningScopes()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(new SwitchScopeAction(scope));
            item.setSelected(scope.equals(TaskManagerImpl.getInstance().getScope()));
            scopeMenu.add(item);
        }
        popup.add(scopeMenu);
        JMenu filterMenu = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_Filter"));
        FiltersMenuButton.fillMenu(null, filterMenu);
        popup.add(filterMenu);
        popup.addSeparator();
        popup.add(new RefreshAction());
        popup.addSeparator();
        JMenu sortMenu = Util.createSortMenu(table);
        popup.add(sortMenu);
        return popup;
    }

    private static JMenu createSortMenu(TaskListTable table) {
        JMenu res = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_SortBy"));
        for (int i = 1; i < table.getColumnCount(); ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new SwitchSortAction(table, i));
            item.setSelected(i == table.getSortColumn());
            res.add(item);
        }
        res.addSeparator();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new SwitchSortOrderAction(table, true));
        item.setSelected(table.isAscendingSort());
        res.add(item);
        item = new JRadioButtonMenuItem(new SwitchSortOrderAction(table, false));
        item.setSelected(!table.isAscendingSort());
        res.add(item);
        return res;
    }

    private static class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(NbBundle.getMessage(Util.class, (String)"LBL_Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            tm.clearCache();
            tm.refresh(tm.getScope());
        }
    }

    private static class SwitchScopeAction
    extends AbstractAction {
        private TaskScanningScope scope;

        public SwitchScopeAction(TaskScanningScope scope) {
            super(Accessor.getDisplayName(scope), new ImageIcon(Accessor.getIcon(scope)));
            this.scope = scope;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            tm.observe(this.scope, tm.getFilter());
        }
    }

    private static class SwitchSortAction
    extends AbstractAction {
        private TaskListTable table;
        private int col;

        public SwitchSortAction(TaskListTable table, int col) {
            super(table.getModel().getColumnName(col));
            this.table = table;
            this.col = col;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.col == this.table.getSortColumn()) {
                this.table.setSortColumn(-1);
            } else {
                this.table.setSortColumn(this.col);
            }
            this.table.getTableHeader().repaint();
        }
    }

    private static class SwitchSortOrderAction
    extends AbstractAction {
        private TaskListTable table;
        private boolean asc;

        public SwitchSortOrderAction(TaskListTable table, boolean asc) {
            super(asc ? NbBundle.getMessage(Util.class, (String)"LBL_Asc") : NbBundle.getMessage(Util.class, (String)"LBL_Desc"));
            this.table = table;
            this.asc = asc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.table.setAscendingSort(this.asc);
            this.table.getTableHeader().repaint();
        }
    }
}

