/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n) {
        int n2 = Math.max(17, n);
        if (n2 % 2 == 0) {
            --n2;
        }
        this.m_buckets = new Node[n2];
        this.m_locks = new Lock[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_locks[n3] = new Lock();
            ++n3;
        }
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return (n %= this.m_buckets.length) < 0 ? n * -1 : n;
    }

    public Set keySet() {
        return new KeySet();
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            n += this.m_locks[n2].size;
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            if (node == null) {
                node = new Node();
                node.key = object;
                node.value = object2;
                this.m_buckets[n] = node;
                ++this.m_locks[n].size;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object3 = node.value;
                    node.value = object2;
                    return object3;
                }
                node2 = node2.next;
            }
            Node node3 = new Node();
            node3.key = object;
            node3.value = object2;
            node.next = node3;
            ++this.m_locks[n].size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    return node.value;
                }
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.m_buckets.length) {
            Lock lock = this.m_locks[n];
            synchronized (lock) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    if (node.value == object || node.value != null && node.value.equals(object)) {
                        return true;
                    }
                    node = node.next;
                }
            }
            ++n;
        }
        return false;
    }

    public Collection values() {
        return new Values();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            Node node2 = null;
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    if (null == node2) {
                        this.m_buckets[n] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.m_locks[n].size;
                    return node.value;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        int n = 0;
        while (n < this.m_buckets.length) {
            Lock lock;
            Lock lock2 = lock = this.m_locks[n];
            synchronized (lock2) {
                this.m_buckets[n] = null;
                lock.size = 0;
            }
            ++n;
        }
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.entrySet().equals(map.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock = this.m_locks[n2];
            synchronized (lock) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    n += node.hashCode();
                    node = node.next;
                }
            }
            ++n2;
        }
        return n;
    }

    public void atomic(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.atomic(runnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable runnable, int n) {
        if (n >= this.m_buckets.length) {
            runnable.run();
            return;
        }
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            this.atomic(runnable, n + 1);
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current = new ArrayList();
        private int bucket;
        private Map.Entry last;

        private EntryIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.current.size() <= 0) ** GOTO lbl18
            return true;
lbl-1000:
            // 1 sources

            {
                var1_1 = StaticBucketMap.access$600(StaticBucketMap.this)[this.bucket];
                synchronized (var1_1) {
                    var2_2 = StaticBucketMap.access$500(StaticBucketMap.this)[this.bucket];
                    while (var2_2 != null) {
                        this.current.add(var2_2);
                        var2_2 = var2_2.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        return true;
                    }
                    continue;
                }
lbl18:
                // 2 sources

                ** while (this.bucket < StaticBucketMap.access$500((StaticBucketMap)StaticBucketMap.this).length)
            }
lbl19:
            // 1 sources

            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            StaticBucketMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        StaticBucketMap.this.remove(node.getKey());
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object object) {
            return StaticBucketMap.this.containsKey(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            int n = StaticBucketMap.this.getHash(object);
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    Object object2 = node.getKey();
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        StaticBucketMap.this.remove(object2);
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }
    }

    private final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }
}

