/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NbWhereUsedRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public NbWhereUsedRefactoringPlugin(AbstractRefactoring refactoring) {
        super(refactoring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            WhereUsedQuery whereUsedRefactor = (WhereUsedQuery)this.refactoring;
            if (!whereUsedRefactor.getBooleanValue((Object)"FIND_REFERENCES")) {
                Problem problem = null;
                return problem;
            }
            Problem problem = null;
            Lookup lkp = whereUsedRefactor.getRefactoringSource();
            AbstractRefactoringPlugin.InfoHolder infoholder = this.examineLookup(lkp);
            TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
            Project project = FileOwnerQuery.getOwner((FileObject)handle.getFileObject());
            if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                Problem problem2 = null;
                return problem2;
            }
            if (infoholder.isClass) {
                this.checkManifest(project, infoholder.fullName, refactoringElements);
                this.checkLayer(project, infoholder.fullName, refactoringElements);
            }
            if (infoholder.isMethod) {
                this.checkMethodLayer(infoholder, handle.getFileObject(), refactoringElements);
            }
            if (infoholder.isConstructor) {
                this.checkConstructorLayer(infoholder, handle.getFileObject(), refactoringElements);
            }
            Problem problem3 = problem;
            return problem3;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Problem problem = null;
            return problem;
        }
        finally {
            semafor.set(null);
        }
    }

    @Override
    protected RefactoringElementImplementation createManifestRefactoring(String fqname, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return new ManifestWhereUsedRefactoringElement(attributeValue, manifestFile, attributeKey, section);
    }

    @Override
    protected RefactoringElementImplementation createLayerRefactoring(String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        FileObject fo = handle.getLayerFile();
        return fo != null ? new LayerWhereUsedRefactoringElement(fo, layerFileObject, layerAttribute) : null;
    }

    @Override
    protected RefactoringElementImplementation createMethodLayerRefactoring(String method, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        FileObject fo = handle.getLayerFile();
        return fo != null ? new LayerWhereUsedRefactoringElement(fo, layerFileObject, layerAttribute) : null;
    }

    @Override
    protected RefactoringElementImplementation createConstructorLayerRefactoring(String constructor, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        FileObject fo = handle.getLayerFile();
        return fo != null ? new LayerWhereUsedRefactoringElement(fo, layerFileObject, layerAttribute) : null;
    }

    public final class LayerWhereUsedRefactoringElement
    extends AbstractRefactoringElement {
        private String attr;
        private String path;
        private String attrValue;

        public LayerWhereUsedRefactoringElement(FileObject fo, FileObject layerFo, String attribute) {
            Object vl;
            super(fo);
            this.attr = attribute;
            this.path = layerFo.getPath();
            if (this.attr != null && (vl = layerFo.getAttribute("literal:" + this.attr)) instanceof String) {
                this.attrValue = ((String)vl).replaceFirst("^(new|method):", "");
            }
        }

        public String getDisplayText() {
            if (this.attr != null && this.attrValue != null) {
                return NbBundle.getMessage(NbWhereUsedRefactoringPlugin.class, (String)"TXT_LayerAttrValueWhereUsed", (Object)this.path, (Object)this.attr, (Object)this.attrValue);
            }
            if (this.attr != null) {
                return NbBundle.getMessage(NbWhereUsedRefactoringPlugin.class, (String)"TXT_LayerAttrWhereUsed", (Object)this.path, (Object)this.attr);
            }
            return NbBundle.getMessage(NbWhereUsedRefactoringPlugin.class, (String)"TXT_LayerWhereUsed", (Object)this.path);
        }

        @Override
        protected int[] location() {
            try {
                class Halt
                extends SAXException {
                    public Halt() {
                        super((String)null);
                    }
                }
                String match;
                int loc;
                DataObject d = DataObject.find((FileObject)this.parentFile);
                EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
                StyledDocument doc = ec.openDocument();
                String text = doc.getText(0, doc.getLength());
                assert (text.indexOf(13) == -1);
                InputSource in = new InputSource(new StringReader(text));
                in.setSystemId(this.parentFile.toURL().toExternalForm());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                final int[] lineAndColStartAndEnd = new int[4];
                try {
                    class Handler
                    extends DefaultHandler {
                        private int state = -1;
                        private Locator locator;
                        private String runningPath = "";

                        Handler() {
                        }

                        @Override
                        public void setDocumentLocator(Locator l) {
                            this.locator = l;
                        }

                        @Override
                        public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                            String name;
                            if ((qname.equals("file") || qname.equals("folder")) && (name = attr.getValue("name")) != null) {
                                if (this.runningPath.length() > 0) {
                                    this.runningPath = this.runningPath + '/';
                                }
                                this.runningPath = this.runningPath + name;
                            }
                            if (this.state == -1 && LayerWhereUsedRefactoringElement.this.path.equals(this.runningPath)) {
                                lineAndColStartAndEnd[0] = this.locator.getLineNumber();
                                lineAndColStartAndEnd[1] = this.locator.getColumnNumber();
                                this.state = 0;
                            } else if (this.state != -1) {
                                ++this.state;
                            }
                        }

                        @Override
                        public void endElement(String uri, String localname, String qname) throws SAXException {
                            if (qname.equals("file") || qname.equals("folder")) {
                                this.runningPath = this.runningPath.substring(0, Math.max(this.runningPath.lastIndexOf(47), 0));
                            }
                            if (this.state > 0) {
                                --this.state;
                            } else if (this.state == 0) {
                                lineAndColStartAndEnd[2] = this.locator.getLineNumber();
                                lineAndColStartAndEnd[3] = this.locator.getColumnNumber();
                                this.state = -1;
                                throw new Halt();
                            }
                        }

                        @Override
                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                            try {
                                return EntityCatalog.getDefault().resolveEntity(publicId, systemId);
                            }
                            catch (IOException e) {
                                throw new SAXException(e);
                            }
                        }
                    }
                    parser.parse(in, (DefaultHandler)new Handler());
                }
                catch (Halt h) {
                    // empty catch block
                }
                if (lineAndColStartAndEnd[0] == 0 || lineAndColStartAndEnd[1] == 0 || lineAndColStartAndEnd[2] == 0 || lineAndColStartAndEnd[3] == 0) {
                    return new int[]{0, 0};
                }
                int[] startAndEnd = new int[2];
                int line = 0;
                int col = 0;
                for (int i = 0; i < text.length(); ++i) {
                    if (line == lineAndColStartAndEnd[0] - 1 && col == lineAndColStartAndEnd[1] - 1) {
                        startAndEnd[0] = i;
                    } else if (line == lineAndColStartAndEnd[2] - 1 && col == lineAndColStartAndEnd[3] - 1) {
                        startAndEnd[1] = i;
                    }
                    char c = text.charAt(i);
                    if (c == '\n') {
                        ++line;
                        col = 0;
                        continue;
                    }
                    ++col;
                }
                startAndEnd[0] = Math.max(text.lastIndexOf(60, startAndEnd[0]), 0);
                if (startAndEnd[1] == 0) {
                    startAndEnd[1] = Math.max(text.indexOf(62, startAndEnd[0]), startAndEnd[0]);
                }
                if ((loc = text.indexOf(match = this.attrValue != null ? this.attrValue : this.path.substring(this.path.lastIndexOf(47) + 1), startAndEnd[0])) != -1 && loc < startAndEnd[1]) {
                    return new int[]{loc, loc + match.length()};
                }
                return startAndEnd;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return new int[]{0, 0};
            }
        }
    }

    public final class ManifestWhereUsedRefactoringElement
    extends AbstractRefactoringElement {
        private String attrName;
        private String sectionName;

        public ManifestWhereUsedRefactoringElement(String name, FileObject parentFile, String attributeName) {
            super(parentFile);
            this.sectionName = null;
            this.name = name;
            this.attrName = attributeName;
        }

        public ManifestWhereUsedRefactoringElement(String name, FileObject parentFile, String attributeName, String secName) {
            this(name, parentFile, attributeName);
            this.sectionName = secName;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbWhereUsedRefactoringPlugin.class, (String)"TXT_ManifestSectionWhereUsed", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbWhereUsedRefactoringPlugin.class, (String)"TXT_ManifestWhereUsed", (Object)this.name, (Object)this.attrName);
        }

        @Override
        protected int[] location() {
            try {
                DataObject d = DataObject.find((FileObject)this.parentFile);
                EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
                StyledDocument doc = ec.openDocument();
                String text = doc.getText(0, doc.getLength());
                assert (text.indexOf(13) == -1);
                int start = text.indexOf(this.name);
                if (start == -1) {
                    return new int[]{0, 0};
                }
                return new int[]{start, start + this.name.length()};
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return new int[]{0, 0};
            }
        }
    }
}

