/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.css.visual.CssRuleContent;
import org.netbeans.modules.css.visual.ui.FlexibleGridLayout;
import org.netbeans.modules.css.visual.ui.MarginWidthField;
import org.netbeans.modules.css.visual.ui.PaddingWidthField;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class MarginStyleEditor
extends StyleEditor {
    MarginDataTable marginDataTable;
    private JPanel marginPanel;

    public MarginStyleEditor() {
        super("marginStyleEditor", NbBundle.getMessage(MarginStyleEditor.class, (String)"MARGIN_EDITOR_DISPNAME"));
    }

    @Override
    protected void lazyInitializePanel() {
        this.marginDataTable = new MarginDataTable();
        this.initComponents();
        this.marginPanel.add((Component)this.marginDataTable, "Center");
    }

    @Override
    protected void setCssPropertyValues(CssRuleContent cssStyleData) {
        this.removeCssPropertyChangeListener();
        this.marginDataTable.setCssPropertyValues(cssStyleData);
        this.setCssPropertyChangeListener(cssStyleData);
        this.marginDataTable.validate();
        this.marginDataTable.repaint();
    }

    private void initComponents() {
        this.marginPanel = new JPanel();
        this.setLayout(new BorderLayout(0, 5));
        this.marginPanel.setLayout(new BorderLayout());
        this.add((Component)this.marginPanel, "North");
    }

    public class MarginDataTable
    extends JPanel {
        private String value;
        MarginWidthField allMarginField;
        PaddingWidthField allPaddingField;
        MarginWidthField topMarginField;
        PaddingWidthField topPaddingField;
        MarginWidthField bottomMarginField;
        PaddingWidthField leftPaddingField;
        MarginWidthField rightMarginField;
        PaddingWidthField rightPaddingField;
        PaddingWidthField bottomPaddingField;
        MarginWidthField leftMarginField;

        public MarginDataTable() {
            this.setLayout(new FlexibleGridLayout(6, 3, 5, 5));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int aheight = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
            this.setBackground(new JPanel().getBackground());
            this.initCells(aheight);
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_STYLE_TABLE_ACCESS_NAME"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_STYLE_TABLE_ACCESS_DESC"));
        }

        protected void setCssPropertyValues(CssRuleContent cssStyleData) {
            String topMargin = cssStyleData.getProperty("margin-top");
            String bottomMargin = cssStyleData.getProperty("margin-bottom");
            String leftMargin = cssStyleData.getProperty("margin-left");
            String rightMargin = cssStyleData.getProperty("margin-right");
            if (topMargin != null && bottomMargin != null && leftMargin != null && rightMargin != null && topMargin.equals(bottomMargin) && topMargin.equals(leftMargin) && topMargin.equals(rightMargin)) {
                this.allMarginField.setMarginString(topMargin);
            } else {
                this.allMarginField.setMarginString(null);
                this.topMarginField.setMarginString(topMargin);
                this.bottomMarginField.setMarginString(bottomMargin);
                this.leftMarginField.setMarginString(leftMargin);
                this.rightMarginField.setMarginString(rightMargin);
            }
            String topPadding = cssStyleData.getProperty("padding-top");
            String bottomPadding = cssStyleData.getProperty("padding-bottom");
            String leftPadding = cssStyleData.getProperty("padding-left");
            String rightPadding = cssStyleData.getProperty("padding-right");
            if (topPadding != null && bottomPadding != null && leftPadding != null && rightPadding != null && topPadding.equals(bottomPadding) && topPadding.equals(leftPadding) && topPadding.equals(rightPadding)) {
                this.allPaddingField.setPaddingString(topPadding);
            } else {
                this.allPaddingField.setPaddingString(null);
                this.topPaddingField.setPaddingString(topPadding);
                this.bottomPaddingField.setPaddingString(bottomPadding);
                this.leftPaddingField.setPaddingString(leftPadding);
                this.rightPaddingField.setPaddingString(rightPadding);
            }
        }

        public void initCells(int aheight) {
            JPanel colHeader1 = new JPanel();
            JPanel colHeader2 = new JPanel();
            colHeader2.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_ALL")));
            JPanel colHeader3 = new JPanel();
            colHeader3.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"PADDING")));
            JPanel rowHeader1 = new JPanel();
            rowHeader1.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_PADDING_ALL")));
            JPanel rowHeader2 = new JPanel();
            rowHeader2.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_PADDING_TOP")));
            JPanel rowHeader3 = new JPanel();
            rowHeader3.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_PADDING_BOTTOM")));
            JPanel rowHeader4 = new JPanel();
            rowHeader4.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_PADDING_LEFT")));
            JPanel rowHeader5 = new JPanel();
            rowHeader5.add(new JLabel(NbBundle.getMessage(MarginDataTable.class, (String)"MARGIN_PADDING_RIGHT")));
            this.allMarginField = new MarginWidthField();
            this.allMarginField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_MARGIN_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_MARGIN_WIDTH_UNIT_ACCESS_NAME"));
            this.allMarginField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_MARGIN_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_MARGIN_WIDTH_UNIT_ACCESS_DESC"));
            this.allMarginField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.startAggregatedEventsSession();
                    MarginDataTable.this.topMarginField.setMarginString(evt.getNewValue().toString());
                    MarginDataTable.this.bottomMarginField.setMarginString(evt.getNewValue().toString());
                    MarginDataTable.this.leftMarginField.setMarginString(evt.getNewValue().toString());
                    MarginDataTable.this.rightMarginField.setMarginString(evt.getNewValue().toString());
                    MarginStyleEditor.this.closeAggregatedEventsSession();
                }
            });
            this.allPaddingField = new PaddingWidthField();
            this.allPaddingField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_PADDING_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_PADDING_WIDTH_UNIT_ACCESS_NAME"));
            this.allPaddingField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_PADDING_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"ALL_SIDE_PADDING_WIDTH_UNIT_ACCESS_DESC"));
            this.allPaddingField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.startAggregatedEventsSession();
                    MarginDataTable.this.topPaddingField.setPaddingString(evt.getNewValue().toString());
                    MarginDataTable.this.bottomPaddingField.setPaddingString(evt.getNewValue().toString());
                    MarginDataTable.this.leftPaddingField.setPaddingString(evt.getNewValue().toString());
                    MarginDataTable.this.rightPaddingField.setPaddingString(evt.getNewValue().toString());
                    MarginStyleEditor.this.closeAggregatedEventsSession();
                }
            });
            this.topMarginField = new MarginWidthField();
            this.topMarginField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_MARGIN_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_MARGIN_WIDTH_UNIT_ACCESS_NAME"));
            this.topMarginField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_MARGIN_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_MARGIN_WIDTH_UNIT_ACCESS_DESC"));
            this.topMarginField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("margin-top", null, evt.getNewValue().toString());
                }
            });
            this.topPaddingField = new PaddingWidthField();
            this.topPaddingField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_PADDING_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_PADDING_WIDTH_UNIT_ACCESS_NAME"));
            this.topPaddingField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_PADDING_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"TOP_SIDE_PADDING_WIDTH_UNIT_ACCESS_DESC"));
            this.topPaddingField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("padding-top", null, evt.getNewValue().toString());
                }
            });
            this.bottomMarginField = new MarginWidthField();
            this.bottomMarginField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_MARGIN_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_MARGIN_WIDTH_UNIT_ACCESS_NAME"));
            this.bottomMarginField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_MARGIN_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_MARGIN_WIDTH_UNIT_ACCESS_DESC"));
            this.bottomMarginField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("margin-bottom", null, evt.getNewValue().toString());
                }
            });
            this.bottomPaddingField = new PaddingWidthField();
            this.bottomPaddingField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_PADDING_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_PADDING_WIDTH_UNIT_ACCESS_NAME"));
            this.bottomPaddingField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_PADDING_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"BOTTOM_SIDE_PADDING_WIDTH_UNIT_ACCESS_DESC"));
            this.bottomPaddingField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("padding-bottom", null, evt.getNewValue().toString());
                }
            });
            this.leftMarginField = new MarginWidthField();
            this.leftMarginField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_MARGIN_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_MARGIN_WIDTH_UNIT_ACCESS_NAME"));
            this.leftMarginField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_MARGIN_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_MARGIN_WIDTH_UNIT_ACCESS_DESC"));
            this.leftMarginField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("margin-left", null, evt.getNewValue().toString());
                }
            });
            this.leftPaddingField = new PaddingWidthField();
            this.leftPaddingField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_PADDING_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_PADDING_WIDTH_UNIT_ACCESS_NAME"));
            this.leftPaddingField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_PADDING_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"LEFT_SIDE_PADDING_WIDTH_UNIT_ACCESS_DESC"));
            this.leftPaddingField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("padding-left", null, evt.getNewValue().toString());
                }
            });
            this.rightMarginField = new MarginWidthField();
            this.rightMarginField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_MARGIN_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_MARGIN_WIDTH_UNIT_ACCESS_NAME"));
            this.rightMarginField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_MARGIN_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_MARGIN_WIDTH_UNIT_ACCESS_DESC"));
            this.rightMarginField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("margin-right", null, evt.getNewValue().toString());
                }
            });
            this.rightPaddingField = new PaddingWidthField();
            this.rightPaddingField.setAccessibleName(NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_PADDING_WIDTH_ACCESS_NAME"), NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_PADDING_WIDTH_UNIT_ACCESS_NAME"));
            this.rightPaddingField.setAccessibleDescription(NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_PADDING_WIDTH_ACCESS_DESC"), NbBundle.getMessage(MarginDataTable.class, (String)"RIGHT_SIDE_PADDING_WIDTH_UNIT_ACCESS_DESC"));
            this.rightPaddingField.addPropertyChangeListener("margin-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarginStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("padding-right", null, evt.getNewValue().toString());
                }
            });
            this.add(colHeader1);
            this.add(colHeader2);
            this.add(colHeader3);
            this.add(rowHeader1);
            this.add(this.allMarginField);
            this.add(this.allPaddingField);
            this.add(rowHeader2);
            this.add(this.topMarginField);
            this.add(this.topPaddingField);
            this.add(rowHeader3);
            this.add(this.bottomMarginField);
            this.add(this.bottomPaddingField);
            this.add(rowHeader4);
            this.add(this.leftMarginField);
            this.add(this.leftPaddingField);
            this.add(rowHeader5);
            this.add(this.rightMarginField);
            this.add(this.rightPaddingField);
            int cnt = this.getComponentCount();
            int[] widths = new int[]{30, 100, 100};
            for (int i = 0; i < cnt; ++i) {
                int awidth = widths[i % 3];
                this.getComponent(i).setPreferredSize(new Dimension(awidth, aheight));
                this.getComponent(i).setMinimumSize(new Dimension(awidth, aheight));
                this.getComponent(i).setMaximumSize(new Dimension(awidth, aheight));
            }
        }

        class PropertyChangeListenerImpl
        implements PropertyChangeListener {
            PropertyChangeListenerImpl() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        }
    }
}

