/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.lib.api.model.Declaration;
import org.netbeans.modules.css.lib.api.model.Rule;
import org.netbeans.modules.css.visual.model.Utils;

public class CssRuleContent {
    private final List<PropertyChangeListener> LISTENERS = new ArrayList<PropertyChangeListener>();
    private final Rule rule;

    public static CssRuleContent create(Rule rule) {
        return new CssRuleContent(rule);
    }

    private CssRuleContent(Rule rule) {
        this.rule = rule;
    }

    public Rule rule() {
        return this.rule;
    }

    public List<Declaration> ruleItems() {
        return this.rule.items();
    }

    public String getProperty(String property) {
        Declaration item = this.findItem(property);
        if (item != null) {
            return item.getValue().name();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssRuleContent) {
            CssRuleContent cssRuleContent = (CssRuleContent)obj;
            return this.getFormattedString().equals(cssRuleContent.getFormattedString());
        }
        return false;
    }

    public int hashCode() {
        return this.getFormattedString().hashCode();
    }

    public void modifyProperty(String property, String newValue) throws BadLocationException {
        Declaration item = this.findItem(property);
        newValue = newValue.trim();
        if (item == null && newValue.length() == 0) {
            return;
        }
        if (item != null && newValue.length() == 0) {
            this.firePropertyChange(item, null);
        } else {
            String oldVal;
            String string = oldVal = item == null ? null : item.getValue().name();
            if (oldVal == null || !newValue.equals(oldVal)) {
                Declaration newRuleItem = Declaration.createArtificial((String)property, (String)newValue);
                this.firePropertyChange(item, newRuleItem);
            }
        }
    }

    public String getFormattedString() {
        StringWriter strWriter = new StringWriter();
        for (Declaration item : this.ruleItems()) {
            if (item.getProperty() == null || item.getValue() == null) continue;
            String property = item.getProperty().name();
            String propertyValue = item.getValue().name().trim();
            if (!propertyValue.equals(Utils.NOT_SET) && !propertyValue.equals("")) {
                strWriter.write("   " + property);
                strWriter.write(": ");
                strWriter.write(propertyValue);
                strWriter.write("; ");
            }
            strWriter.write("\n");
        }
        return strWriter.toString();
    }

    public String toString() {
        return this.getFormattedString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.LISTENERS.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.LISTENERS.remove(listener);
    }

    private synchronized void firePropertyChange(Declaration oldVal, Declaration newVal) {
        ArrayList<PropertyChangeListener> copy = new ArrayList<PropertyChangeListener>(this.LISTENERS);
        for (PropertyChangeListener l : copy) {
            l.propertyChange(new PropertyChangeEvent(this, "property", oldVal, newVal));
        }
    }

    private Declaration findItem(String keyName) {
        for (Declaration ri : this.ruleItems()) {
            if (!ri.getProperty().name().equals(keyName)) continue;
            return ri;
        }
        return null;
    }
}

