/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.editor.api.CssCslParserResult;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.model.Declaration;
import org.netbeans.modules.css.lib.api.model.Rule;
import org.netbeans.modules.css.lib.api.model.Stylesheet;
import org.netbeans.modules.css.visual.CssRuleContent;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewable;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CssEditorSupport {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CssRuleContent selected = null;
    private Document document = null;
    private List<CssPreviewable.Listener> previewableListeners = new ArrayList<CssPreviewable.Listener>();
    private static final Logger LOGGER = Logger.getLogger("css.visual");
    private static final CssEditorSupport INSTANCE = new CssEditorSupport();
    private static final boolean DEBUG = Boolean.getBoolean("issue_129209_debug");
    private CssCslParserResult result;
    private Stylesheet model;
    private PropertyChangeListener CSS_STYLE_DATA_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            NbEditorDocument doc;
            if (CssEditorSupport.this.selected != null && !CssEditorSupport.this.aggregated_events) {
                CssEditorSupport.this.d("css style data listener - detachinf from rule content.");
                CssEditorSupport.this.selected.removePropertyChangeListener(CssEditorSupport.this.CSS_STYLE_DATA_LISTENER);
            }
            if ((doc = (NbEditorDocument)CssEditorSupport.this.document) != null) {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        block10: {
                            Declaration oldRule = (Declaration)evt.getOldValue();
                            Declaration newRule = (Declaration)evt.getNewValue();
                            if (CssEditorSupport.this.selected == null) {
                                throw new IllegalStateException("CssRuleContent event fired, but selected rule is null!");
                            }
                            Rule myRule = CssEditorSupport.this.selected.rule();
                            try {
                                if (oldRule != null && newRule == null) {
                                    int start = oldRule.getProperty().offset();
                                    int end = oldRule.getValue().offset() + oldRule.getValue().name().length();
                                    end = oldRule.semicolonOffset() != -1 ? oldRule.semicolonOffset() + 1 : end;
                                    doc.remove(start, end - start);
                                    if (Utilities.isRowWhite((BaseDocument)doc, (int)start)) {
                                        int lineStart = Utilities.getRowStart((BaseDocument)doc, (int)start);
                                        int lineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)start);
                                        int nextLineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(lineOffset + 1));
                                        doc.remove(lineStart, nextLineStart - lineStart);
                                    }
                                    break block10;
                                }
                                if (oldRule == null && newRule != null) {
                                    List items = myRule.items();
                                    int INDENT = IndentUtils.indentLevelSize((Document)CssEditorSupport.this.document);
                                    int insertOffset = myRule.getRuleCloseBracketOffset();
                                    boolean initialNewLine = false;
                                    if (!items.isEmpty()) {
                                        Declaration last = (Declaration)items.get(items.size() - 1);
                                        if (last.semicolonOffset() == -1) {
                                            doc.insertString(last.getValue().offset() + last.getValue().name().trim().length(), ";", null);
                                            ++insertOffset;
                                        }
                                        initialNewLine = Utilities.getLineOffset((BaseDocument)doc, (int)myRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)doc, (int)last.getProperty().offset());
                                    } else {
                                        initialNewLine = Utilities.getLineOffset((BaseDocument)doc, (int)myRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)doc, (int)myRule.getRuleOpenBracketOffset());
                                    }
                                    String text = (initialNewLine ? LINE_SEPARATOR : "") + IndentUtils.createIndentString((Document)CssEditorSupport.this.document, (int)INDENT) + newRule.getProperty().name() + ": " + newRule.getValue().name() + ";" + LINE_SEPARATOR;
                                    doc.insertString(insertOffset, text, null);
                                    break block10;
                                }
                                if (oldRule != null && newRule != null) {
                                    doc.remove(oldRule.getProperty().offset(), oldRule.getProperty().name().length());
                                    doc.insertString(oldRule.getProperty().offset(), newRule.getProperty().name(), null);
                                    int diff = newRule.getProperty().name().length() - oldRule.getProperty().name().length();
                                    doc.remove(oldRule.getValue().offset() + diff, oldRule.getValue().name().length());
                                    doc.insertString(oldRule.getValue().offset() + diff, newRule.getValue().name(), null);
                                    break block10;
                                }
                                throw new IllegalArgumentException("Invalid PropertyChangeEvent - both old and new values are null!");
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
    };
    private boolean aggregated_events = false;

    public static synchronized CssEditorSupport getDefault() {
        return INSTANCE;
    }

    void parsed(final CssCslParserResult result, final int caretOffset) {
        this.d("model updated");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CssEditorSupport.this.d("model updated from AWT");
                CssEditorSupport.this.updateSelectedRule(result, caretOffset);
            }
        });
    }

    void parsedWithError(CssCslParserResult result) {
        this.d("model invalid");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CssEditorSupport.this.selected != null) {
                    CssEditorSupport.this.selected.removePropertyChangeListener(CssEditorSupport.this.CSS_STYLE_DATA_LISTENER);
                    CssEditorSupport.this.d("removed css style data listener from " + CssEditorSupport.this.selected);
                    CssEditorSupport.this.selected = null;
                }
                StyleBuilderTopComponent.findInstance().setPanelMode(3);
                CssEditorSupport.this.firePreviewableDeactivated();
            }
        });
    }

    private synchronized void updateSelectedRule(CssCslParserResult result, int dotPos) {
        Rule selectedRule;
        LOGGER.log(Level.FINE, "updateSelectedRule({0})", dotPos);
        if (this.result != result) {
            this.model = Stylesheet.create((CssParserResult)result.getWrappedCssParserResult());
            this.result = result;
        }
        LOGGER.log(Level.FINE, (selectedRule = this.model.ruleForOffset(dotPos)) == null ? "NO rule" : "found a rule");
        this.d("selected rule:" + selectedRule);
        if (selectedRule == null) {
            if (this.selected != null) {
                this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("no selected rule, removing css style data listener");
                this.selected = null;
            }
            StyleBuilderTopComponent.findInstance().setPanelMode(4);
            this.firePreviewableDeactivated();
        } else {
            if (this.selected != null) {
                if (selectedRule.equals(this.selected.rule())) {
                    this.d("already selected rule selected, exiting");
                    return;
                }
                this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("removed css style data listener from previous rule: " + this.selected);
            }
            this.selected = CssRuleContent.create(selectedRule);
            this.document = result.getSnapshot().getSource().getDocument(false);
            CssRuleContext context = new CssRuleContext(this.selected, this.model, this.document, FileUtil.toFile((FileObject)result.getSnapshot().getSource().getFileObject()));
            StyleBuilderTopComponent sbTC = StyleBuilderTopComponent.findInstance();
            sbTC.setContent(context);
            sbTC.setPanelMode(2);
            this.d("stylebuilder UI updated");
            this.selected.addPropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
            this.d("added property change listener to the new rule: " + this.selected);
            this.firePreviewableActivated(context);
        }
        this.d("updateselected rule exit");
    }

    public void addListener(CssPreviewable.Listener l) {
        this.previewableListeners.add(l);
    }

    public void removeListener(CssPreviewable.Listener l) {
        this.previewableListeners.remove(l);
    }

    private void firePreviewableActivated(CssRuleContext content) {
        CssPreviewTopComponent.findInstance().activate(content);
    }

    private void firePreviewableDeactivated() {
        CssPreviewTopComponent.findInstance().deactivate();
    }

    private void d(String s) {
        if (DEBUG) {
            LOGGER.log(Level.INFO, s);
        }
    }

    public void firstAggregatedEventWillFire() {
        this.aggregated_events = true;
        this.d("firstAggregatedEventWillFire");
    }

    public void lastAggregatedEventFired() {
        this.aggregated_events = false;
        if (this.selected != null) {
            this.d("lastAggregatedEventFired: css style data listener - detaching from rule content.");
            this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
        }
    }
}

