/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class PageFlowElement
extends CloneableEditor
implements MultiViewElement,
Serializable {
    private static final Logger LOG = Logger.getLogger(PageFlowElement.class.getName());
    private transient PageFlowView tc;
    private transient JComponent toolbar;
    private static final long serialVersionUID = 5454879177214643L;
    private JSFConfigEditorContext context;
    private DataObject dataObject;
    private MultiViewElementCallback callback;

    public PageFlowElement(Lookup lookup) {
        super((CloneableEditorSupport)lookup.lookup(DataEditorSupport.class));
        this.context = (JSFConfigEditorContext)lookup.lookup(JSFConfigEditorContext.class);
        this.dataObject = (DataObject)lookup.lookup(DataObject.class);
        assert (this.context != null);
        this.init();
    }

    private void init() {
        this.getTopComponent().setName(this.context.getFacesConfigFile().getName());
    }

    public JComponent getVisualRepresentation() {
        return this.tc;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = this.getTopComponent().getToolbarRepresentation();
        }
        return this.toolbar;
    }

    private PageFlowView getTopComponent() {
        if (this.tc == null) {
            this.tc = new PageFlowView(this, this.context);
        }
        return this.tc;
    }

    public Action[] getActions() {
        Action[] actionArray = this.tc.getActions();
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<SystemAction> clazz = Class.forName("org.openide.actions.FileSystemAction", true, classLoader).asSubclass(SystemAction.class);
            SystemAction systemAction = (SystemAction)SystemAction.findObject(clazz, (boolean)true);
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            actionArray2[actionArray.length] = systemAction;
            return actionArray2;
        }
        catch (Exception exception) {
            return new Action[0];
        }
    }

    public Lookup getLookup() {
        return this.tc.getLookup();
    }

    public void componentOpened() {
        this.tc.registerListeners();
        LOG.finest("PageFlowEditor componentOpened");
    }

    public void componentClosed() {
        long l = System.currentTimeMillis();
        FileObject fileObject = PageFlowView.getStorageFile(this.context.getFacesConfigFile());
        if (fileObject != null && fileObject.isValid()) {
            this.tc.serializeNodeLocations(fileObject);
        } else {
            DialogDescriptor dialogDescriptor = fileObject != null ? new DialogDescriptor((Object)NbBundle.getMessage(PageFlowElement.class, (String)"MSG_NoFileToSave", (Object)fileObject), NbBundle.getMessage(PageFlowElement.class, (String)"TLE_NoFileToSave")) : new DialogDescriptor((Object)NbBundle.getMessage(PageFlowElement.class, (String)"MSG_NoProjectToSave"), NbBundle.getMessage(PageFlowElement.class, (String)"TLE_NoFileToSave"));
            dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
        this.tc.unregstierListeners();
        PageFlowToolbarUtilities.removePageFlowView(this.tc);
        this.tc.destroyScene();
        this.toolbar = null;
        this.tc = null;
        LOG.finest("PageFlowEditor componentClosed took: " + (System.currentTimeMillis() - l) + " ms");
    }

    public void componentShowing() {
        LOG.finest("PageFlowEditor componentShowing");
        this.tc.getPageFlowController().flushGraphIfDirty();
    }

    public void componentHidden() {
        LOG.finest("PageFlowEditor componentHidden");
    }

    public void componentActivated() {
        LOG.finest("PageFlowView componentActivated");
        this.tc.requestActive();
    }

    public void componentDeactivated() {
        LOG.finest("PageFlowView Deactivated");
    }

    public MultiViewElementCallback getMultiViewCallback() {
        return this.callback;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.callback = multiViewElementCallback;
        this.context.setMultiViewTopComponent(multiViewElementCallback.getTopComponent());
    }

    public CloseOperationState canCloseElement() {
        if (!this.getEditorSupport().isModified()) {
            return CloseOperationState.STATE_OK;
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PageFlowElement.this.getEditorSupport().saveDocument();
                    PageFlowElement.this.getEditorSupport().getDataObject().setModified(false);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "File {0} couldn''t be saved.", PageFlowElement.this.context.getFacesConfigFile().getName());
                }
            }
        };
        abstractAction.putValue("LongDescription", NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.getEditorSupport().getDataObject().getPrimaryFile().getNameExt()));
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FACES_CONFIG_CLOSING", (Action)abstractAction, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.tc.serializeNodeLocations(PageFlowView.getStorageFile(this.context.getFacesConfigFile()));
        objectOutputStream.writeObject(this.context);
        LOG.finest("writeObject");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof JSFConfigEditorContext)) {
            throw new ClassNotFoundException("JSFConfigEditorContext expected but not found");
        }
        this.context = (JSFConfigEditorContext)object;
        this.init();
        LOG.finest("readObject");
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.cloneableEditorSupport();
    }

    public UndoRedo getUndoRedo() {
        return this.context.getUndoRedo();
    }
}

