/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DependencyPanel
extends TopComponent
implements MultiViewElement,
LookupListener {
    private static final String DEPENDENCY = "org/netbeans/modules/maven/repository/ui/DependencyIcon.png";
    private static final String TRANSITIVE_DEPENDENCY = "org/netbeans/modules/maven/repository/ui/TransitiveDependencyIcon.png";
    private Lookup.Result<DependencyNode> result;
    private JToolBar toolbar;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblCompile;
    private JLabel lblHint;
    private JLabel lblRuntime;
    private JLabel lblTest;
    private JList lstCompile;
    private JList lstRuntime;
    private JList lstTest;

    DependencyPanel(Lookup lookup) {
        super(lookup);
        this.initComponents();
        Rend r = new Rend();
        this.lstTest.setCellRenderer(r);
        this.lstRuntime.setCellRenderer(r);
        this.lstCompile.setCellRenderer(r);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MavenProject prj;
                DependencyNode nd;
                if (e.getClickCount() > 1 && (nd = (DependencyNode)((JList)e.getComponent()).getSelectedValue()) != null && (prj = (MavenProject)DependencyPanel.this.getLookup().lookup(MavenProject.class)) != null) {
                    ArtifactViewer.showArtifactViewer((Artifact)nd.getArtifact(), (List)prj.getRemoteArtifactRepositories(), (String)"dep");
                }
            }
        };
        this.lstTest.addMouseListener(ml);
        this.lstRuntime.addMouseListener(ml);
        this.lstCompile.addMouseListener(ml);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel1.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblCompile = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCompile = new JList();
        this.lblRuntime = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstRuntime = new JList();
        this.lblTest = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstTest = new JList();
        this.lblHint = new JLabel();
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.lblCompile.setLabelFor(this.lstCompile);
        Mnemonics.setLocalizedText((JLabel)this.lblCompile, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblCompile.text"));
        this.jScrollPane1.setViewportView(this.lstCompile);
        this.lstCompile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstCompile.AccessibleContext.accessibleDescription"));
        this.lblRuntime.setLabelFor(this.lstRuntime);
        Mnemonics.setLocalizedText((JLabel)this.lblRuntime, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblRuntime.text"));
        this.jScrollPane2.setViewportView(this.lstRuntime);
        this.lstRuntime.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstRuntime.AccessibleContext.accessibleDescription"));
        this.lblTest.setLabelFor(this.lstTest);
        Mnemonics.setLocalizedText((JLabel)this.lblTest, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblTest.text"));
        this.jScrollPane3.setViewportView(this.lstTest);
        this.lstTest.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstTest.AccessibleContext.accessibleDescription"));
        this.lblHint.setText(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblHint.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblHint, GroupLayout.Alignment.LEADING, -1, 511, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCompile).addComponent(this.jScrollPane1, -1, 170, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRuntime).addComponent(this.jScrollPane2, -1, 172, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTest).addComponent(this.jScrollPane3, -1, 145, Short.MAX_VALUE)))).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCompile).addComponent(this.lblRuntime).addComponent(this.lblTest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 234, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 234, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 234, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint).addContainerGap())));
        this.add(this.jPanel1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleDescription"));
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            Action[] a = new Action[1];
            Action[] actions = (Action[])this.getLookup().lookup(a.getClass());
            Dimension space = new Dimension(3, 0);
            this.toolbar.addSeparator(space);
            for (Action act : actions) {
                JButton btn = new JButton();
                Actions.connect((AbstractButton)btn, (Action)act);
                this.toolbar.add(btn);
                this.toolbar.addSeparator(space);
            }
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.result = this.getLookup().lookup(new Lookup.Template(DependencyNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DependencyPanel.this.populateFields();
            }
        });
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void populateFields() {
        Iterator iter = this.result.allInstances().iterator();
        if (iter.hasNext()) {
            final DependencyNode root = (DependencyNode)iter.next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstCompile, root, Arrays.asList("compile", "provided"));
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstRuntime, root, Arrays.asList("runtime"));
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstTest, root, Arrays.asList("test"));
                }
            });
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.populateFields();
    }

    private void setDepModel(JList lst, DependencyNode root, List<String> scopes) {
        DefaultListModel<DependencyNode> dlm = new DefaultListModel<DependencyNode>();
        NodeVisitor vis = new NodeVisitor(scopes);
        root.accept((DependencyNodeVisitor)vis);
        for (DependencyNode d : vis.getDirects()) {
            dlm.addElement(d);
        }
        for (DependencyNode d : vis.getTransitives()) {
            dlm.addElement(d);
        }
        lst.setModel(dlm);
        lst.putClientProperty("directs", vis.getDirects());
        lst.putClientProperty("trans", vis.getTransitives());
    }

    private static class NodeVisitor
    implements DependencyNodeVisitor {
        private List<DependencyNode> directs;
        private List<DependencyNode> trans;
        private List<String> scopes;
        private DependencyNode root;
        private Stack<DependencyNode> path;

        private NodeVisitor(List<String> scopes) {
            this.scopes = scopes;
        }

        public boolean visit(DependencyNode node) {
            if (this.root == null) {
                this.root = node;
                this.directs = new ArrayList<DependencyNode>();
                this.trans = new ArrayList<DependencyNode>();
                this.path = new Stack();
                return true;
            }
            if (node.getState() == 0 && this.scopes.contains(node.getArtifact().getScope())) {
                if (this.path.empty()) {
                    this.directs.add(node);
                } else {
                    this.trans.add(node);
                }
            }
            this.path.push(node);
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            if (this.root == node) {
                this.root = null;
                this.path = null;
                return true;
            }
            this.path.pop();
            return true;
        }

        private Iterable<DependencyNode> getDirects() {
            return this.directs;
        }

        private Iterable<DependencyNode> getTransitives() {
            return this.trans;
        }
    }

    private static class Rend
    extends DefaultListCellRenderer {
        private Rend() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cmp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DependencyNode) {
                DependencyNode d = (DependencyNode)value;
                JLabel lbl = (JLabel)cmp;
                lbl.setText(d.getArtifact().getArtifactId() + ":" + d.getArtifact().getVersion());
                List dirs = (List)list.getClientProperty("directs");
                if (dirs.contains(d)) {
                    lbl.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)DependencyPanel.DEPENDENCY, (boolean)true)));
                } else {
                    lbl.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)DependencyPanel.TRANSITIVE_DEPENDENCY, (boolean)true)));
                }
            }
            return cmp;
        }
    }
}

