/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.repository.ui.Bundle;
import org.openide.awt.Actions;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class BasicArtifactPanel
extends TopComponent
implements MultiViewElement {
    private static final RequestProcessor RP = new RequestProcessor(BasicArtifactPanel.class);
    private boolean renderType = false;
    private JToolBar toolbar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblArtifactId;
    private JLabel lblClassifier;
    private JLabel lblGroupId;
    private JLabel lblPackaging;
    private JLabel lblVersion;
    private JList lstClassifiers;
    private JList lstVersions;
    private JTextField txtArtifactId;
    private JTextField txtClassifier;
    private JTextField txtGroupId;
    private JTextField txtLastModified;
    private JTextField txtPackaging;
    private JTextField txtSHA;
    private JTextField txtSize;
    private JTextField txtVersion;

    public BasicArtifactPanel(Lookup lookup) {
        super(lookup);
        this.initComponents();
        this.lstVersions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() > 1 && e.getButton() == 1) {
                    Object obj = BasicArtifactPanel.this.lstVersions.getSelectedValue();
                    if (obj instanceof String) {
                        return;
                    }
                    NBVersionInfo info = (NBVersionInfo)obj;
                    if (info != null) {
                        ArtifactViewer.showArtifactViewer((NBVersionInfo)info);
                    }
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.lstVersions.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof NBVersionInfo) {
                    NBVersionInfo info = (NBVersionInfo)value;
                    if (BasicArtifactPanel.this.renderType) {
                        ((JLabel)c).setText(info.getVersion() + "  [" + info.getType() + "]");
                    } else {
                        ((JLabel)c).setText(info.getVersion());
                    }
                }
                return c;
            }
        });
        this.lstVersions.setSelectionMode(0);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.jPanel1.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel2.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel3.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel4.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel5.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private String computeSize(long size) {
        long kbytes = size / 1024L;
        if (kbytes == 0L) {
            return Bundle.TXT_Bytes(size);
        }
        long mbytes = kbytes / 1024L;
        if (mbytes == 0L) {
            return Bundle.TXT_kb(kbytes);
        }
        return Bundle.TXT_Mb(mbytes);
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblPackaging = new JLabel();
        this.txtPackaging = new JTextField();
        this.lblClassifier = new JLabel();
        this.txtClassifier = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtLastModified = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtSHA = new JTextField();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstVersions = new JList();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstClassifiers = new JList();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jPanel1.border.title")));
        this.lblGroupId.setLabelFor(this.txtGroupId);
        this.lblGroupId.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblGroupId.text"));
        this.txtGroupId.setEditable(false);
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        this.lblArtifactId.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblArtifactId.text"));
        this.txtArtifactId.setEditable(false);
        this.lblVersion.setLabelFor(this.txtVersion);
        this.lblVersion.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblVersion.text"));
        this.txtVersion.setEditable(false);
        this.lblPackaging.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblPackaging.text"));
        this.txtPackaging.setEditable(false);
        this.lblClassifier.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblClassifier.text"));
        this.txtClassifier.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGroupId).addComponent(this.lblArtifactId).addComponent(this.lblVersion).addComponent(this.lblPackaging).addComponent(this.lblClassifier)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtClassifier).addComponent(this.txtArtifactId, -1, 316, Short.MAX_VALUE).addComponent(this.txtGroupId, -1, 316, Short.MAX_VALUE).addComponent(this.txtVersion, -1, 316, Short.MAX_VALUE).addComponent(this.txtPackaging, -1, 316, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroupId).addComponent(this.txtGroupId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblArtifactId).addComponent(this.txtArtifactId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVersion).addComponent(this.txtVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPackaging).addComponent(this.txtPackaging, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblClassifier).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.txtClassifier, -2, -1, -2).addGap(1, 1, 1))).addContainerGap(71, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_PrimaryArtifact")));
        this.jLabel1.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel1.text"));
        this.txtSize.setEditable(false);
        this.jLabel2.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel2.text"));
        this.txtLastModified.setEditable(false);
        this.jLabel3.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel3.text"));
        this.txtSHA.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtLastModified, -1, 276, Short.MAX_VALUE).addComponent(this.txtSize, -1, 276, Short.MAX_VALUE).addComponent(this.txtSHA, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtLastModified, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtSHA, -2, -1, -2)).addContainerGap(119, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_Versions")));
        this.jScrollPane2.setViewportView(this.lstVersions);
        this.jLabel4.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel4.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 211, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -1, 211, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 158, Short.MAX_VALUE).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_SecondaryArtifacts")));
        this.jScrollPane3.setViewportView(this.lstClassifiers);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 211, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 164, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(123, 123, 123)));
        this.jScrollPane1.setViewportView(this.jPanel3);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 699, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 491, Short.MAX_VALUE));
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            Action[] a = new Action[1];
            Action[] actions = (Action[])this.getLookup().lookup(a.getClass());
            Dimension space = new Dimension(3, 0);
            this.toolbar.addSeparator(space);
            for (Action act : actions) {
                JButton btn = new JButton();
                Actions.connect((AbstractButton)btn, (Action)act);
                this.toolbar.add(btn);
                this.toolbar.addSeparator(space);
            }
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentOpened() {
        final Artifact artifact = (Artifact)this.getLookup().lookup(Artifact.class);
        assert (artifact != null);
        NBVersionInfo info = (NBVersionInfo)this.getLookup().lookup(NBVersionInfo.class);
        if (info != null) {
            this.txtGroupId.setText(info.getGroupId());
            this.txtArtifactId.setText(info.getArtifactId());
            this.txtVersion.setText(info.getVersion());
            this.txtPackaging.setText(info.getType());
            this.txtClassifier.setText(info.getClassifier());
            this.txtSize.setText(this.computeSize(info.getSize()));
            this.txtLastModified.setText("" + new Date(info.getLastModified()));
        } else {
            this.txtGroupId.setText(artifact.getGroupId());
            this.txtArtifactId.setText(artifact.getArtifactId());
            this.txtVersion.setText(artifact.getVersion());
            this.txtPackaging.setText(artifact.getType());
            this.txtClassifier.setText(artifact.getClassifier());
        }
        final DefaultListModel<String> dlm = new DefaultListModel<String>();
        dlm.addElement(Bundle.TXT_Loading());
        this.lstVersions.setModel(dlm);
        RP.post(new Runnable(){

            @Override
            public void run() {
                RepositoryQueries.Result result = RepositoryQueries.getVersionsResult((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
                final List infos = result.getResults();
                DefaultArtifactVersion av = new DefaultArtifactVersion(artifact.getVersion());
                SwingUtilities.invokeLater(new Runnable((ArtifactVersion)av, result){
                    final /* synthetic */ ArtifactVersion val$av;
                    final /* synthetic */ RepositoryQueries.Result val$result;
                    {
                        this.val$av = artifactVersion;
                        this.val$result = result;
                    }

                    @Override
                    public void run() {
                        dlm.removeAllElements();
                        for (NBVersionInfo ver : infos) {
                            if (!this.val$av.equals(new DefaultArtifactVersion(ver.getVersion()))) {
                                dlm.addElement(ver);
                            }
                            if (artifact.getType().equals(ver.getType())) continue;
                            BasicArtifactPanel.this.renderType = true;
                        }
                        if (this.val$result.isPartial()) {
                            dlm.addElement(Bundle.TXT_INCOMPLETE());
                        }
                    }
                });
            }
        });
        final DefaultListModel<String> mdl = new DefaultListModel<String>();
        mdl.addElement(Bundle.TXT_Loading());
        this.lstClassifiers.setModel(mdl);
        RP.post(new Runnable(){

            @Override
            public void run() {
                final RepositoryQueries.Result result = RepositoryQueries.getRecordsResult((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
                List infos = result.getResults();
                final TreeSet<String> classifiers = new TreeSet<String>();
                boolean hasJavadoc = false;
                boolean hasSource = false;
                for (NBVersionInfo inf : infos) {
                    if (inf.getClassifier() != null) {
                        classifiers.add(inf.getClassifier());
                    }
                    if (inf.isJavadocExists()) {
                        hasJavadoc = true;
                    }
                    if (!inf.isSourcesExists()) continue;
                    hasSource = true;
                }
                if (hasSource) {
                    classifiers.add("source");
                }
                if (hasJavadoc) {
                    classifiers.add("javadoc");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mdl.removeAllElements();
                        for (String ver : classifiers) {
                            mdl.addElement(ver);
                        }
                        if (result.isPartial()) {
                            mdl.addElement(Bundle.TXT_INCOMPLETE());
                        }
                    }
                });
            }
        });
        File artFile = FileUtilities.convertArtifactToLocalRepositoryFile((Artifact)artifact);
        if (artFile.exists()) {
            try {
                String sha = RepositoryUtil.calculateSHA1Checksum((File)artFile);
                this.txtSHA.setText(sha);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.txtSHA.setText(Bundle.MSG_FailedSHA1());
            }
        } else {
            this.txtSHA.setText(Bundle.MSG_NOSHA());
        }
    }

    public void componentShowing() {
        super.componentShowing();
    }
}

