/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.ContainerItemSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.JerseyPanel;
import org.netbeans.modules.websvc.rest.wizard.SingletonSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PatternResourcesSetupPanel
extends AbstractPanel {
    private JComponent component;
    private Pattern currentPattern = Pattern.CONTAINER;
    private String[] allWizardSteps;
    private int indexInAllSteps = 2;

    public PatternResourcesSetupPanel(String string, WizardDescriptor wizardDescriptor) {
        super(string, wizardDescriptor);
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    public void setCurrentPattern(Pattern pattern) {
        if (this.currentPattern != pattern) {
            this.component = null;
            this.currentPattern = pattern;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.currentPattern.createUI(this.panelName);
            if (this.allWizardSteps != null) {
                this.component.putClientProperty("WizardPanel_contentData", this.allWizardSteps);
                this.component.putClientProperty("WizardPanel_contentSelectedIndex", this.indexInAllSteps);
            }
            this.component.setName(this.panelName);
            ((AbstractPanel.Settings)((Object)this.component)).addChangeListener(this);
        }
        return this.component;
    }

    void saveStepsAndIndex() {
        if (this.component != null) {
            this.allWizardSteps = (String[])this.component.getClientProperty("WizardPanel_contentData");
            this.indexInAllSteps = (Integer)this.component.getClientProperty("WizardPanel_contentSelectedIndex");
        }
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PatternResourcesSetupPanel.class.getCanonicalName() + "." + (Object)((Object)this.currentPattern));
    }

    public static enum Pattern {
        CONTAINER,
        STANDALONE,
        CLIENTCONTROLLED;


        public JComponent createUI(String string) {
            return new PatternPanel(string, this);
        }
    }

    static class PatternPanel
    extends JPanel
    implements AbstractPanel.Settings,
    SourcePanel {
        private static final long serialVersionUID = -5802330662876130253L;
        private AbstractPanel.Settings mainPanel;
        private JerseyPanel jerseyPanel;

        PatternPanel(String string, Pattern pattern) {
            JPanel jPanel = null;
            switch (pattern) {
                case CONTAINER: 
                case CLIENTCONTROLLED: {
                    jPanel = new ContainerItemSetupPanelVisual(string);
                    break;
                }
                case STANDALONE: {
                    jPanel = new SingletonSetupPanelVisual(string);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.setLayout(new BoxLayout(this, 1));
            this.add(jPanel);
            this.mainPanel = jPanel;
            this.jerseyPanel = new JerseyPanel(this);
            this.mainPanel.addChangeListener(this.jerseyPanel);
            this.add(this.jerseyPanel);
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    final 1 var2_2 = this;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Component[] componentArray;
                            double d = 0.0;
                            for (Component component : componentArray = PatternPanel.this.getComponents()) {
                                double d2;
                                if (component instanceof SingletonSetupPanelVisual) {
                                    d2 = ((SingletonSetupPanelVisual)component).getRenderedHeight();
                                    d += d2;
                                    PatternPanel.this.resize(component, d2);
                                    continue;
                                }
                                if (component instanceof ContainerItemSetupPanelVisual) {
                                    d2 = ((ContainerItemSetupPanelVisual)component).getRenderedHeight();
                                    d += d2;
                                    PatternPanel.this.resize(component, d2);
                                    continue;
                                }
                                if (!(component instanceof JerseyPanel)) continue;
                                d2 = ((JerseyPanel)component).getRenderedHeight();
                                d += d2;
                                PatternPanel.this.resize(component, d2);
                            }
                            Dimension dimension = PatternPanel.this.getSize();
                            int n = (int)d;
                            if (dimension.height < n) {
                                PatternPanel.this.setPreferredSize(new Dimension(dimension.width, n));
                                Window window = SwingUtilities.getWindowAncestor(PatternPanel.this);
                                if (window != null) {
                                    window.pack();
                                }
                            }
                            PatternPanel.this.removeHierarchyListener(var2_2);
                        }
                    });
                }
            });
        }

        @Override
        public SourceGroup getSourceGroup() {
            return ((SourcePanel)((Object)this.mainPanel)).getSourceGroup();
        }

        @Override
        public void read(final WizardDescriptor wizardDescriptor) {
            boolean bl;
            this.mainPanel.read(wizardDescriptor);
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            Profile profile = webModule.getJ2eeProfile();
            final RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            boolean bl2 = restSupport != null && restSupport.hasSpringSupport();
            boolean bl3 = bl = Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile);
            if (bl2) {
                wizardDescriptor.putProperty("useJersey", (Object)true);
            }
            if (this.jerseyPanel != null) {
                if (!bl || bl2 || restSupport.isRestSupportOn()) {
                    this.remove(this.jerseyPanel);
                    this.jerseyPanel = null;
                }
                if (restSupport instanceof WebRestSupport) {
                    ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            List list = ((WebRestSupport)restSupport).getRestApplications();
                            boolean bl = list != null && !list.isEmpty();
                            PatternPanel.this.configureJersey(bl, wizardDescriptor);
                        }
                    }, (String)NbBundle.getMessage(PatternResourcesSetupPanel.class, (String)"LBL_SearchAppConfig"));
                } else {
                    this.jerseyPanel.read(wizardDescriptor);
                }
            }
        }

        @Override
        public void store(WizardDescriptor wizardDescriptor) {
            this.mainPanel.store(wizardDescriptor);
            if (this.hasJerseyPanel()) {
                this.jerseyPanel.store(wizardDescriptor);
            }
        }

        @Override
        public boolean valid(WizardDescriptor wizardDescriptor) {
            boolean bl = this.mainPanel.valid(wizardDescriptor);
            if (bl && this.hasJerseyPanel()) {
                return this.jerseyPanel.valid(wizardDescriptor);
            }
            return bl;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.mainPanel.addChangeListener(changeListener);
            if (this.hasJerseyPanel()) {
                this.jerseyPanel.addChangeListener(changeListener);
            }
        }

        private void resize(Component component, double d) {
            Dimension dimension = component.getSize();
            if ((double)dimension.height < d) {
                component.setPreferredSize(new Dimension(dimension.width, (int)d));
            }
        }

        private boolean hasJerseyPanel() {
            return this.jerseyPanel != null;
        }

        private void configureJersey(boolean bl, WizardDescriptor wizardDescriptor) {
            if (this.jerseyPanel == null) {
                return;
            }
            if (bl) {
                this.remove(this.jerseyPanel);
                this.jerseyPanel = null;
            } else {
                this.jerseyPanel.read(wizardDescriptor);
            }
        }
    }
}

