/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class AbstractPanel
implements ChangeListener,
WizardDescriptor.FinishablePanel,
WizardDescriptor.Panel {
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    protected String panelName;
    protected WizardDescriptor wizardDescriptor;

    public AbstractPanel(String name, WizardDescriptor wizardDescriptor) {
        this.panelName = name;
        this.wizardDescriptor = wizardDescriptor;
    }

    public abstract Component getComponent();

    public abstract boolean isFinishPanel();

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        ((Settings)((Object)this.getComponent())).read(this.wizardDescriptor);
    }

    public void storeSettings(Object settings) {
        WizardDescriptor d = (WizardDescriptor)settings;
        ((Settings)((Object)this.getComponent())).store(this.wizardDescriptor);
    }

    public boolean isValid() {
        if (this.getComponent() instanceof Settings) {
            return ((Settings)((Object)this.getComponent())).valid(this.wizardDescriptor);
        }
        return false;
    }

    public final void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    protected final void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public static void clearMessage(WizardDescriptor wizard, MessageType type) {
        AbstractPanel.setMessage(wizard, type, (String)null);
    }

    public static void clearErrorMessage(WizardDescriptor wizard) {
        AbstractPanel.setMessage(wizard, MessageType.ERROR, (String)null);
    }

    public static void clearInfoMessage(WizardDescriptor wizard) {
        AbstractPanel.setMessage(wizard, MessageType.INFO, (String)null);
    }

    public static void setMessage(WizardDescriptor wizard, Throwable t, MessageType type) {
        String message = "";
        if (t != null) {
            message = t.getLocalizedMessage();
        }
        wizard.putProperty(type.getName(), (Object)message);
    }

    static void setMessage(WizardDescriptor wizard, MessageType type, String key, String ... params) {
        String message = "";
        if (key != null) {
            message = NbBundle.getMessage(AbstractPanel.class, (String)key, (Object[])params);
        }
        wizard.putProperty(type.getName(), (Object)message);
    }

    public static void setMessage(WizardDescriptor wizard, MessageType type, String key) {
        String message = "";
        if (key != null) {
            message = NbBundle.getMessage(AbstractPanel.class, (String)key);
        }
        wizard.putProperty(type.getName(), (Object)message);
    }

    protected void setMessage(MessageType type, String key) {
        AbstractPanel.setMessage(this.wizardDescriptor, type, key);
    }

    public static void setErrorMessage(WizardDescriptor wizard, String key) {
        AbstractPanel.setMessage(wizard, MessageType.ERROR, key);
    }

    protected void setErrorMessage(String key) {
        AbstractPanel.setMessage(this.wizardDescriptor, MessageType.ERROR, key);
    }

    public static void setInfoMessage(WizardDescriptor wizard, String key) {
        AbstractPanel.setMessage(wizard, MessageType.INFO, key);
    }

    protected void setInfoMessage(String key) {
        AbstractPanel.setMessage(this.wizardDescriptor, MessageType.INFO, key);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component c = this.getComponent();
        if (c instanceof Settings) {
            ((Settings)((Object)c)).valid(this.wizardDescriptor);
        }
        this.fireChangeEvent(e);
    }

    public String getName() {
        return this.panelName;
    }

    public static enum MessageType {
        INFO("WizardPanel_infoMessage"),
        WARNING("WizardPanel_warningMessage"),
        ERROR("WizardPanel_errorMessage");

        private String name;

        private MessageType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface Settings {
        public void read(WizardDescriptor var1);

        public void store(WizardDescriptor var1);

        public boolean valid(WizardDescriptor var1);

        public void addChangeListener(ChangeListener var1);
    }
}

