/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.client.RESTExplorerPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TestRestTargetPanel
extends JPanel {
    private static final String TEST_CLIENT_PROJECT = "test.client.project";
    private static final RESTExplorerPanel.ProjectNodeFactory WEB_PROJECT_FACTORY = new WebProjectFactory();
    private JButton myBrowse;
    private ButtonGroup myButtonGroup;
    private JRadioButton myLocal;
    private JEditorPane myNotice;
    private JLabel myNoticeLbl;
    private JRadioButton myRemote;
    private JScrollPane myScrollPane;
    private JTextField myTarget;
    private JLabel myTargetLbl;
    private Project myProject;
    private Project myChosenProject;
    private DialogDescriptor myDescriptor;
    private boolean isRemote;

    public TestRestTargetPanel(Project project) {
        this.myProject = project;
        this.initComponents();
        this.myNotice.setText(NbBundle.getMessage(TestRestTargetPanel.class, (String)"TXT_Notice"));
        this.myLocal.setSelected(true);
        this.myBrowse.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == TestRestTargetPanel.this.myLocal) {
                    TestRestTargetPanel.this.myBrowse.setEnabled(false);
                    TestRestTargetPanel.this.setTargetProject(TestRestTargetPanel.this.myProject, false);
                    TestRestTargetPanel.this.storeSelectedProject();
                } else if (object == TestRestTargetPanel.this.myRemote) {
                    TestRestTargetPanel.this.myBrowse.setEnabled(true);
                    TestRestTargetPanel.this.setTargetProject(null, false);
                    TestRestTargetPanel.this.storeSelectedProject();
                }
            }
        };
        this.myLocal.addActionListener(actionListener);
        this.myRemote.addActionListener(actionListener);
        this.myBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RESTExplorerPanel rESTExplorerPanel = new RESTExplorerPanel(WEB_PROJECT_FACTORY);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rESTExplorerPanel, NbBundle.getMessage(TestRestTargetPanel.class, (String)"TTL_Projects"));
                rESTExplorerPanel.setDescriptor(dialogDescriptor);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
                    Node node = rESTExplorerPanel.getSelectedService();
                    TestRestTargetPanel.this.setTargetProject((Project)node.getLookup().lookup(Project.class), true);
                    TestRestTargetPanel.this.storeSelectedProject();
                }
            }
        });
        this.initTargetProject();
    }

    Project getProject() {
        return this.myChosenProject;
    }

    boolean isRemote() {
        return this.isRemote;
    }

    void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.myDescriptor = dialogDescriptor;
    }

    private void initComponents() {
        this.myButtonGroup = new ButtonGroup();
        this.myLocal = new JRadioButton();
        this.myRemote = new JRadioButton();
        this.myBrowse = new JButton();
        this.myTargetLbl = new JLabel();
        this.myTarget = new JTextField();
        this.myNoticeLbl = new JLabel();
        this.myScrollPane = new JScrollPane();
        this.myNotice = new JEditorPane();
        this.myButtonGroup.add(this.myLocal);
        Mnemonics.setLocalizedText((AbstractButton)this.myLocal, (String)NbBundle.getMessage(TestRestTargetPanel.class, (String)"LBL_Local"));
        this.myButtonGroup.add(this.myRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.myRemote, (String)NbBundle.getMessage(TestRestTargetPanel.class, (String)"LBL_Remote"));
        this.myRemote.setActionCommand(NbBundle.getMessage(TestRestTargetPanel.class, (String)"TestRestTargetPanel.myRemote.actionCommand"));
        Mnemonics.setLocalizedText((AbstractButton)this.myBrowse, (String)NbBundle.getMessage(TestRestTargetPanel.class, (String)"LBL_Browse"));
        this.myTargetLbl.setLabelFor(this.myTarget);
        Mnemonics.setLocalizedText((JLabel)this.myTargetLbl, (String)NbBundle.getMessage(TestRestTargetPanel.class, (String)"LBL_Target"));
        this.myTarget.setEditable(false);
        this.myNoticeLbl.setLabelFor(this.myNotice);
        Mnemonics.setLocalizedText((JLabel)this.myNoticeLbl, (String)NbBundle.getMessage(TestRestTargetPanel.class, (String)"LBL_Notion"));
        this.myNotice.setContentType("text/html");
        this.myNotice.setEditable(false);
        this.myScrollPane.setViewportView(this.myNotice);
        this.myNotice.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_NoticeDescr"));
        this.myNotice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_NoticeDescr"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myScrollPane, GroupLayout.Alignment.TRAILING, -1, 549, Short.MAX_VALUE).addComponent(this.myLocal).addGroup(groupLayout.createSequentialGroup().addComponent(this.myRemote).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myBrowse)).addGroup(groupLayout.createSequentialGroup().addComponent(this.myTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myTarget, -1, 476, Short.MAX_VALUE)).addComponent(this.myNoticeLbl)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.myLocal).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myRemote).addComponent(this.myBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myTargetLbl).addComponent(this.myTarget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myNoticeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myScrollPane, -1, 140, Short.MAX_VALUE).addContainerGap()));
        this.myLocal.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_Local"));
        this.myLocal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_Local"));
        this.myRemote.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_Remote"));
        this.myRemote.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_Remote"));
        this.myBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_Browse"));
        this.myBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_Browse"));
        this.myTargetLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_Target"));
        this.myTargetLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_Target"));
        this.myTarget.getAccessibleContext().setAccessibleName(this.myTargetLbl.getAccessibleContext().getAccessibleName());
        this.myTarget.getAccessibleContext().setAccessibleDescription(this.myTargetLbl.getAccessibleContext().getAccessibleDescription());
        this.myNoticeLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSN_Notice"));
        this.myNoticeLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestRestTargetPanel.class, (String)"ACSD_Notice"));
    }

    private void initTargetProject() {
        RestSupport restSupport = (RestSupport)this.myProject.getLookup().lookup(RestSupport.class);
        String string = restSupport.getProjectProperty(TEST_CLIENT_PROJECT);
        if (string == null) {
            this.setTargetProject(this.myProject, false);
        } else {
            this.myLocal.setSelected(false);
            this.myRemote.setSelected(true);
            this.myBrowse.setEnabled(true);
            File file = new File(string);
            if (file.exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                this.setTargetProject(project, true);
            }
        }
    }

    private void storeSelectedProject() {
        RestSupport restSupport = (RestSupport)this.myProject.getLookup().lookup(RestSupport.class);
        if (this.isRemote) {
            FileObject fileObject = this.myChosenProject.getProjectDirectory();
            try {
                String string = FileUtil.toFile((FileObject)fileObject).getCanonicalPath();
                restSupport.setPrivateProjectProperty(TEST_CLIENT_PROJECT, string);
            }
            catch (IOException iOException) {
                Logger.getLogger(TestRestTargetPanel.class.getCanonicalName()).log(Level.INFO, null, iOException);
            }
        } else {
            restSupport.removeProjectProperties(new String[]{TEST_CLIENT_PROJECT});
        }
    }

    private void setTargetProject(Project project, boolean bl) {
        this.isRemote = bl;
        this.myChosenProject = project;
        if (this.myDescriptor != null) {
            this.myDescriptor.setValid(project != null);
        }
        if (project == null) {
            this.myTarget.setText("");
            return;
        }
        if (bl) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("doc_root");
            SourceGroup sourceGroup = sourceGroupArray[0];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            this.myTarget.setText(file.getPath());
        } else {
            RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            File file = restSupport.getLocalTargetTestRest();
            if (file != null) {
                this.myTarget.setText(file.getPath());
            }
        }
    }

    private static class WebProjectFactory
    implements RESTExplorerPanel.ProjectNodeFactory {
        private WebProjectFactory() {
        }

        @Override
        public Node createNode(Project project) {
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("doc_root");
            if (logicalViewProvider != null && restSupport != null && sourceGroupArray != null && sourceGroupArray.length > 0) {
                Node node = logicalViewProvider.createLogicalView();
                return new FilterNode(node, Children.LEAF);
            }
            return null;
        }

        @Override
        public boolean canSelect(Node node) {
            return true;
        }
    }
}

