/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.RestServiceNode;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

class RestServiceChildFactory
extends ChildFactory {
    private static final Logger LOG = Logger.getLogger(RestServiceChildFactory.class.getName());
    private static final RSDescriptionComparator COMPARATOR = new RSDescriptionComparator();
    private Project project;

    RestServiceChildFactory(Project project) {
        this.project = project;
    }

    protected boolean createKeys(final List list) {
        try {
            RestServicesModel restServicesModel = this.getModel();
            assert (restServicesModel != null) : "null model";
            if (restServicesModel != null) {
                restServicesModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                        RestServiceDescription[] restServiceDescriptionArray = restServicesMetadata.getRoot().getRestServiceDescription();
                        Arrays.sort(restServiceDescriptionArray, COMPARATOR);
                        list.addAll(Arrays.asList(restServiceDescriptionArray));
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
        return true;
    }

    protected Node createNodeForKey(Object object) {
        assert (object instanceof RestServiceDescription);
        return new RestServiceNode(this.project, this.getModel(), (RestServiceDescription)object);
    }

    private RestServicesModel getModel() {
        RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            return restSupport.getRestServicesModel();
        }
        return null;
    }

    private static class RSDescriptionComparator
    implements Comparator<RestServiceDescription> {
        private RSDescriptionComparator() {
        }

        @Override
        public int compare(RestServiceDescription restServiceDescription, RestServiceDescription restServiceDescription2) {
            String string = RestServiceNode.getKey(restServiceDescription);
            String string2 = RestServiceNode.getKey(restServiceDescription2);
            return string.compareTo(string2);
        }
    }
}

