/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.HttpMethodNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class HttpMethodsChildren
extends ChildFactory<HttpMethodNode> {
    private static final Comparator<HttpMethodNode> COMPARATOR = new HttpMethodsComparator();
    private Project project;
    private RestServicesModel model;
    private String serviceName;

    public HttpMethodsChildren(Project project, RestServicesModel restServicesModel, String string) {
        this.project = project;
        this.model = restServicesModel;
        this.serviceName = string;
    }

    protected boolean createKeys(final List<HttpMethodNode> list) {
        try {
            this.model.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    RestServices restServices = restServicesMetadata.getRoot();
                    RestServiceDescription restServiceDescription = restServices.getRestServiceDescription(HttpMethodsChildren.this.serviceName);
                    if (restServiceDescription != null) {
                        for (RestMethodDescription restMethodDescription : restServiceDescription.getMethods()) {
                            if (!(restMethodDescription instanceof HttpMethod)) continue;
                            list.add(new HttpMethodNode(HttpMethodsChildren.this.project, restServiceDescription, (HttpMethod)restMethodDescription));
                        }
                        Collections.sort(list, COMPARATOR);
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return true;
    }

    protected Node createNodeForKey(HttpMethodNode httpMethodNode) {
        return httpMethodNode;
    }

    static class HttpMethodsComparator
    implements Comparator<HttpMethodNode> {
        HttpMethodsComparator() {
        }

        @Override
        public int compare(HttpMethodNode httpMethodNode, HttpMethodNode httpMethodNode2) {
            String string = httpMethodNode.getKey();
            String string2 = httpMethodNode2.getKey();
            return string.compareTo(string2);
        }
    }
}

