/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.netbeans.modules.websvc.rest.codegen.model.State;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsSetupPanelVisual;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WadlModeler
extends ResourceModel {
    private FileObject fileObject;
    private String baseUrl;

    public WadlModeler(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State validate() {
        Object object;
        InputStream inputStream = null;
        try {
            inputStream = this.fileObject.getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            object = documentBuilderFactory.newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(inputStream);
            Element element = document.getDocumentElement();
            if (element == null) {
                State state = State.APP_MISSING;
                return state;
            }
            List<Node> list = this.getChildNodes(element, "resources");
            if (list == null || list.size() == 0) {
                State state = State.RESOURCES_MISSING;
                return state;
            }
            Node node = list.get(0);
            String string = this.getAttributeValue(node, "base");
            if (string == null || string.trim().equals("")) {
                State state = State.BASE_URL_NULL;
                return state;
            }
            List<Node> list2 = this.getChildNodes(node, "resource");
            if (list2.isEmpty()) {
                State state = State.EMPTY_RESOURCES;
                return state;
            }
        }
        catch (Exception exception) {
            object = State.INVALID;
            return object;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return State.VALID;
    }

    @Override
    public void build() throws IOException {
        State state = this.validate();
        if (state != State.VALID) {
            throw new IOException(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)("MSG_" + state.value())));
        }
        InputStream inputStream = null;
        try {
            inputStream = this.fileObject.getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            Node node = this.getChildNodes(element, "resources").get(0);
            this.baseUrl = this.getAttributeValue(node, "base");
            List<Node> list = this.getChildNodes(node, "resource");
            for (Node node2 : list) {
                Resource resource = this.createResource(document, node2, null);
                this.addResource(resource);
                Collection<Method> collection = this.buildResource(resource, document, node2);
                for (Method method : collection) {
                    resource.addMethod(method);
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Resource createResource(Document document, Node node, Resource resource) throws IOException {
        try {
            String string = this.getAttributeValue(node, "path");
            String string2 = this.findResourceNameFromPath(string);
            if (string2 != null && string2.length() > 0) {
                string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            String string3 = "";
            if (resource != null) {
                string2 = null;
            }
            if (resource != null && resource.getName() == null) {
                string3 = resource.getPath();
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                string = string3 + string;
            }
            Resource resource2 = new Resource(string2, string);
            return resource2;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private String findResourceNameFromPath(String string) {
        String string2 = string.replaceAll("/", "");
        string2 = string2.replace("{", "");
        string2 = string2.replace("}", "");
        return ClientStubModel.normalizeName(string2);
    }

    private Collection<Method> buildResource(Resource resource, Document document, Node node) throws IOException {
        try {
            Object object;
            Object object2;
            Node node2;
            LinkedList<Method> linkedList = new LinkedList<Method>();
            NodeList nodeList = RestUtils.getNodeList(node, "method");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Method method = null;
                    node2 = nodeList.item(i);
                    object2 = this.getAttributeValue(node2, "id");
                    object = this.getAttributeValue(node2, "name");
                    if (object == null) {
                        object = this.getAttributeValue(node2, "href");
                        if (object == null) {
                            throw new IOException("Method do not have name or href attribute for resource: " + resource.getName());
                        }
                        Object object3 = object;
                        if (((String)object3).startsWith("#")) {
                            object3 = ((String)object3).substring(1);
                        }
                        node2 = this.findMethodNodeByRef(document, (String)object3);
                        object = this.getAttributeValue(node2, "name");
                        if (object2 == null) {
                            object2 = this.getAttributeValue(node2, "id");
                        }
                        method = this.createMethod(resource, (String)object2, (String)object, node2);
                    } else {
                        method = this.createMethod(resource, (String)object2, (String)object, node2);
                    }
                    linkedList.add(method);
                }
            }
            NodeList nodeList2 = RestUtils.getNodeList(node, "resource");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                node2 = nodeList2.item(i);
                if (node2.getChildNodes().getLength() <= 0) continue;
                object2 = this.createResource(document, node2, resource);
                object = this.buildResource((Resource)object2, document, node2);
                linkedList.addAll((Collection<Method>)object);
            }
            return linkedList;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private List<Node> getChildNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string2 = node2.getNodeName();
                if (string2.indexOf(":") != -1) {
                    string2 = string2.substring(string2.indexOf(":") + 1);
                }
                if (!string2.equals(string) || node2.getNamespaceURI() != null && !node2.getNamespaceURI().equals(node.getNamespaceURI())) continue;
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    private String getAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem(string);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private Node findMethodNodeByRef(Node node, String string) throws XPathExpressionException {
        Node node2 = null;
        NodeList nodeList = RestUtils.getNodeList(node, "//application/method");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                node2 = nodeList.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Attr attr = (Attr)namedNodeMap.getNamedItem("id");
                if (attr == null || !(string2 = attr.getNodeValue()).equals(string)) continue;
                return node2;
            }
        }
        return node2;
    }

    private Method createMethod(Resource resource, String string, String string2, Node node) throws XPathExpressionException {
        if (string != null) {
            Object object;
            Method method = new Method(string.toLowerCase());
            method.setType(Constants.HttpMethodType.valueOf(string2));
            NodeList nodeList = RestUtils.getNodeList(node, "request");
            boolean bl = true;
            if (nodeList != null && nodeList.getLength() > 0) {
                object = this.getMimes(nodeList.item(0));
                method.setRequestMimes((List<String>)object);
                bl = object.isEmpty();
            }
            method.setParamType(new RestEntity(bl));
            bl = true;
            object = RestUtils.getNodeList(node, "response");
            if (object != null && object.getLength() > 0) {
                List<String> list = this.getMimes(object.item(0));
                method.setResponseMimes(list);
                bl = list.isEmpty();
            }
            method.setReturnType(new RestEntity(bl));
            if (resource.getName() == null) {
                method.setPath(resource.getPath());
            }
            return method;
        }
        return null;
    }

    private List<String> getMimes(Node node) throws XPathExpressionException {
        NodeList nodeList = RestUtils.getNodeList(node, "representation");
        LinkedList<String> linkedList = new LinkedList<String>();
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = null;
                Attr attr = (Attr)node2.getAttributes().getNamedItem("mediaType");
                if (attr != null) {
                    string = attr.getNodeValue();
                }
                if (string == null) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }
}

