/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.rest.client.RESTResourcesView;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RESTExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedResourceNode = null;
    private ProjectNodeFactory factory;
    private static final ProjectNodeFactory REST_FACTORY = new RestProjectNodeFactory();
    private JLabel jLblTreeView;

    public RESTExplorerPanel() {
        this(REST_FACTORY);
    }

    public RESTExplorerPanel(ProjectNodeFactory projectNodeFactory) {
        this.initComponents();
        this.initUserComponents();
        this.factory = projectNodeFactory;
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(RESTExplorerPanel.class, (String)"LBL_SelectRESTResource"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RESTExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RESTExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Project project : projectArray) {
            Node node = this.factory.createNode(project);
            if (node == null) continue;
            arrayList.add(node);
        }
        Project[] projectArray2 = new Node[arrayList.size()];
        arrayList.toArray(projectArray2);
        array.add((Node[])projectArray2);
        this.manager.setRootContext((Node)abstractNode);
        this.descriptor.setValid(false);
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public Node getSelectedService() {
        return this.selectedResourceNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
            Node node = nodeArray[0];
            if (this.factory.canSelect(node)) {
                this.selectedResourceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedResourceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private static class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }

    public static interface ProjectNodeFactory {
        public Node createNode(Project var1);

        public boolean canSelect(Node var1);
    }

    private static class RestProjectNodeFactory
    implements ProjectNodeFactory {
        private RestProjectNodeFactory() {
        }

        @Override
        public Node createNode(Project project) {
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider != null) {
                Node node = logicalViewProvider.createLogicalView();
                Node node2 = RESTResourcesView.createRESTResourcesView(project);
                if (node2 != null) {
                    return new ProjectNode((Children)new FilterNode.Children(node2), node);
                }
            }
            return null;
        }

        @Override
        public boolean canSelect(Node node) {
            return node.getLookup().lookup(RestServiceDescription.class) != null;
        }
    }
}

