/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.FinishableProxyWizardPanel;
import org.netbeans.modules.websvc.rest.client.JerseyClientWizardPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public final class JerseyClientWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor.Panel<WizardDescriptor> firstPanel;
    private transient JerseyClientWizardPanel bottomPanel;

    private WizardDescriptor.Panel[] getPanels() {
        return this.panels;
    }

    public Set<DataObject> instantiate() throws IOException {
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        fileObject.setAttribute("REST_RESOURCE_NAME", (Object)this.bottomPanel.getResourceName());
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        final DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ClientJavaSourceHelper.generateJerseyClient(JerseyClientWizardIterator.this.bottomPanel.getResourceNode(), dataObject2.getPrimaryFile(), null, JerseyClientWizardIterator.this.bottomPanel.getSecurity());
            }
        });
        return Collections.singleton(dataObject2);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        Object[] objectArray;
        this.wizard = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        this.bottomPanel = new JerseyClientWizardPanel();
        if (sourceGroupArray.length == 0) {
            objectArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])objectArray, (WizardDescriptor.Panel)this.bottomPanel), sourceGroupArray, false);
        } else {
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.bottomPanel, (boolean)true));
        }
        this.panels = new WizardDescriptor.Panel[]{this.firstPanel};
        objectArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (objectArray[i] == null) {
                objectArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", objectArray);
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

