/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RestUtils {
    public static void upgrade(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.upgrade();
        }
    }

    public static void ensureRestDevelopmentReady(Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.ensureRestDevelopmentReady();
        }
    }

    public static RestSupport getRestSupport(Project project) {
        return (RestSupport)project.getLookup().lookup(RestSupport.class);
    }

    public static RestServicesModel getRestServicesMetadataModel(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.getRestServicesModel();
        }
        return null;
    }

    public static void disableRestServicesChangeListner(Project project) {
        RestServicesModel restServicesModel = RestUtils.getRestServicesMetadataModel(project);
        if (restServicesModel == null) {
            return;
        }
        restServicesModel.disablePropertyChangeListener();
    }

    public static void enableRestServicesChangeListner(Project project) {
        RestServicesModel restServicesModel = RestUtils.getRestServicesMetadataModel(project);
        if (restServicesModel == null) {
            return;
        }
        restServicesModel.enablePropertyChangeListener();
    }

    public static boolean hasJTASupport(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.hasJTASupport();
        }
        return false;
    }

    public static boolean hasSpringSupport(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.hasSpringSupport();
        }
        return false;
    }

    public static boolean isServerTomcat(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.isServerTomcat();
        }
        return false;
    }

    public static boolean isServerGFV3(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.isServerGFV3();
        }
        return false;
    }

    public static boolean isServerGFV2(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.isServerGFV2();
        }
        return false;
    }

    public static Datasource getDatasource(Project project, String string) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.getDatasource(string);
        }
        return null;
    }

    public static String getAttributeValue(Node node, String string, String string2) throws XPathExpressionException {
        String string3 = null;
        int n = 0;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string + "/@" + string2);
        Object object = xPathExpression.evaluate(node, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        if (n < nodeList.getLength()) {
            string3 = nodeList.item(n).getNodeValue();
        }
        return string3;
    }

    public static NodeList getNodeList(Node node, String string) throws XPathExpressionException {
        Object var2_2 = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        Object object = xPathExpression.evaluate(node, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        return nodeList;
    }

    public static FileObject findWadlFile(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("/build/web/WEB-INF/classes/com/sun/ws/rest/wadl/resource/application.wadl");
        return fileObject2;
    }

    public static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, Map<String, String> map) throws IOException {
        assert (string != null);
        assert (fileObject != null);
        assert (string2 != null && string2.trim().length() > 0);
        FileObject fileObject2 = FileUtil.getConfigFile((String)string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        if (map == null) {
            return dataObject.createFromTemplate(dataFolder, string2);
        }
        return dataObject.createFromTemplate(dataFolder, string2, map);
    }

    public static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        return RestUtils.createDataObjectFromTemplate(string, fileObject, string2, null);
    }

    public static String findStubNameFromClass(String string) {
        String string2 = string;
        int n = string2.lastIndexOf("Resource");
        if (n != -1) {
            string2 = string2.substring(0, n);
        } else {
            n = string2.lastIndexOf("Converter");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static String findUri(JavaSource javaSource) {
        String string = null;
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        for (AnnotationMirror annotationMirror : list) {
            String string2 = annotationMirror.getAnnotationType().toString();
            if (!"javax.ws.rs.Path".equals(string2)) continue;
            string = RestUtils.getValueFromAnnotation(annotationMirror);
        }
        return string;
    }

    public static boolean isStaticResource(JavaSource javaSource) {
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list != null && list.size() > 0) {
            for (AnnotationMirror annotationMirror : list) {
                String string = annotationMirror.getAnnotationType().toString();
                if (!"javax.ws.rs.Path".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConverter(JavaSource javaSource) {
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list != null && list.size() > 0) {
            for (AnnotationMirror annotationMirror : list) {
                String string = annotationMirror.getAnnotationType().toString();
                if (!"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDynamicResource(JavaSource javaSource) {
        List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
        for (MethodTree methodTree : list) {
            List<? extends AnnotationTree> list2 = methodTree.getModifiers().getAnnotations();
            if (list2 == null || list2.size() <= 0) continue;
            for (AnnotationTree annotationTree : list2) {
                String string = annotationTree.getAnnotationType().toString();
                if ("Path".equals(string) || "javax.ws.rs.Path".equals(string)) {
                    return true;
                }
                if (!"GET".equals(string) && !"javax.ws.rs.GET".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String findElementName(MethodTree methodTree) {
        String string = "";
        List<? extends AnnotationTree> list = methodTree.getModifiers().getAnnotations();
        if (list != null && list.size() > 0) {
            for (AnnotationTree annotationTree : list) {
                string = annotationTree.toString();
                if (string.indexOf("\"") != -1) {
                    string = RestUtils.getValueFromAnnotation(annotationTree);
                    continue;
                }
                string = RestUtils.getNameFromMethod(methodTree);
            }
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static MethodTree findGetAsXmlMethod(JavaSource javaSource) {
        MethodTree methodTree = null;
        List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
        for (MethodTree methodTree2 : list) {
            boolean bl = false;
            boolean bl2 = false;
            List<? extends AnnotationTree> list2 = methodTree2.getModifiers().getAnnotations();
            if (list2 == null || list2.size() <= 0) continue;
            for (AnnotationTree annotationTree : list2) {
                List<String> list3;
                String string = annotationTree.getAnnotationType().toString();
                if ("GET".equals(string) || "javax.ws.rs.GET".equals(string)) {
                    bl = true;
                    continue;
                }
                if (!"Produces".equals(string) && !"javax.ws.rs.Produces".equals(string) || !(list3 = RestUtils.getMimeAnnotationValue(annotationTree)).contains(Constants.MimeType.JSON.value()) && !list3.contains(Constants.MimeType.XML.value())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            methodTree = methodTree2;
            break;
        }
        return methodTree;
    }

    public static String getNameFromMethod(MethodTree methodTree) {
        String string = methodTree.getName().toString();
        string = string.substring(string.indexOf("get") + 3);
        string = string.substring(0, 1).toLowerCase() + string.substring(1);
        return string;
    }

    public static String getValueFromAnnotation(AnnotationMirror annotationMirror) {
        return RestUtils.getValueFromAnnotation(annotationMirror.getElementValues().values().toString());
    }

    public static String getValueFromAnnotation(AnnotationTree annotationTree) {
        return RestUtils.getValueFromAnnotation(annotationTree.toString());
    }

    public static String getValueFromAnnotation(ExpressionTree expressionTree) {
        return RestUtils.getValueFromAnnotation(expressionTree.toString());
    }

    public static String getValueFromAnnotation(String string) {
        if (string.indexOf("\"") != -1) {
            string = string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
        }
        return string;
    }

    public static List<String> getMimeAnnotationValue(AnnotationTree annotationTree) {
        List<? extends ExpressionTree> list = annotationTree.getArguments();
        if (list.size() > 0) {
            String string = RestUtils.getValueFromAnnotation(list.get(0));
            string = string.replace("\"", "");
            return Arrays.asList(string.split(","));
        }
        return Collections.emptyList();
    }

    public static String escapeJSReserved(String string) {
        if (string.equals("delete")) {
            return string + "_";
        }
        return string;
    }

    public static J2eeModule getJ2eeModule(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            return j2eeModuleProvider.getJ2eeModule();
        }
        return null;
    }

    public static boolean isAnnotationConfigAvailable(Project project) throws IOException {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray;
        Profile profile;
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null && restSupport.hasSpringSupport()) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return webModule != null && (Profile.JAVA_EE_6_WEB.equals(profile = webModule.getJ2eeProfile()) || Profile.JAVA_EE_6_FULL.equals(profile)) && (sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project)).length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")).findResource("javax/ws/rs/ApplicationPath.class") != null && classPath.findResource("javax/ws/rs/core/Application.class") != null;
    }

    public static boolean isJSR_311OnClasspath(Project project) throws IOException {
        return RestUtils.hasClass(project, "javax/ws/rs/Path.class");
    }

    public static boolean hasClass(Project project, String string) throws IOException {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray;
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return webModule != null && (sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project)).length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")).findResource(string) != null;
    }

    public static void createApplicationConfigClass(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = GenerationUtils.createClass((FileObject)fileObject, (String)string, null);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"javax.ws.rs.ApplicationPath"}, new String[]{"webresources"});
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ClassTree classTree2 = treeMaker.setExtends(classTree, treeMaker.QualIdent("javax.ws.rs.core.Application"));
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        }).commit();
    }

    public static boolean isJavaEE6(Project project) {
        Profile profile;
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return webModule != null && (Profile.JAVA_EE_6_WEB == (profile = webModule.getJ2eeProfile()) || Profile.JAVA_EE_6_FULL == profile);
    }

    public static boolean hasProfile(Project project, Profile ... profileArray) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            Profile profile = webModule.getJ2eeProfile();
            for (Profile profile2 : profileArray) {
                if (profile != profile2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAopAlliance(Project project) {
        try {
            return RestUtils.hasClass(project, "org/aopalliance/aop/Advice.class");
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

