/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.LogDate;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JhlLogMessage
implements ISVNLogMessage {
    private static final String EMPTY = "";
    private List<ISVNLogMessage> children;
    private boolean hasChildren;
    private ISVNLogMessageChangePath[] changedPaths;
    private SVNRevision.Number revision;
    private Map<String, byte[]> revprops;
    private LogDate logDate;

    public JhlLogMessage(Set<ChangePath> changedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
        this.changedPaths = JhlConverter.convertChangePaths(changedPaths);
        this.revision = new SVNRevision.Number(revision);
        this.revprops = revprops;
        if (this.revprops == null) {
            this.revprops = new HashMap<String, byte[]>(2);
            this.revprops.put("svn:author", EMPTY.getBytes());
            this.revprops.put("svn:log", EMPTY.getBytes());
        }
        this.hasChildren = hasChildren;
        try {
            this.logDate = new LogDate(new String(this.revprops.get("svn:date")));
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public void addChild(ISVNLogMessage msg) {
        if (this.children == null) {
            this.children = new ArrayList<ISVNLogMessage>();
        }
        this.children.add(msg);
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        byte[] author = this.revprops.get("svn:author");
        if (author == null) {
            return EMPTY;
        }
        try {
            return new String(author, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(author);
        }
    }

    public Date getDate() {
        if (this.logDate == null) {
            return new Date(0L);
        }
        return this.logDate.getDate();
    }

    public String getMessage() {
        byte[] message = this.revprops.get("svn:log");
        if (message == null) {
            return EMPTY;
        }
        try {
            return new String(message, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(message);
        }
    }

    public ISVNLogMessageChangePath[] getChangedPaths() {
        return this.changedPaths;
    }

    public String toString() {
        return this.getMessage();
    }

    public ISVNLogMessage[] getChildMessages() {
        if (this.hasChildren && this.children != null) {
            ISVNLogMessage[] childArray = new JhlLogMessage[this.children.size()];
            this.children.toArray(childArray);
            return childArray;
        }
        return null;
    }

    public long getNumberOfChildren() {
        if (this.hasChildren && this.children != null) {
            return this.children.size();
        }
        return 0L;
    }

    public long getTimeMillis() {
        if (this.logDate == null) {
            return 0L;
        }
        return this.logDate.getTimeMillis();
    }

    public long getTimeMicros() {
        if (this.logDate == null) {
            return 0L;
        }
        return this.logDate.getTimeMicros();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }
}

