/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.MQSQLException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.TableSchema;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommDBManager {
    private static final String JDBC_STORE_TYPE = "jdbc";
    private static final String TABLEOPTION_NAME_VARIABLE = "tableoption";
    private static final String TABLE_NAME_VARIABLE = "name";
    private static final String INDEX_NAME_VARIABLE = "index";
    private static final String TRANSACTION_RETRY_MAX_PROP_SUFFIX = ".transaction.retry.max";
    private static final String TRANSACTION_RETRY_DELAY_PROP_SUFFIX = ".transaction.retry.delay";
    public static final int TRANSACTION_RETRY_MAX_DEFAULT = 5;
    public static final long TRANSACTION_RETRY_DELAY_DEFAULT = 2000L;
    private static final int CONNECTION_RETRY_MAX_DEFAULT = 60;
    private static final long CONNECTION_RETRY_DELAY_DEFAULT = 5000L;
    private static final String CONNECTION_RETRY_MAX_PROP_SUFFIX = ".connection.retry.max";
    private static final String CONNECTION_RETRY_DELAY_PROP_SUFFIX = ".connection.retry.delay";
    private static final String CONNECTION_RETRY_REGEX_PROP_SUFFIX = ".connection.retry.regex";
    private static final String SQL_RETRIABLE_ERROR_CODES_PROP_SUFFIX = ".sqlRetriableErrorCodes";
    protected static final String VENDOR_PROP_SUFFIX = ".dbVendor";
    protected static final String FALLBACK_USER_PROP_SUFFIX = ".user";
    protected static final String FALLBACK_PWD_PROP_SUFFIX = ".password";
    private static final String UNKNOWN_VENDOR = "unknown";
    private static final boolean DEFAULT_NEEDPASSWORD = false;
    private String vendor = null;
    private String vendorPropPrefix = null;
    private String tablePropPrefix = null;
    private String vendorProp = null;
    private String driverProp = null;
    private String openDBUrlProp = null;
    private String createDBUrlProp = null;
    private String closeDBUrlProp = null;
    private String userProp = null;
    private String passwordProp = null;
    private String needPasswordProp = null;
    public int txnRetryMax;
    public long txnRetryDelay;
    public int connRetryMax = 60;
    public long connRetryDelay = 5000L;
    private String driver = null;
    private String openDBUrl = null;
    private String createDBUrl = null;
    protected String closeDBUrl = null;
    private String user = null;
    private String password = null;
    private boolean needPassword = true;
    private boolean isDataSource = false;
    private boolean isPoolDataSource = false;
    private Object dataSource = null;
    protected boolean isHADB = false;
    protected boolean isOracle = false;
    protected boolean isOraDriver = false;
    private boolean isMysql = false;
    private boolean isDerby = false;
    private boolean isDB2 = false;
    private boolean supportBatch = false;
    private boolean supportGetGeneratedKey = false;
    private String dbProductName = null;
    private String dbProductVersion = null;
    private int sqlStateType = 2;
    protected String tableSuffix = null;
    protected BrokerConfig config = Globals.getConfig();
    protected BrokerResources br = Globals.getBrokerResources();
    protected Logger logger = Globals.getLogger();
    private boolean isJDBC4 = true;
    private boolean isClosing = false;
    protected HashMap tableSchemas = new HashMap();
    private ArrayList<String> reconnectPatterns = new ArrayList();
    private static final String DEFAULT_CONNECTION_RETRY_PATTERN = "(?s).*";
    private ArrayList<Integer> sqlRetriableErrorCodes = new ArrayList();
    private ConfigListener cfgListener = new ConfigListener(){

        public void validate(String string, String string2) throws PropertyUpdateException {
            if (string.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX)) {
                long l = -1L;
                try {
                    l = Long.parseLong(string2);
                }
                catch (Exception exception) {
                    throw new PropertyUpdateException(2, CommDBManager.this.br.getString("B4027", string + "=" + string2), exception);
                }
                if (l < 0L) {
                    throw new PropertyUpdateException(2, string + "=" + string2);
                }
            }
        }

        public boolean update(String string, String string2) {
            BrokerConfig brokerConfig = Globals.getConfig();
            if (string.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX)) {
                CommDBManager.this.connRetryDelay = brokerConfig.getLongProperty(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX);
            } else if (string.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_MAX_PROP_SUFFIX)) {
                CommDBManager.this.connRetryMax = brokerConfig.getIntProperty(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_MAX_PROP_SUFFIX);
            }
            return true;
        }
    };
    public static final Class TRANSIENT_SQLEX_CLASS = CommDBManager.GET_TRANSIENT_SQLEX_CLASS();
    public static final Class NON_TRANSIENT_SQLEX_CLASS = CommDBManager.GET_NONTRANSIENT_SQLEX_CLASS();
    public static final Class RECOVERABLE_SQLEX_CLASS = CommDBManager.GET_RECOVERABLE_SQLEX_CLASS();
    public static final Class TRANSIENT_CONNECTION_SQLEX_CLASS = CommDBManager.GET_TRANSIENT_CONNECTION_SQLEX_CLASS();
    public static final Class TIMEOUT_SQLEX_CLASS = CommDBManager.GET_TIMEOUT_SQLEX_CLASS();
    public static final Class TRANSACTION_ROLLBACK_SQLEX_CLASS = CommDBManager.GET_TRANSACTION_ROLLBACK_SQLEX_CLASS();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initDBMetaData() throws BrokerException {
        int n;
        block5: {
            n = 0;
            Connection connection = null;
            SQLException sQLException = null;
            try {
                try {
                    connection = this.getConnection(true);
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    this.dbProductName = databaseMetaData.getDatabaseProductName();
                    this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                    this.supportBatch = databaseMetaData.supportsBatchUpdates();
                    this.sqlStateType = databaseMetaData.getSQLStateType();
                    n = databaseMetaData.getMaxTableNameLength();
                    String string = databaseMetaData.getDriverVersion();
                    this.supportGetGeneratedKey = databaseMetaData.supportsGetGeneratedKeys();
                    this.isOraDriver = "oracle".equalsIgnoreCase(this.dbProductName);
                    String string2 = new StringBuffer(256).append(this.getLogStringTag() + "DBManager: database product name=").append(this.dbProductName).append(", database version number=").append(this.dbProductVersion).append(", driver version number=").append(string).append(", supports batch updates=").append(this.supportBatch).append(", supports getGeneratedKey=").append(this.supportGetGeneratedKey).toString();
                    this.logger.log(64, this.getLogStringTag() + this.dbProductName + ", " + this.dbProductVersion + ", " + string);
                    this.logger.log(Store.getDEBUG() ? 8 : 4, string2);
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    this.logger.log(16, "B4164", sQLException2);
                    Object var8_9 = null;
                    this.closeSQLObjects(null, null, connection, sQLException);
                    break block5;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.closeSQLObjects(null, null, connection, sQLException);
                throw throwable;
            }
            this.closeSQLObjects(null, null, connection, sQLException);
        }
        if (n > 0) {
            this.checkMaxTableNameLength(n);
        }
    }

    protected abstract boolean getDEBUG();

    protected abstract boolean isStoreInited();

    protected abstract String getLogStringTag();

    protected abstract String getJDBCPropPrefix();

    protected abstract String getStoreTypeProp();

    protected abstract String getCreateStoreProp();

    protected abstract boolean getCreateStorePropDefault();

    protected abstract void checkMaxTableNameLength(int var1) throws BrokerException;

    public String toString() {
        return "CommDBManager";
    }

    protected boolean isJDBC4() {
        return this.isJDBC4;
    }

    protected void setJDBC4(boolean bl) {
        this.isJDBC4 = bl;
    }

    public String getOpenDBUrlProp() {
        return this.openDBUrlProp;
    }

    public String getOpenDBUrl() {
        return this.openDBUrl;
    }

    public String getVendorProp() {
        return this.vendorProp;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<String> getReconnectPatterns() {
        return this.reconnectPatterns;
    }

    protected void initDBManagerProps() throws BrokerException {
        String string;
        String string2 = this.getJDBCPropPrefix();
        this.txnRetryMax = this.config.getIntProperty(string2 + TRANSACTION_RETRY_MAX_PROP_SUFFIX, 5);
        this.txnRetryDelay = this.config.getLongProperty(string2 + TRANSACTION_RETRY_DELAY_PROP_SUFFIX, 2000L);
        if (this.txnRetryDelay < 0L) {
            this.txnRetryDelay = 2000L;
        }
        this.connRetryMax = this.config.getIntProperty(string2 + CONNECTION_RETRY_MAX_PROP_SUFFIX, 60);
        this.logger.log(8, string2 + CONNECTION_RETRY_MAX_PROP_SUFFIX + "=" + this.connRetryMax);
        this.connRetryDelay = this.config.getLongProperty(string2 + CONNECTION_RETRY_DELAY_PROP_SUFFIX, 5000L);
        if (this.connRetryDelay < 0L) {
            this.connRetryDelay = 5000L;
        }
        this.logger.log(8, string2 + string2 + CONNECTION_RETRY_DELAY_PROP_SUFFIX + "=" + this.connRetryDelay);
        Globals.getConfig().addListener(string2 + CONNECTION_RETRY_MAX_PROP_SUFFIX, this.cfgListener);
        Globals.getConfig().addListener(string2 + CONNECTION_RETRY_DELAY_PROP_SUFFIX, this.cfgListener);
        String string3 = this.config.getProperty(this.getStoreTypeProp());
        if (string3 == null || !string3.equals(JDBC_STORE_TYPE)) {
            string3 = string3 == null ? "" : string3;
            throw new BrokerException(this.br.getKString("B3103", this.getStoreTypeProp() + "=" + string3, JDBC_STORE_TYPE));
        }
        this.vendorProp = string2 + VENDOR_PROP_SUFFIX;
        this.vendor = this.config.getProperty(this.vendorProp, UNKNOWN_VENDOR);
        this.vendorPropPrefix = string2 + "." + this.vendor;
        this.tablePropPrefix = this.vendorPropPrefix + ".table";
        this.driverProp = this.vendorPropPrefix + ".driver";
        this.driver = this.config.getProperty(this.driverProp);
        if (this.driver == null || this.driver.length() == 0) {
            string = string2 + ".driver";
            this.driver = this.config.getProperty(string);
            if (this.driver == null || this.driver.length() == 0) {
                throw new BrokerException(this.br.getKString("B3023", this.driverProp));
            }
            this.driverProp = string;
        }
        this.logger.log(64, this.driverProp + "=" + this.driver);
        this.openDBUrlProp = this.vendorPropPrefix + ".opendburl";
        this.openDBUrl = this.config.getProperty(this.openDBUrlProp);
        if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
            string = string2 + ".opendburl";
            this.openDBUrl = this.config.getProperty(string);
            if (this.openDBUrl != null && this.openDBUrl.trim().length() > 0) {
                this.openDBUrlProp = string;
            }
        }
        this.openDBUrl = StringUtil.expandVariables(this.openDBUrl, this.config);
        if (this.openDBUrl != null) {
            this.logger.log(64, this.openDBUrlProp + "=" + this.openDBUrl);
        }
        this.createDBUrlProp = this.vendorPropPrefix + ".createdburl";
        this.createDBUrl = this.config.getProperty(this.createDBUrlProp);
        if (this.createDBUrl == null || this.createDBUrl.length() == 0) {
            string = string2 + ".createdburl";
            this.createDBUrl = this.config.getProperty(string);
            if (this.createDBUrl != null) {
                this.createDBUrlProp = string;
            }
        }
        this.createDBUrl = StringUtil.expandVariables(this.createDBUrl, this.config);
        if (this.createDBUrl != null) {
            this.logger.log(64, this.createDBUrlProp + "=" + this.createDBUrl);
        }
        this.closeDBUrlProp = this.vendorPropPrefix + ".closedburl";
        this.closeDBUrl = this.config.getProperty(this.closeDBUrlProp);
        if (this.closeDBUrl == null || this.closeDBUrl.length() == 0) {
            string = string2 + ".closedburl";
            this.closeDBUrl = this.config.getProperty(string);
            if (this.closeDBUrl != null) {
                this.closeDBUrlProp = string;
            }
        }
        this.closeDBUrl = StringUtil.expandVariables(this.closeDBUrl, this.config);
        if (this.closeDBUrl != null) {
            this.logger.log(64, this.closeDBUrlProp + "=" + this.closeDBUrl);
        }
        this.userProp = this.vendorPropPrefix + FALLBACK_USER_PROP_SUFFIX;
        this.user = this.config.getProperty(this.userProp);
        if (this.user == null) {
            this.user = this.config.getProperty(string2 + FALLBACK_USER_PROP_SUFFIX);
            if (this.user != null) {
                this.userProp = string2 + FALLBACK_USER_PROP_SUFFIX;
            }
        }
        string = this.vendorPropPrefix + CONNECTION_RETRY_REGEX_PROP_SUFFIX;
        int n = 1;
        String string4 = null;
        String string5 = null;
        while ((string5 = this.config.getProperty(string4 = string + "." + n++)) != null) {
            try {
                "A".matches(string5);
                this.reconnectPatterns.add(string5);
                this.logger.log(8, string4 + "=" + string5);
            }
            catch (Exception exception) {
                throw new BrokerException("[" + string4 + "=" + string5 + "]: " + exception.toString(), exception);
            }
        }
        if (this.reconnectPatterns.size() == 0) {
            this.reconnectPatterns.add(DEFAULT_CONNECTION_RETRY_PATTERN);
            this.logger.log(8, string + "=" + DEFAULT_CONNECTION_RETRY_PATTERN);
        }
        String string6 = this.vendorPropPrefix + SQL_RETRIABLE_ERROR_CODES_PROP_SUFFIX;
        String string7 = this.config.getProperty(string6);
        List list = this.config.getList(string6);
        if (list != null && list.size() > 0) {
            this.logger.log(8, string6 + "=" + string7);
            Integer n2 = null;
            for (String string8 : list) {
                try {
                    n2 = Integer.valueOf(string8);
                    this.sqlRetriableErrorCodes.add(n2);
                }
                catch (Exception exception) {
                    Object[] objectArray = new String[]{string8, string6 + "=" + string7, exception.toString()};
                    this.logger.log(16, this.br.getKString("B2262", objectArray));
                }
            }
        }
        this.initTableSuffix();
    }

    public boolean isRetriableSQLErrorCode(int n) {
        return this.sqlRetriableErrorCodes.contains(n);
    }

    protected abstract void initTableSuffix() throws BrokerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void initDBDriver() throws BrokerException {
        var1_1 = this.getJDBCPropPrefix();
        try {
            var2_2 = Class.forName(this.driver);
            var3_6 /* !! */  = var2_2.newInstance();
            if (var3_6 /* !! */  instanceof ConnectionPoolDataSource) {
                this.isDataSource = true;
                this.isPoolDataSource = true;
            } else if (var3_6 /* !! */  instanceof DataSource) {
                this.isDataSource = true;
            } else if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
                throw new BrokerException(this.br.getKString("B3025", this.openDBUrlProp));
            }
            if (this.isDataSource) {
                this.dataSource = var3_6 /* !! */ ;
                this.initDataSource((Class)var2_2, this.dataSource);
            }
        }
        catch (InstantiationException var2_3) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_3);
        }
        catch (IllegalAccessException var2_4) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_4);
        }
        catch (ClassNotFoundException var2_5) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_5);
        }
        this.password = this.getPassword();
        if ("unknown".equals(this.vendor)) {
            block33: {
                var2_2 = null;
                var3_6 /* !! */  = null;
                try {
                    var2_2 = this.getNewConnection(true);
                    var4_7 = var2_2.getMetaData();
                    var3_6 /* !! */  = var4_7.getDatabaseProductName();
                    var6_9 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var5_15) {
                    var6_11 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (SQLException var7_14) {
                            // empty catch block
                        }
                    }
                    throw var5_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (SQLException var7_12) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block33;
                    catch (Exception var4_8) {
                        var6_10 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (SQLException var7_13) {}
                        }
                    }
                }
            }
            if ("oracle".equalsIgnoreCase((String)var3_6 /* !! */ )) {
                this.vendor = "oracle";
                this.vendorPropPrefix = var1_1 + "." + this.vendor;
                this.tablePropPrefix = this.vendorPropPrefix + ".table";
            } else {
                throw new BrokerException(this.br.getKString("B3212", this.getJDBCPropPrefix() + ".dbVendor"));
            }
        }
        if (this.vendor.equalsIgnoreCase("hadb")) {
            this.isHADB = true;
            this.checkHADBJDBCLogging();
        } else if (this.vendor.equalsIgnoreCase("oracle")) {
            this.isOracle = true;
        } else if (this.vendor.equalsIgnoreCase("mysql")) {
            this.isMysql = true;
        } else if (this.vendor.equalsIgnoreCase("derby")) {
            this.isDerby = true;
        } else if (this.vendor.equalsIgnoreCase("db2")) {
            this.isDB2 = true;
        }
    }

    public boolean isPoolDataSource() {
        return this.isPoolDataSource;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("vendor", "" + this.vendor);
        hashtable.put("user", "" + this.user);
        hashtable.put("isDataSource", this.isDataSource);
        hashtable.put("isPoolDataSource", this.isPoolDataSource);
        hashtable.put("supportBatch", this.supportBatch);
        hashtable.put("supportGetGeneratedKey", this.supportGetGeneratedKey);
        hashtable.put("sqlStateType", String.valueOf(this.sqlStateType));
        hashtable.put("isJDBC4", this.isJDBC4);
        return hashtable;
    }

    public TableSchema getTableSchema(String string) throws BrokerException {
        HashMap hashMap = this.getTableSchemas();
        TableSchema tableSchema = (TableSchema)hashMap.get(string);
        if (tableSchema == null || tableSchema.tableSQL.length() == 0) {
            throw new BrokerException(this.br.getKString("B3127", string, this.getJDBCPropPrefix() + VENDOR_PROP_SUFFIX));
        }
        return tableSchema;
    }

    public abstract boolean hasSupplementForCreateDrop(String var1);

    protected void createTableSupplement(Statement statement, TableSchema tableSchema, String string) throws BrokerException {
        String string2 = tableSchema.afterCreateSQL;
        if (string2 == null) {
            return;
        }
        this.logger.logToAll(8, this.br.getKString("B1365", string2, string));
        try {
            int n = statement.executeUpdate(string2);
            if (n != 0 || statement.getWarnings() != null) {
                String string3 = "[" + string2 + "]: " + statement.getWarnings() + "(return=" + n + ")";
                this.logger.log(32, string3);
                throw new BrokerException(string3);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            String string4 = "[" + string2 + "]: " + throwable.getMessage();
            this.logger.logStack(32, string4, throwable);
            throw new BrokerException(string4);
        }
    }

    public void dropTableSupplement(Statement statement, TableSchema tableSchema, String string, boolean bl) throws BrokerException {
        String string2 = tableSchema.afterDropSQL;
        if (string2 == null) {
            return;
        }
        this.logger.logToAll(8, this.br.getKString("B1366", string2, string));
        try {
            int n = statement.executeUpdate(string2);
            if (n != 0 || statement.getWarnings() != null) {
                String string3 = "[" + string2 + "]: " + statement.getWarnings() + "(return=" + n + ")";
                throw new BrokerException(string3);
            }
        }
        catch (Throwable throwable) {
            BrokerException brokerException = null;
            if (throwable instanceof BrokerException) {
                brokerException = (BrokerException)throwable;
            } else {
                String string4 = "[" + string2 + "]: " + throwable.getMessage();
                brokerException = new BrokerException(string4);
            }
            if (bl) {
                this.logger.logStack(16, brokerException.getMessage(), throwable);
                throw brokerException;
            }
            this.logger.log(8, brokerException.getMessage());
        }
    }

    public Connection connectToCreate() throws BrokerException {
        if (this.createDBUrl == null) {
            throw new BrokerException(this.br.getKString("B3025", this.createDBUrlProp));
        }
        Connection connection = null;
        try {
            connection = this.user == null ? DriverManager.getConnection(this.createDBUrl) : DriverManager.getConnection(this.createDBUrl, this.user, this.password);
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException2) {
                    this.logger.logStack(16, "Unable to close JDBC connection: " + sQLException2 + " after SQLException ", sQLException);
                }
            }
            throw new BrokerException(this.br.getKString("B3026", this.createDBUrl), sQLException);
        }
        return connection;
    }

    public Connection getNewConnection(boolean bl) throws BrokerException {
        Object object;
        Object object2 = this.newConnection(true);
        if (object2 instanceof PooledConnection) {
            object = (PooledConnection)object2;
            object.addConnectionEventListener(new ConnectionEventListener((PooledConnection)object){
                final /* synthetic */ PooledConnection val$pc;
                {
                    this.val$pc = pooledConnection;
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                    this.val$pc.removeConnectionEventListener(this);
                    try {
                        this.val$pc.close();
                    }
                    catch (Exception exception) {
                        Logger cfr_ignored_0 = CommDBManager.this.logger;
                        BrokerResources cfr_ignored_1 = CommDBManager.this.br;
                        CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2229", this.val$pc.getClass().getName() + "[0x" + this.val$pc.hashCode() + "]", exception.toString()));
                    }
                }

                public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
                    Logger cfr_ignored_0 = CommDBManager.this.logger;
                    BrokerResources cfr_ignored_1 = CommDBManager.this.br;
                    CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2231", "0x" + this.val$pc.hashCode(), "" + connectionEvent.getSQLException()));
                    this.val$pc.removeConnectionEventListener(this);
                    try {
                        this.val$pc.close();
                    }
                    catch (Exception exception) {
                        Logger cfr_ignored_2 = CommDBManager.this.logger;
                        BrokerResources cfr_ignored_3 = CommDBManager.this.br;
                        CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2229", this.val$pc.getClass().getName() + "[0x" + this.val$pc.hashCode() + "]", exception.toString()));
                    }
                }
            });
        }
        try {
            object = null;
            while (true) {
                try {
                    Connection connection = null;
                    connection = object2 instanceof PooledConnection ? ((PooledConnection)object2).getConnection() : (Connection)object2;
                    connection.setAutoCommit(bl);
                    return connection;
                }
                catch (Exception exception) {
                    BrokerException brokerException = new BrokerException(exception.getMessage(), exception);
                    if (object == null) {
                        object = new Util.RetryStrategy(this);
                    }
                    ((Util.RetryStrategy)object).assertShouldRetry(brokerException);
                    continue;
                }
                break;
            }
        }
        catch (BrokerException brokerException) {
            try {
                if (object2 instanceof PooledConnection) {
                    ((PooledConnection)object2).close();
                } else {
                    ((Connection)object2).close();
                }
            }
            catch (Throwable throwable) {
                this.logger.log(16, this.br.getKString("B2229", object2.getClass().getName() + "[0x" + object2.hashCode() + "]", throwable.toString()));
            }
            throw brokerException;
        }
    }

    protected Object getNewConnection() throws BrokerException {
        return this.newConnection(false);
    }

    protected Object newConnection(boolean bl) throws BrokerException {
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            try {
                try {
                    Object object = null;
                    object = this.dataSource != null ? (this.isPoolDataSource ? (this.user == null ? ((ConnectionPoolDataSource)this.dataSource).getPooledConnection() : ((ConnectionPoolDataSource)this.dataSource).getPooledConnection(this.user, this.password)) : (this.user == null ? ((DataSource)this.dataSource).getConnection() : ((DataSource)this.dataSource).getConnection(this.user, this.password))) : (this.user == null ? DriverManager.getConnection(this.openDBUrl) : DriverManager.getConnection(this.openDBUrl, this.user, this.password));
                    return object;
                }
                catch (Exception exception) {
                    throw new BrokerException(this.br.getKString("B3026", this.openDBUrl), exception);
                }
            }
            catch (BrokerException brokerException) {
                if (!bl) {
                    throw brokerException;
                }
                if (retryStrategy == null) {
                    retryStrategy = new Util.RetryStrategy(this, this.connRetryDelay, this.connRetryMax, true);
                }
                retryStrategy.assertShouldRetry(brokerException);
                continue;
            }
            break;
        }
    }

    public Connection getConnection(boolean bl) throws BrokerException {
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            try {
                Connection connection = this.getConnectionNoRetry(bl);
                return connection;
            }
            catch (BrokerException brokerException) {
                if (BrokerStateHandler.storeShutdownStage1) {
                    throw brokerException;
                }
                if (retryStrategy == null) {
                    retryStrategy = new Util.RetryStrategy(this, this.connRetryDelay, this.connRetryMax, true);
                }
                retryStrategy.assertShouldRetry(brokerException);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getConnectionNoRetry(boolean bl) throws BrokerException {
        SQLException sQLException = null;
        Connection connection = this.getConnection();
        try {
            try {
                if (connection.getAutoCommit() != bl) {
                    connection.setAutoCommit(bl);
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw new BrokerException(this.br.getKString("B4117", "Unable to set connection's auto-commit mode"), sQLException2);
            }
            int n = -1;
            try {
                if (this.isHADB && (n = connection.getTransactionIsolation()) != 2) {
                    connection.setTransactionIsolation(2);
                }
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
                throw new BrokerException(this.br.getKString("B4117", "Unable to set connection's transaction isolation level, current= " + n), sQLException3);
            }
            Object var7_7 = null;
            if (sQLException == null) return connection;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (sQLException == null) throw throwable;
            this.freeConnection(connection, sQLException);
            throw throwable;
        }
        this.freeConnection(connection, sQLException);
        return connection;
    }

    protected abstract Connection getConnection() throws BrokerException;

    public abstract void freeConnection(Connection var1, Throwable var2) throws BrokerException;

    protected abstract BaseDAO getFirstDAO() throws BrokerException;

    public void setIsClosing() {
        this.isClosing = true;
    }

    public boolean getIsClosing() {
        return this.isClosing;
    }

    protected void close() {
        block3: {
            if (this.closeDBUrl != null) {
                try {
                    DriverManager.getConnection(this.closeDBUrl);
                }
                catch (SQLException sQLException) {
                    if (!Store.getDEBUG()) break block3;
                    this.logger.log(4, this.getLogStringTag() + "B1052", (Object)this.closeDBUrl, (Throwable)sQLException);
                }
            }
        }
    }

    public boolean supportsBatchUpdates() {
        return this.supportBatch;
    }

    public boolean supportsGetGeneratedKey() {
        return this.supportGetGeneratedKey;
    }

    public boolean isHADB() {
        return this.isHADB;
    }

    public boolean isMysql() {
        return this.isMysql;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isDB2() {
        return this.isDB2;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isOracleDriver() {
        return this.isOraDriver;
    }

    public int getSQLStateType() {
        return this.sqlStateType;
    }

    public String getOpenDBURL() {
        return this.openDBUrl;
    }

    public String getCreateDBURL() {
        return this.createDBUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getTableName(String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException();
        }
        return string + this.tableSuffix;
    }

    public abstract String[] getTableNames(int var1);

    public String getDriver() {
        return this.driver;
    }

    public abstract Iterator allDAOIterator() throws BrokerException;

    HashMap getTableSchemas() {
        return this.tableSchemas;
    }

    public abstract int checkStoreExists(Connection var1) throws BrokerException;

    protected int checkStoreExists(Connection connection, String string) throws BrokerException {
        Map map = this.getTableNamesFromDB(connection, string == null ? this.tableSuffix : string + this.tableSuffix, true);
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.allDAOIterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ++n;
            String string2 = ((BaseDAO)iterator.next()).getTableName();
            if (map.containsKey(string2.toLowerCase())) {
                ++n2;
                continue;
            }
            stringBuffer.append(string2 + " ");
        }
        if (n2 > 0 && n2 != n) {
            this.logger.log(16, this.br.getKString("B2221", stringBuffer.toString() + "[" + n + "," + n2 + ", " + this.tableSuffix + "]"));
            return -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getTableNamesFromDB(Connection connection, String string, boolean bl) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        if (string == null || string.trim().length() == 0) {
            string = this.tableSuffix;
            bl = true;
        }
        string = string.toLowerCase();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            Object var16_6;
            boolean bl2 = false;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getConnection(true);
                        bl2 = true;
                    }
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String[] stringArray = new String[]{"TABLE"};
                    resultSet = databaseMetaData.getTables(null, null, null, stringArray);
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("TABLE_NAME");
                        if (string2 == null) continue;
                        if ((string2 = string2.trim()).length() == 0) {
                            throw new BrokerException(this.br.getKString("B4309", "DatabaseMetaData.getTables()"));
                        }
                        if (string2.length() < 2) continue;
                        char c = string2.charAt(0);
                        char c2 = string2.charAt(1);
                        if (c != 'm' && c != 'M' || c2 != 'q' && c2 != 'Q') continue;
                        String string3 = string2.toLowerCase();
                        if (bl) {
                            if (!string3.endsWith(string)) continue;
                            hashMap.put(string3, string2);
                            continue;
                        }
                        if (string3.indexOf(string) <= -1) continue;
                        hashMap.put(string3, string2);
                    }
                    var16_6 = null;
                    if (!bl2) return hashMap;
                    break;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this);
                    }
                    retryStrategy.assertShouldRetry(exception2);
                    var16_6 = null;
                    if (!bl2) continue;
                    this.closeSQLObjects(resultSet, null, connection, exception);
                }
            }
            catch (Throwable throwable) {
                var16_6 = null;
                if (!bl2) throw throwable;
                this.closeSQLObjects(resultSet, null, connection, exception);
                throw throwable;
            }
        }
        this.closeSQLObjects(resultSet, null, connection, exception);
        return hashMap;
    }

    public abstract void closeSQLObjects(ResultSet var1, Statement var2, Connection var3, Throwable var4) throws BrokerException;

    public static SQLException wrapSQLException(String string, SQLException sQLException) {
        MQSQLException mQSQLException = new MQSQLException(string + ": " + sQLException.getMessage() + "[" + sQLException.getSQLState() + ", " + sQLException.getErrorCode() + "]", sQLException.getSQLState(), sQLException.getErrorCode());
        mQSQLException.initCause(sQLException);
        return mQSQLException;
    }

    public static IOException wrapIOException(String string, IOException iOException) {
        IOException iOException2 = new IOException(string + ": " + iOException.getMessage());
        iOException2.initCause(iOException);
        return iOException2;
    }

    private void initDataSource(Class clazz, Object object) {
        String string = this.vendorPropPrefix + ".property.";
        List list = this.config.getPropertyNames(string);
        if (list.size() == 0 && Store.getDEBUG()) {
            this.logger.log(4, "DataSource properties not specified!");
        }
        Method[] methodArray = clazz.getMethods();
        Object[] objectArray = new Object[1];
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            Exception exception;
            block14: {
                exception = null;
                string2 = null;
                String string3 = (String)iterator.next();
                String string4 = this.config.getProperty(string3).trim();
                if (string4.length() > 0) {
                    String string5 = string3.substring(string.length(), string3.length());
                    if (string5.equalsIgnoreCase("url") || string5.equalsIgnoreCase("serverList")) {
                        this.openDBUrl = string4;
                    } else {
                        this.logger.log(64, string3 + "=" + string4);
                    }
                    String string6 = ("set" + string5).toLowerCase();
                    Method method = null;
                    Class<?> clazz2 = null;
                    for (Method method2 : methodArray) {
                        Class<?>[] classArray = method2.getParameterTypes();
                        if (!string6.equals(method2.getName().toLowerCase()) || classArray.length != 1) continue;
                        method = method2;
                        clazz2 = classArray[0];
                        break;
                    }
                    if (method != null) {
                        try {
                            if (clazz2.equals(Boolean.TYPE)) {
                                objectArray[0] = Boolean.valueOf(string4);
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            if (clazz2.equals(Integer.TYPE)) {
                                objectArray[0] = Integer.valueOf(string4);
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            if (clazz2.equals(String.class)) {
                                objectArray[0] = string4;
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            string2 = "Unable to initialize DataSource Property: " + string3 + ", value: " + string4;
                        }
                    } else {
                        string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                    }
                } else {
                    string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                }
            }
            if (string2 == null) continue;
            this.logger.log(32, string2, exception);
        }
    }

    protected void loadTableSchema() throws BrokerException {
        List list = this.config.getPropertyNames(this.tablePropPrefix);
        if (list.size() == 0) {
            throw new BrokerException("Table definition not found for " + this.vendor);
        }
        Collections.sort(list);
        Properties properties = new Properties();
        String string = this.vendorPropPrefix + "." + TABLEOPTION_NAME_VARIABLE;
        String string2 = this.config.getProperty(string, "").trim();
        properties.setProperty(TABLEOPTION_NAME_VARIABLE, string2);
        if (string2 != null && !string2.equals("")) {
            this.logger.log(64, string + "=" + string2);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            String string3;
            String string4;
            int n;
            string = ((String)listIterator.next()).trim();
            string2 = this.config.getProperty(string).trim();
            int n2 = string.indexOf(".index.");
            if (n2 > 0) {
                n = string.indexOf(".table.");
                string4 = string.substring(n + 7, n2) + this.tableSuffix;
                string3 = string4 + string.substring(n2 + 7);
                properties.setProperty(TABLE_NAME_VARIABLE, string4);
                properties.setProperty(INDEX_NAME_VARIABLE, string3);
                object = StringUtil.expandVariables(string2, properties);
                TableSchema tableSchema = (TableSchema)this.tableSchemas.get(string4);
                if (tableSchema == null) continue;
                tableSchema.addIndex(string3, (String)object);
                continue;
            }
            n2 = string.indexOf(".aftercreate");
            if (n2 > 0) {
                n = string.indexOf(".table.");
                string4 = string.substring(n + 7, n2) + this.tableSuffix;
                properties.setProperty(TABLE_NAME_VARIABLE, string4);
                string3 = StringUtil.expandVariables(string2, properties);
                object = (TableSchema)this.tableSchemas.get(string4);
                if (object == null) continue;
                ((TableSchema)object).setAfterCreateSQL(string3);
                continue;
            }
            n2 = string.indexOf(".afterdrop");
            if (n2 > 0) {
                n = string.indexOf(".table.");
                string4 = string.substring(n + 7, n2) + this.tableSuffix;
                properties.setProperty(TABLE_NAME_VARIABLE, string4);
                string3 = StringUtil.expandVariables(string2, properties);
                object = (TableSchema)this.tableSchemas.get(string4);
                if (object == null) continue;
                ((TableSchema)object).setAfterDropSQL(string3);
                continue;
            }
            n = string.lastIndexOf(46);
            string4 = string.substring(n + 1) + this.tableSuffix;
            properties.setProperty(TABLE_NAME_VARIABLE, string4);
            string3 = StringUtil.expandVariables(string2, properties);
            object = new TableSchema(string4, string3);
            this.tableSchemas.put(string4, object);
        }
        this.checkTables();
    }

    private void checkTables() throws BrokerException {
        Iterator iterator = this.allDAOIterator();
        while (iterator.hasNext()) {
            BaseDAO baseDAO = (BaseDAO)iterator.next();
            String string = baseDAO.getTableName();
            TableSchema tableSchema = (TableSchema)this.tableSchemas.get(string);
            if (tableSchema == null || tableSchema.tableSQL.length() == 0) {
                throw new BrokerException(this.br.getKString("B3127", string, this.getJDBCPropPrefix() + "." + string));
            }
            if (!Store.getDEBUG()) continue;
            this.logger.log(4, string + ": '" + tableSchema.tableSQL + "'");
        }
    }

    private String getPassword() {
        String string;
        String string2 = this.getJDBCPropPrefix();
        this.passwordProp = this.vendorPropPrefix + FALLBACK_PWD_PROP_SUFFIX;
        String string3 = this.config.getProperty(this.passwordProp);
        if (string3 == null && (string3 = this.config.getProperty(string2 + FALLBACK_PWD_PROP_SUFFIX)) != null) {
            this.passwordProp = string2 + FALLBACK_PWD_PROP_SUFFIX;
        }
        this.needPasswordProp = this.vendorPropPrefix + ".needpassword";
        if (this.config.getProperty(this.needPasswordProp) == null && this.config.getProperty(string = string2 + ".needpassword") != null) {
            this.needPasswordProp = string;
        }
        this.needPassword = this.config.getBooleanProperty(this.needPasswordProp, false);
        if (string3 == null && this.needPassword) {
            int n = 0;
            Password password = new Password();
            if (password.echoPassword()) {
                System.err.println(Globals.getBrokerResources().getString("B2242"));
            }
            while ((string3 == null || string3.trim().equals("")) && n < 5) {
                System.err.print(this.br.getString("B0039", this.openDBUrl));
                System.err.flush();
                string3 = password.getPassword();
                ++n;
            }
        }
        return string3;
    }

    private void checkHADBJDBCLogging() {
        String string = this.config.getProperty("com.sun.hadb.jdbc.level");
        if (string != null && string.length() > 0) {
            String string2 = StringUtil.expandVariables("${imq.instanceshome}${/}${imq.instancename}${/}log${/}hadbLog.txt", this.config);
            this.logger.log(8, "Enable HADB's JDBC driver logging (level=" + string + "): " + string2);
            try {
                java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.sun.hadb.jdbc");
                FileHandler fileHandler = new FileHandler(string2, true);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
                logger.setLevel(Level.parse(string));
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Failed to enable HADB's JDBC driver logging", exception);
            }
        }
    }

    private static Class GET_TRANSIENT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransientException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class GET_RECOVERABLE_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLRecoverableException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class GET_NONTRANSIENT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLNonTransientException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class GET_TRANSIENT_CONNECTION_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransientConnectionException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class GET_TRANSACTION_ROLLBACK_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransactionRollbackException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class GET_TIMEOUT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTimeoutException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

