/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class OracleMessageDAOImpl
extends MessageDAOImpl {
    OracleMessageDAOImpl() throws BrokerException {
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("STORE_SESSION_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, EMPTY_BLOB() )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, long l2, boolean bl, boolean bl2) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl3;
        block38: {
            block37: {
                block36: {
                    block34: {
                        block35: {
                            bl3 = false;
                            preparedStatement = null;
                            exception = null;
                            try {
                                try {
                                    Object object;
                                    Object object2;
                                    Object object3;
                                    Object object4;
                                    DBManager dBManager = DBManager.getDBManager();
                                    if (!dBManager.isOracleDriver()) {
                                        super.insert(connection, string, packet, consumerUIDArray, nArray, l, l2, bl, bl2);
                                        Object var30_15 = null;
                                        if (!bl3) break block34;
                                        break block35;
                                    }
                                    if (connection == null) {
                                        connection = dBManager.getConnection(false);
                                        bl3 = true;
                                    }
                                    SysMessageID sysMessageID = packet.getSysMessageID();
                                    String string2 = sysMessageID.getUniqueName();
                                    int n = packet.getPacketSize();
                                    long l3 = packet.getTransactionID();
                                    if (string == null) {
                                        string = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                                    }
                                    if (bl) {
                                        boolean bl4 = false;
                                        try {
                                            bl4 = this.hasMessage(connection, string2);
                                        }
                                        catch (BrokerException brokerException) {
                                            brokerException.setSQLRecoverable(true);
                                            brokerException.setSQLReplayCheck(bl2);
                                            throw brokerException;
                                        }
                                        if (bl4 && bl2) {
                                            if (consumerUIDArray != null) {
                                                object4 = null;
                                                try {
                                                    object4 = dBManager.getDAOFactory().getConsumerStateDAO().getStates(connection, sysMessageID);
                                                }
                                                catch (BrokerException brokerException) {
                                                    brokerException.setSQLRecoverable(true);
                                                    brokerException.setSQLReplayCheck(true);
                                                    throw brokerException;
                                                }
                                                object3 = Arrays.asList(consumerUIDArray);
                                                object2 = ((HashMap)object4).entrySet().iterator();
                                                object = null;
                                                ConsumerUID consumerUID = null;
                                                while (object2.hasNext()) {
                                                    object = (Map.Entry)object2.next();
                                                    consumerUID = (ConsumerUID)object.getKey();
                                                    int n2 = (Integer)object.getValue();
                                                    for (int i = 0; i < consumerUIDArray.length; ++i) {
                                                        if (!consumerUIDArray[i].equals(consumerUID) || nArray[i] != n2) continue;
                                                        object3.remove(consumerUIDArray[i]);
                                                    }
                                                }
                                                if (object3.size() == 0) {
                                                    this.logger.log(8, "B1430", string2 + "[" + string + "]" + object3);
                                                    break block36;
                                                }
                                            } else {
                                                this.logger.log(8, "B1430", string2 + "[" + string + "]");
                                                break block37;
                                            }
                                        }
                                        if (bl4) {
                                            throw new BrokerException(this.br.getKString("B3008", string2, string));
                                        }
                                        try {
                                            dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string);
                                        }
                                        catch (BrokerException brokerException) {
                                            if (brokerException.getStatusCode() == 404) throw brokerException;
                                            brokerException.setSQLRecoverable(true);
                                            throw brokerException;
                                        }
                                    }
                                    String string3 = this.insertSQL;
                                    try {
                                        preparedStatement = connection.prepareStatement(string3);
                                        preparedStatement.setString(1, string2);
                                        preparedStatement.setInt(2, n);
                                        preparedStatement.setLong(3, l);
                                        preparedStatement.setString(4, string);
                                        Util.setLong(preparedStatement, 5, l3 == 0L ? -1L : l3);
                                        preparedStatement.setLong(6, l2);
                                        preparedStatement.executeUpdate();
                                        preparedStatement.close();
                                        string3 = this.selectForUpdateSQL;
                                        preparedStatement = connection.prepareStatement(string3);
                                        preparedStatement.setString(1, string2);
                                        object4 = preparedStatement.executeQuery();
                                        object4.next();
                                        object3 = object4.getBlob(1);
                                        object4.close();
                                        preparedStatement.close();
                                        object2 = Util.OracleBLOB_getBinaryOutputStream((Blob)object3);
                                        packet.writePacket((OutputStream)object2);
                                        ((OutputStream)object2).close();
                                        if (consumerUIDArray != null) {
                                            dBManager.getDAOFactory().getConsumerStateDAO().insert(connection, string, sysMessageID, consumerUIDArray, nArray, false, false);
                                        }
                                        if (bl3) {
                                            connection.commit();
                                        }
                                        break block38;
                                    }
                                    catch (Exception exception2) {
                                        exception = exception2;
                                        boolean bl5 = false;
                                        try {
                                            if (connection != null && !connection.getAutoCommit()) {
                                                connection.rollback();
                                            }
                                        }
                                        catch (SQLException sQLException) {
                                            bl5 = true;
                                            this.logger.log(32, "B4080", sQLException);
                                        }
                                        if (exception2 instanceof BrokerException) {
                                            throw (BrokerException)exception2;
                                        }
                                        object2 = exception2 instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception2) : (exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2) : exception2);
                                        object = new BrokerException(this.br.getKString("B4004", string2), (Throwable)object2);
                                        ((BrokerException)object).setSQLRecoverable(true);
                                        if (!bl5) throw object;
                                        ((BrokerException)object).setSQLReplayCheck(true);
                                        throw object;
                                    }
                                }
                                catch (BrokerException brokerException) {
                                    exception = brokerException;
                                    throw brokerException;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var30_19 = null;
                                if (bl3) {
                                    Util.close(null, preparedStatement, connection, exception);
                                    throw throwable;
                                }
                                Util.close(null, preparedStatement, null, exception);
                                throw throwable;
                            }
                        }
                        Util.close(null, preparedStatement, connection, exception);
                        return;
                    }
                    Util.close(null, preparedStatement, null, exception);
                    return;
                }
                Object var30_16 = null;
                if (bl3) {
                    Util.close(null, preparedStatement, connection, exception);
                    return;
                }
                Util.close(null, preparedStatement, null, exception);
                return;
            }
            Object var30_17 = null;
            if (bl3) {
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var30_18 = null;
        if (bl3) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveMessage(Connection connection, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl;
        block18: {
            block16: {
                block17: {
                    SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
                    String string = sysMessageID.getUniqueName();
                    int n = packet.getPacketSize();
                    bl = false;
                    preparedStatement = null;
                    String string2 = this.selectForUpdateSQL;
                    exception = null;
                    try {
                        try {
                            DBManager dBManager = DBManager.getDBManager();
                            if (!dBManager.isOracleDriver()) {
                                super.moveMessage(connection, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                                Object var20_16 = null;
                                if (!bl) break block16;
                                break block17;
                            }
                            if (connection == null) {
                                connection = dBManager.getConnection(false);
                                bl = true;
                            }
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setString(1, string);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) {
                                throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                            }
                            Blob blob = resultSet.getBlob(1);
                            resultSet.close();
                            preparedStatement.close();
                            OutputStream outputStream = Util.OracleBLOB_getBinaryOutputStream(blob);
                            packet.writePacket(outputStream);
                            outputStream.close();
                            string2 = this.updateDestinationSQL;
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setString(1, destinationUID2.toString());
                            preparedStatement.setInt(2, n);
                            preparedStatement.setString(3, string);
                            preparedStatement.executeUpdate();
                            ConsumerStateDAO consumerStateDAO = dBManager.getDAOFactory().getConsumerStateDAO();
                            consumerStateDAO.deleteByMessageID(connection, sysMessageID);
                            if (consumerUIDArray != null || nArray != null) {
                                consumerStateDAO.insert(connection, destinationUID2.toString(), sysMessageID, consumerUIDArray, nArray, false, false);
                            }
                            if (bl) {
                                connection.commit();
                            }
                            break block18;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            try {
                                if (connection != null && !connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (SQLException sQLException) {
                                this.logger.log(32, "B4080", sQLException);
                            }
                            if (exception2 instanceof BrokerException) {
                                throw (BrokerException)exception2;
                            }
                            Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)exception2) : exception2;
                            Object[] objectArray = new Object[]{string, destinationUID, destinationUID2};
                            throw new BrokerException(this.br.getKString("B4187", objectArray), exception3);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_18 = null;
                        if (bl) {
                            Util.close(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        Util.close(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var20_17 = null;
        if (bl) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }
}

