/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ConsumerStateDAOImpl
extends BaseDAOImpl
implements ConsumerStateDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTransactionSQL;
    protected String updateStateSQL;
    protected String updateState2SQL;
    protected String clearTxnSQL;
    protected String deleteByTxnSQL;
    protected String deleteByDstSQL;
    protected String deleteByStateSQL;
    protected String deleteByMsgSQL;
    protected String selectStateSQL;
    protected String selectStatesByMsgSQL;
    protected String selectTransactionSQL;
    protected String selectCountByMsgSQL;
    protected String selectConsumerIDsByMsgSQL;
    protected String selectTransactionAcksSQL;
    protected String selectAllTransactionAcksSQL;

    ConsumerStateDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dBManager.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dBManager.getTableName("MQCONSTATE41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        this.updateTransactionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" IS NULL").append(string).toString();
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.updateState2SQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.clearTxnSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = NULL").append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(string).toString();
        this.deleteByTxnSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByMsgSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.deleteByStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" = ?").toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectStatesByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectTransactionSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectCountByMsgSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectConsumerIDsByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ? ").append(" AND ").append("STATE").append(" <> ").append(2).toString();
        this.selectTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.selectAllTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(", ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" IS NOT NULL").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCONSTATE41";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl, boolean bl2) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl3;
        block32: {
            block30: {
                block31: {
                    String string2 = sysMessageID.getUniqueName();
                    int n = 0;
                    bl3 = false;
                    preparedStatement = null;
                    exception = null;
                    try {
                        try {
                            int n2;
                            DBManager dBManager = DBManager.getDBManager();
                            if (connection == null) {
                                connection = dBManager.getConnection(false);
                                bl3 = true;
                            }
                            if (bl) {
                                n2 = -1;
                                try {
                                    n2 = this.getConsumerCount(connection, string2);
                                }
                                catch (BrokerException brokerException) {
                                    brokerException.setSQLRecoverable(true);
                                    brokerException.setSQLReplayCheck(bl2);
                                    throw brokerException;
                                }
                                if (n2 > 0 && bl2 && consumerUIDArray != null) {
                                    HashMap hashMap = null;
                                    try {
                                        hashMap = this.getStates(connection, sysMessageID);
                                    }
                                    catch (BrokerException brokerException) {
                                        brokerException.setSQLRecoverable(true);
                                        brokerException.setSQLReplayCheck(bl2);
                                        throw brokerException;
                                    }
                                    List<ConsumerUID> list = Arrays.asList(consumerUIDArray);
                                    Iterator iterator = hashMap.entrySet().iterator();
                                    Map.Entry entry = null;
                                    ConsumerUID consumerUID = null;
                                    while (iterator.hasNext()) {
                                        entry = iterator.next();
                                        consumerUID = (ConsumerUID)entry.getKey();
                                        int n3 = (Integer)entry.getValue();
                                        for (int i = 0; i < consumerUIDArray.length; ++i) {
                                            if (!consumerUIDArray[i].equals(consumerUID) || nArray[i] != n3) continue;
                                            list.remove(consumerUIDArray[i]);
                                        }
                                    }
                                    if (list.size() == 0) {
                                        this.logger.log(8, "B1430", string2 + "[" + string + "]" + list);
                                        Object var23_31 = null;
                                        if (!bl3) break block30;
                                        break block31;
                                    }
                                }
                                if (n2 > 0) {
                                    throw new BrokerException(this.br.getKString("B3084", string2));
                                }
                                try {
                                    dBManager.getDAOFactory().getMessageDAO().checkMessage(connection, string, string2);
                                }
                                catch (BrokerException brokerException) {
                                    if (brokerException.getStatusCode() == 404) throw brokerException;
                                    brokerException.setSQLRecoverable(true);
                                    throw brokerException;
                                }
                            }
                            n2 = dBManager.supportsBatchUpdates() ? 1 : 0;
                            preparedStatement = connection.prepareStatement(this.insertSQL);
                            int n4 = consumerUIDArray.length;
                            while (n < n4) {
                                preparedStatement.setString(1, string2);
                                preparedStatement.setLong(2, consumerUIDArray[n].longValue());
                                preparedStatement.setInt(3, nArray[n]);
                                preparedStatement.setLong(4, System.currentTimeMillis());
                                if (n2 != 0) {
                                    preparedStatement.addBatch();
                                } else {
                                    preparedStatement.executeUpdate();
                                }
                                ++n;
                            }
                            if (n2 != 0) {
                                preparedStatement.executeBatch();
                            }
                            if (bl3) {
                                connection.commit();
                            }
                            break block32;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            if (Store.getDEBUG() && n < consumerUIDArray.length) {
                                this.logger.log(4, "Failed to persist interest: " + consumerUIDArray[n].toString() + "(" + consumerUIDArray[n].getUniqueName() + ")");
                            }
                            boolean bl4 = false;
                            try {
                                if (connection != null && !connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (SQLException sQLException) {
                                bl4 = true;
                                this.logger.log(32, "B4080", sQLException);
                            }
                            if (exception2 instanceof BrokerException) {
                                throw (BrokerException)exception2;
                            }
                            Exception exception3 = exception2 instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception2) : (exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2) : exception2);
                            BrokerException brokerException = new BrokerException(this.br.getKString("B4105", string2), exception3);
                            brokerException.setSQLRecoverable(true);
                            if (!bl4) throw brokerException;
                            brokerException.setSQLReplayCheck(true);
                            throw brokerException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var23_33 = null;
                        if (bl3) {
                            Util.close(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        Util.close(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var23_32 = null;
        if (bl3) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl2;
        block27: {
            block25: {
                block26: {
                    String string = sysMessageID.getUniqueName();
                    bl2 = false;
                    preparedStatement = null;
                    exception = null;
                    try {
                        try {
                            String string2;
                            DBManager dBManager;
                            block24: {
                                dBManager = DBManager.getDBManager();
                                if (connection == null) {
                                    connection = dBManager.getConnection(true);
                                    bl2 = true;
                                }
                                string2 = null;
                                if (Globals.getHAEnabled()) {
                                    try {
                                        string2 = dBManager.getDAOFactory().getMessageDAO().getBroker(connection, destinationUID, string);
                                    }
                                    catch (BrokerException brokerException) {
                                        if (brokerException.getStatusCode() == 404) throw brokerException;
                                        brokerException.setSQLRecoverable(true);
                                        brokerException.setSQLReplayCheck(bl);
                                        throw brokerException;
                                    }
                                } else {
                                    string2 = dBManager.getBrokerID();
                                }
                                if (bl) {
                                    try {
                                        int n2 = this.getState(connection, sysMessageID, consumerUID);
                                        if (n2 != n) break block24;
                                        this.logger.log(8, "B1430", string + "[" + destinationUID + "]" + consumerUID + ":" + n);
                                    }
                                    catch (BrokerException brokerException) {
                                        if (brokerException.getStatusCode() == 404) throw brokerException;
                                        brokerException.setSQLRecoverable(true);
                                        brokerException.setSQLReplayCheck(true);
                                        throw brokerException;
                                    }
                                    Object var18_21 = null;
                                    if (!bl2) break block25;
                                    break block26;
                                }
                            }
                            if (Globals.getHAEnabled() && !dBManager.getBrokerID().equals(string2)) {
                                String string3 = this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString());
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223[" + string3 + "]"));
                                try {
                                    BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, dBManager.getBrokerID());
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                    throw storeBeingTakenOverException;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                            preparedStatement = connection.prepareStatement(this.updateStateSQL);
                            preparedStatement.setInt(1, n);
                            preparedStatement.setString(2, string);
                            preparedStatement.setLong(3, consumerUID.longValue());
                            if (preparedStatement.executeUpdate() == 0) {
                                throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                            }
                            break block27;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            boolean bl3 = false;
                            try {
                                if (connection != null && !connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (SQLException sQLException) {
                                bl3 = true;
                                this.logger.log(32, "B4080", sQLException);
                            }
                            if (exception2 instanceof BrokerException) {
                                throw (BrokerException)exception2;
                            }
                            Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception2) : exception2;
                            BrokerException brokerException = new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception3);
                            brokerException.setSQLRecoverable(true);
                            if (!bl3) throw brokerException;
                            brokerException.setSQLReplayCheck(true);
                            throw brokerException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_23 = null;
                        if (bl2) {
                            Util.close(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        Util.close(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var18_22 = null;
        if (bl2) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block13: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateState2SQL);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    preparedStatement.setInt(4, n2);
                    if (preparedStatement.executeUpdate() == 0) {
                        int n3 = this.getState(connection, sysMessageID, consumerUID);
                        if (n3 == n2) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                        Object[] objectArray = new String[]{consumerUID.toString(), sysMessageID.toString(), String.valueOf(n2), String.valueOf(n3)};
                        throw new BrokerException(this.br.getKString("B3180", objectArray), 412);
                    }
                    Object var14_16 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.updateState2SQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, TransactionUID transactionUID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block18: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getTransactionDAO().checkTransaction(connection, transactionUID.longValue());
                    preparedStatement = connection.prepareStatement(this.updateTransactionSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(4, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        long l;
                        if (Globals.getHAEnabled()) {
                            String string2 = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string2)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string2);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                    throw storeBeingTakenOverException;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        if ((l = this.getTransaction(connection, sysMessageID, consumerUID)) <= 0L) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                        String string3 = "[" + sysMessageID + "]" + consumerUID;
                        throw new TransactionAckExistException(this.br.getKString("B4056", string3, transactionUID) + " : " + this.br.getKString("B3062", string3, String.valueOf(l)), 409);
                    }
                    Object var15_20 = null;
                    if (!bl) break block18;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.updateTransactionSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block17: {
            long l = transactionUID.longValue();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.clearTxnSQL);
                    preparedStatement.setLong(1, l);
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(2, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0 && Globals.getHAEnabled()) {
                        String string = dBManager.getBrokerID();
                        BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                        if (brokerDAO.isBeingTakenOver(connection, string)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            try {
                                HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                throw storeBeingTakenOverException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw storeBeingTakenOverException;
                        }
                    }
                    Object var14_16 = null;
                    if (!bl) break block17;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.clearTxnSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4225", transactionUID), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4225", transactionUID), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByMessageID(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByMsgSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteByMsgSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4037", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4037", string), exception3);
                }
                Object var10_7 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            long l = transactionUID.longValue();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByTxnSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteByTxnSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4240", transactionUID), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4240", transactionUID), exception3);
                }
                Object var11_7 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByDestination(Connection connection, DestinationUID destinationUID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            String string = destinationUID.toString();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4227", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4227", string), exception3);
                }
                Object var10_9 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("MESSAGE_ID").append(" IN (SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("' AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(")").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n;
        block12: {
            n = -1;
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    n = resultSet.getInt(1);
                    Object var13_10 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return n;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getStates(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<ConsumerUID, Integer> hashMap;
        block13: {
            hashMap = new HashMap<ConsumerUID, Integer>();
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStatesByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        int n = resultSet.getInt(2);
                        hashMap.put(consumerUID, n);
                    }
                    Object var12_14 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectStatesByMsgSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4228", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4228", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        block13: {
            l = -1L;
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectTransactionSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception3);
                }
                Object var14_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var14_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return l;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getConsumerUIDs(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<ConsumerUID> arrayList;
        block13: {
            arrayList = new ArrayList<ConsumerUID>();
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConsumerIDsByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        arrayList.add(consumerUID);
                    }
                    Object var12_11 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectConsumerIDsByMsgSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4228", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4228", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getTransactionAcks(Connection connection, TransactionUID transactionUID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<TransactionAcknowledgement> arrayList;
        block15: {
            arrayList = new ArrayList<TransactionAcknowledgement>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionAcksSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        try {
                            SysMessageID sysMessageID = SysMessageID.get(resultSet.getString(2));
                            arrayList.add(new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID));
                        }
                        catch (Exception exception2) {
                            this.logger.logStack(32, "B4129", transactionUID, (Throwable)exception2);
                        }
                    }
                    Object var11_14 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception3) {
                    Exception exception4;
                    exception = exception3;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception3 instanceof BrokerException) {
                        throw (BrokerException)exception3;
                    }
                    if (exception3 instanceof SQLException) {
                        exception4 = DBManager.wrapSQLException("[" + this.selectTransactionAcksSQL + "]", (SQLException)exception3);
                        throw new BrokerException(this.br.getKString("B4229", transactionUID), exception4);
                    }
                    exception4 = exception3;
                    throw new BrokerException(this.br.getKString("B4229", transactionUID), exception4);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllTransactionAcks(Connection connection) throws BrokerException {
        List list;
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap;
        block18: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block16: {
                hashMap = new HashMap<Object, Object>(100);
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl = true;
                        }
                        preparedStatement = connection.prepareStatement(this.selectAllTransactionAcksSQL);
                        resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            object3 = new TransactionUID(resultSet.getLong(1));
                            object2 = new ConsumerUID(resultSet.getLong(2));
                            try {
                                object = SysMessageID.get(resultSet.getString(3));
                                list = (ArrayList<TransactionAcknowledgement>)hashMap.get(object3);
                                if (list == null) {
                                    list = new ArrayList<TransactionAcknowledgement>(25);
                                    hashMap.put(object3, list);
                                }
                                list.add(new TransactionAcknowledgement((SysMessageID)object, (ConsumerUID)object2, (ConsumerUID)object2));
                            }
                            catch (Exception exception2) {
                                this.logger.logStack(32, "B4129", object3, (Throwable)exception2);
                            }
                        }
                        Object var12_15 = null;
                        if (!bl) break block16;
                    }
                    catch (Exception exception3) {
                        Exception exception4;
                        exception = exception3;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception3 instanceof BrokerException) {
                            throw (BrokerException)exception3;
                        }
                        if (exception3 instanceof SQLException) {
                            exception4 = DBManager.wrapSQLException("[" + this.selectAllTransactionAcksSQL + "]", (SQLException)exception3);
                            throw new BrokerException(this.br.getKString("B4054"), exception4);
                        }
                        exception4 = exception3;
                        throw new BrokerException(this.br.getKString("B4054"), exception4);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection, exception);
                        throw throwable;
                    }
                    Util.close(resultSet, preparedStatement, null, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, connection, exception);
                break block18;
            }
            Util.close(resultSet, preparedStatement, null, exception);
        }
        object3 = hashMap.keySet();
        if (object3.isEmpty()) return hashMap;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (TransactionUID)object2.next();
            list = (List)hashMap.get(object);
            hashMap.put(object, list.toArray(new TransactionAcknowledgement[0]));
        }
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Message/Consumer states(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getConsumerCount(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n;
        block13: {
            n = -1;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectCountByMsgSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectCountByMsgSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4228", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4228", string), exception3);
                }
                Object var11_8 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return n;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return n;
    }
}

