/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.util.UID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BrokerDAOImpl
extends BaseDAOImpl
implements BrokerDAO {
    public static final String STORE_SESSION_ID_COLUMN = "STORE_SESSION_ID";
    protected String tableName;
    protected String insertSQL;
    protected String updateVersionSQL;
    protected String updateURLSQL;
    protected String resetTakeoverBrokerSQL;
    protected String restoreOnTakeoverFailSQL;
    protected String restoreHeartbeatOnTakeoverFailSQL;
    protected String updateHeartbeatSQL;
    protected String updateHeartbeatAndCheckStateSQL;
    protected String updateStateThisBrokerSQL;
    protected String updateStateOtherBrokerSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllByStateSQL;
    protected String selectHeartbeatSQL;
    protected String selectAllHeartbeatsSQL;
    protected String selectStateSQL;
    protected String selectAllStatesSQL;
    protected String selectIsBeingTakenOverSQL;
    private FaultInjection fi = FaultInjection.getInjection();

    BrokerDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQBKR41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(") VALUES ( ?, ?, ?, ?, ?, ? )").toString();
        this.updateVersionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("VERSION").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateURLSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("URL").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.resetTakeoverBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = NULL, ").append("STATE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" IS NOT NULL").append(" AND ").append("STATE").append(" = ").append(8).toString();
        this.restoreOnTakeoverFailSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = NULL, ").append("STATE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ").append(7).append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.restoreHeartbeatOnTakeoverFailSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ").append(7).append(" AND ").append("HEARTBEAT_TS").append(" = ? ").append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.updateHeartbeatSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeatAndCheckStateSQL = new StringBuffer(this.updateHeartbeatSQL).append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("STATE").append(" NOT IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
        this.updateStateThisBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" IS NULL ").toString();
        this.updateStateOtherBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = ?, ").append("STATE").append(" = ?, ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" is NULL").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT bTbl.").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(", sTbl.").append("ID").append(" AS ").append(STORE_SESSION_ID_COLUMN).append(" FROM ").append(this.tableName).append(" bTbl LEFT JOIN ").append(dBManager.getTableName("MQSES41")).append(" sTbl ON bTbl.").append("ID").append(" = sTbl.").append("BROKER_ID").append(" AND sTbl.").append("IS_CURRENT").append(" = 1").toString();
        this.selectAllByStateSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("STATE").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("ID").append(" = ?").toString();
        this.selectHeartbeatSQL = new StringBuffer(128).append("SELECT ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllHeartbeatsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllStatesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).toString();
        this.selectIsBeingTakenOverSQL = new StringBuffer(128).append("SELECT 1 FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ? AND ").append("STATE").append(" IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
    }

    public final String getTableNamePrefix() {
        return "MQBKR41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, String string2, String string3, int n, int n2, long l, long l2) throws BrokerException {
        PreparedStatement preparedStatement;
        Exception exception;
        block13: {
            exception = null;
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string3);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setInt(4, n2);
                    Util.setString(preparedStatement, 5, string2);
                    Util.setLong(preparedStatement, 6, l2);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    dBManager.getDAOFactory().getStoreSessionDAO().insert(connection, string, l, true);
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4217", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4217", string), exception3);
                }
                Object var17_14 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public UID update(Connection connection, String string, int n, Object object, Object object2) throws BrokerException {
        UID uID;
        block23: {
            Exception exception;
            PreparedStatement preparedStatement;
            block22: {
                String string2 = "";
                UID uID2 = null;
                boolean bl = false;
                preparedStatement = null;
                exception = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    switch (n) {
                        case 0: {
                            string2 = this.updateVersionSQL;
                            preparedStatement = connection.prepareStatement(this.updateVersionSQL);
                            preparedStatement.setInt(1, (Integer)object2);
                            preparedStatement.setString(2, string);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                            break;
                        }
                        case 1: {
                            string2 = this.updateURLSQL;
                            preparedStatement = connection.prepareStatement(this.updateURLSQL);
                            preparedStatement.setString(1, (String)object2);
                            preparedStatement.setString(2, string);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                            break;
                        }
                        case 2: {
                            string2 = this.resetTakeoverBrokerSQL;
                            preparedStatement = connection.prepareStatement(this.resetTakeoverBrokerSQL);
                            preparedStatement.setInt(1, BrokerState.OPERATING.intValue());
                            preparedStatement.setString(2, string);
                            int n2 = preparedStatement.executeUpdate();
                            preparedStatement.close();
                            if (n2 == 1) {
                                this.logger.log(8, this.br.getKString("B1332", "TAKEOVER_BROKER", string));
                                long l = dBManager.getDAOFactory().getStoreSessionDAO().insert(connection, string, ((UID)object2).longValue(), false);
                                this.logger.log(8, this.br.getKString("B1333", string, String.valueOf(l)));
                                uID2 = new UID(l);
                                break;
                            }
                            if (n2 == 0) {
                                string2 = this.updateStateThisBrokerSQL;
                                if (this.updateState(connection, string, BrokerState.OPERATING, (BrokerState)object, true)) break;
                                HABrokerInfo hABrokerInfo = this.getBrokerInfo(connection, string);
                                throw new BrokerException("IllegalStateException for updating state " + object + " to " + BrokerState.OPERATING.toString() + ": " + hABrokerInfo);
                            }
                            throw new BrokerException("Unexpected affected row count " + n2 + " for updating broker info " + string);
                        }
                        case 4: {
                            if (this.fi.FAULT_INJECTION) {
                                this.fi.checkFaultAndThrowBrokerException("ha.takeover.restore.exception", null);
                                this.fi.checkFaultAndExit("ha.takeover.restore.halt", null, 2, false);
                            }
                            string2 = this.restoreOnTakeoverFailSQL;
                            preparedStatement = connection.prepareStatement(this.restoreOnTakeoverFailSQL);
                            preparedStatement.setInt(1, ((HABrokerInfo)object2).getState());
                            preparedStatement.setString(2, string);
                            preparedStatement.setString(3, (String)object);
                            int n2 = preparedStatement.executeUpdate();
                            preparedStatement.close();
                            if (n2 == 1) break;
                            throw new BrokerException("Unexpected affected row count " + n2 + " for restoring broker info " + string);
                        }
                        case 3: {
                            string2 = this.restoreHeartbeatOnTakeoverFailSQL;
                            preparedStatement = connection.prepareStatement(this.restoreHeartbeatOnTakeoverFailSQL);
                            preparedStatement.setLong(1, ((HABrokerInfo)object2).getHeartbeat());
                            preparedStatement.setString(2, string);
                            preparedStatement.setLong(3, ((HABrokerInfo)object2).getTakeoverTimestamp());
                            preparedStatement.setString(4, (String)object);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                            break;
                        }
                        default: {
                            throw new BrokerException("B3044 Unknown update type " + n + " for updating broker info " + string);
                        }
                    }
                    if (bl) {
                        connection.commit();
                    }
                    uID = uID2;
                    Object var16_19 = null;
                    if (!bl) break block22;
                }
                catch (Exception exception2) {
                    try {
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception2) : exception2;
                        throw new BrokerException(this.br.getKString("B4217", string), exception3);
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        if (bl) {
                            Util.close(null, preparedStatement, connection, exception);
                        } else {
                            Util.close(null, preparedStatement, null, exception);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                break block23;
            }
            Util.close(null, preparedStatement, null, exception);
        }
        return uID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long updateHeartbeat(Connection connection, String string) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        Long l;
        block14: {
            l = null;
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        try {
                            connection = DBManager.getDBManager().getConnectionNoRetry(true);
                            bl = true;
                        }
                        catch (BrokerException brokerException) {
                            brokerException.setSQLReconnect(true);
                            brokerException.setSQLRecoverable(true);
                            throw brokerException;
                        }
                    }
                    long l2 = System.currentTimeMillis();
                    preparedStatement = connection.prepareStatement(this.updateHeartbeatSQL);
                    preparedStatement.setLong(1, l2);
                    preparedStatement.setString(2, string);
                    if (preparedStatement.executeUpdate() == 1) {
                        l = new Long(l2);
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatSQL + "]", (SQLException)exception2) : exception2;
                    BrokerException brokerException = new BrokerException(this.br.getKString("B4222", string), exception3);
                    brokerException.setSQLRecoverable(true);
                    throw brokerException;
                }
                Object var11_10 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return l;
        }
        Util.close(null, preparedStatement, null, exception);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long updateHeartbeat(Connection connection, String string, long l) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        Long l2;
        block18: {
            l2 = null;
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        try {
                            connection = DBManager.getDBManager().getConnectionNoRetry(true);
                            bl = true;
                        }
                        catch (BrokerException brokerException) {
                            brokerException.setSQLReconnect(true);
                            brokerException.setSQLRecoverable(true);
                            throw brokerException;
                        }
                    }
                    long l3 = System.currentTimeMillis();
                    preparedStatement = connection.prepareStatement(this.updateHeartbeatAndCheckStateSQL);
                    preparedStatement.setLong(1, l3);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, l);
                    if (preparedStatement.executeUpdate() == 0) {
                        HABrokerInfo hABrokerInfo = this.getBrokerInfo(connection, string);
                        if (hABrokerInfo == null) {
                            String string2 = this.br.getKString("B3169", string);
                            throw new BrokerException(this.br.getKString("B4223", string, string2));
                        }
                        String string3 = hABrokerInfo.getTakeoverBrokerID();
                        int n = hABrokerInfo.getState();
                        if (string3 != null && string3.length() > 0 && (n == 9 || n == 7 || n == 8 || n == 10)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            this.logger.log(32, this.br.getKString("B4223", string, hABrokerInfo.toString()), storeBeingTakenOverException);
                            throw storeBeingTakenOverException;
                        }
                    } else {
                        l2 = new Long(l3);
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                    boolean bl2 = false;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                            bl2 = true;
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatAndCheckStateSQL + "]", (SQLException)exception2) : exception2;
                    String string4 = "Expected last heartbeat " + l;
                    BrokerException brokerException = new BrokerException(this.br.getKString("B4223", string, string4), exception3);
                    brokerException.setSQLRecoverable(bl2);
                    throw brokerException;
                }
                Object var16_20 = null;
                if (!bl) break block18;
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return l2;
        }
        Util.close(null, preparedStatement, null, exception);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateState(Connection connection, String string, BrokerState brokerState, BrokerState brokerState2, boolean bl) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl2;
        block17: {
            String string2 = "";
            bl2 = false;
            boolean bl3 = false;
            preparedStatement = null;
            exception = null;
            try {
                block16: {
                    try {
                        if (connection == null) {
                            try {
                                connection = DBManager.getDBManager().getConnectionNoRetry(true);
                                bl3 = true;
                            }
                            catch (BrokerException brokerException) {
                                brokerException.setSQLReconnect(true);
                                brokerException.setSQLRecoverable(true);
                                throw brokerException;
                            }
                        }
                        if (bl) {
                            string2 = this.updateStateThisBrokerSQL;
                            preparedStatement = connection.prepareStatement(this.updateStateThisBrokerSQL);
                            preparedStatement.setInt(1, brokerState.intValue());
                            preparedStatement.setString(2, string);
                            preparedStatement.setInt(3, brokerState2.intValue());
                            if (preparedStatement.executeUpdate() == 1) {
                                bl2 = true;
                            }
                            break block16;
                        }
                        string2 = this.updateStateOtherBrokerSQL;
                        preparedStatement = connection.prepareStatement(this.updateStateOtherBrokerSQL);
                        preparedStatement.setInt(1, brokerState.intValue());
                        preparedStatement.setString(2, string);
                        preparedStatement.setInt(3, brokerState2.intValue());
                        preparedStatement.setString(4, DBManager.getDBManager().getBrokerID());
                        if (preparedStatement.executeUpdate() == 1) {
                            bl2 = true;
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        boolean bl4 = false;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                                bl4 = true;
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception2) : exception2;
                        BrokerException brokerException = new BrokerException(this.br.getKString("B4217", string), exception3);
                        brokerException.setSQLRecoverable(bl4);
                        throw brokerException;
                    }
                }
                Object var16_13 = null;
                if (!bl3) break block17;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (bl3) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return bl2;
        }
        Util.close(null, preparedStatement, null, exception);
        return bl2;
    }

    public HABrokerInfo takeover(Connection connection, String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws BrokerException {
        HABrokerInfo hABrokerInfo = null;
        PreparedStatement preparedStatement = null;
        Exception exception = null;
        try {
            try {
                hABrokerInfo = this.getBrokerInfo(connection, string2);
                if (hABrokerInfo == null) {
                    String string3 = this.br.getKString("B3169", string2);
                    throw new BrokerException(this.br.getKString("B3100", string3));
                }
                preparedStatement = connection.prepareStatement(this.takeoverSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, brokerState2.intValue());
                preparedStatement.setLong(3, l2);
                preparedStatement.setString(4, string2);
                preparedStatement.setInt(5, brokerState.intValue());
                preparedStatement.setLong(6, l);
                if (preparedStatement.executeUpdate() != 1) {
                    String string4 = this.br.getKString("B3170", string2);
                    TakeoverLockException takeoverLockException = new TakeoverLockException(string4);
                    takeoverLockException.setBrokerInfo(hABrokerInfo);
                    throw takeoverLockException;
                }
                Object var16_17 = null;
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception2 instanceof BrokerException) {
                    throw (BrokerException)exception2;
                }
                Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)exception2) : exception2;
                throw new BrokerException(this.br.getKString("B3172", string2), exception3);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            Util.close(null, preparedStatement, null, exception);
            throw throwable;
        }
        Util.close(null, preparedStatement, null, exception);
        return hABrokerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, String string) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4220", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4220", string), exception3);
                }
                Object var9_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getHeartbeat(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        block13: {
            l = -1L;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectHeartbeatSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectHeartbeatSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4218", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4218", string), exception3);
                }
                Object var12_8 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return l;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllHeartbeats(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, Long> hashMap;
        block13: {
            hashMap = new HashMap<String, Long>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllHeartbeatsSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        long l = resultSet.getLong(2);
                        hashMap.put(string, new Long(l));
                    }
                    Object var11_12 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllHeartbeatsSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4221"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4221"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BrokerState getState(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        BrokerState brokerState;
        block13: {
            brokerState = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        try {
                            connection = DBManager.getDBManager().getConnectionNoRetry(true);
                            bl = true;
                        }
                        catch (BrokerException brokerException) {
                            brokerException.setSQLReconnect(true);
                            brokerException.setSQLRecoverable(true);
                            throw brokerException;
                        }
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3169", string), 404);
                    brokerState = BrokerState.getState(resultSet.getInt(1));
                    Object var12_10 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception2) : exception2;
                    BrokerException brokerException = new BrokerException(this.br.getKString("B4218", string), exception3);
                    brokerException.setSQLRecoverable(true);
                    throw brokerException;
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return brokerState;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return brokerState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAllStates(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object[] objectArray;
        block13: {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<BrokerState> arrayList2 = new ArrayList<BrokerState>();
            objectArray = new Object[]{arrayList, arrayList2};
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllStatesSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        arrayList.add(string);
                        arrayList2.add(BrokerState.getState(n));
                    }
                    Object var12_14 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectAllStatesSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllStatesSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4221"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4221"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return objectArray;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HABrokerInfo getBrokerInfo(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HABrokerInfo hABrokerInfo;
        block13: {
            hABrokerInfo = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        hABrokerInfo = this.loadData(resultSet);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4218", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4218", string), exception3);
                }
                Object var11_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hABrokerInfo;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hABrokerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllBrokerInfos(Connection connection, boolean bl) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, HABrokerInfo> hashMap;
        block15: {
            hashMap = new HashMap<String, HABrokerInfo>();
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    Object object;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        object = this.loadData(resultSet);
                        hashMap.put(((HABrokerInfo)object).getId(), (HABrokerInfo)object);
                    }
                    if (bl) {
                        resultSet.close();
                        preparedStatement.close();
                        object = dBManager.getDAOFactory().getStoreSessionDAO().getAllStoreSessions(connection);
                        for (Map.Entry entry : object.entrySet()) {
                            String string = (String)entry.getKey();
                            HABrokerInfo hABrokerInfo = (HABrokerInfo)hashMap.get(string);
                            if (hABrokerInfo == null) continue;
                            hABrokerInfo.setSessionList((List)entry.getValue());
                        }
                    }
                    Object var15_17 = null;
                    if (!bl2) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4221"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4221"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllBrokerInfosByState(Connection connection, BrokerState brokerState) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, HABrokerInfo> hashMap;
        block13: {
            hashMap = new HashMap<String, HABrokerInfo>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllByStateSQL);
                    preparedStatement.setInt(1, brokerState.intValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HABrokerInfo hABrokerInfo = this.loadData(resultSet);
                        hashMap.put(hABrokerInfo.getId(), hABrokerInfo);
                    }
                    Object var11_13 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectAllByStateSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllByStateSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4221"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4221"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer(512);
        try {
            Collection collection = this.getAllBrokerInfos(connection, false).values();
            for (Object v : collection) {
                stringBuffer.append(v.toString()).append(BrokerResources.NL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put("Broker(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }

    public boolean isBeingTakenOver(Connection connection, String string) throws BrokerException {
        BrokerState brokerState = this.getState(connection, string);
        int n = brokerState.intValue();
        return n == 9 || n == 7 || n == 8 || n == 10;
    }

    protected HABrokerInfo loadData(ResultSet resultSet) throws SQLException {
        HABrokerInfo hABrokerInfo = new HABrokerInfo(resultSet.getString("ID"), resultSet.getString("TAKEOVER_BROKER"), resultSet.getString("URL"), resultSet.getInt("VERSION"), resultSet.getInt("STATE"), resultSet.getLong(STORE_SESSION_ID_COLUMN), resultSet.getLong("HEARTBEAT_TS"));
        return hABrokerInfo;
    }
}

