/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;

public class ClusterNewMasterBrokerInfo {
    private Long xid = null;
    private String uuid = null;
    private BrokerAddress newmaster = null;
    private BrokerAddress oldmaster = null;
    Cluster c = null;
    private GPacket pkt = null;

    private ClusterNewMasterBrokerInfo(BrokerAddress brokerAddress, BrokerAddress brokerAddress2, String string, Long l, Cluster cluster) {
        this.xid = l;
        this.uuid = string;
        this.c = cluster;
        this.newmaster = brokerAddress;
        this.oldmaster = brokerAddress2;
    }

    private ClusterNewMasterBrokerInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterNewMasterBrokerInfo newInstance(BrokerAddress brokerAddress, BrokerAddress brokerAddress2, String string, Long l, Cluster cluster) {
        return new ClusterNewMasterBrokerInfo(brokerAddress, brokerAddress2, string, l, cluster);
    }

    public static ClusterNewMasterBrokerInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterNewMasterBrokerInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)53);
        gPacket.putProp("TS", new Long(System.currentTimeMillis()));
        gPacket.putProp("X", this.xid);
        gPacket.putProp("UUID", this.uuid);
        gPacket.putProp("oldMasterBroker", this.oldmaster.toProtocolString());
        this.c.marshalBrokerAddress(this.newmaster, gPacket);
        gPacket.setBit(1, true);
        return gPacket;
    }

    public BrokerAddress getNewMasterBroker() throws Exception {
        assert (this.pkt != null);
        this.newmaster = this.c.unmarshalBrokerAddress(this.pkt);
        return this.newmaster;
    }

    public BrokerAddress getOldMasterBroker() throws Exception {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp("oldMasterBroker");
        this.oldmaster = Globals.getMyAddress().fromProtocolString(string);
        return this.oldmaster;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("UUID");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("TS");
    }

    public GPacket getReplyGPacket(int n, String string) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)54);
        gPacket.putProp("X", (Long)this.pkt.getProp("X"));
        gPacket.putProp("UUID", (String)this.pkt.getProp("UUID"));
        gPacket.putProp("S", new Integer(n));
        if (string != null) {
            gPacket.putProp("reason", string);
        }
        return gPacket;
    }

    public String toString() {
        if (this.pkt == null) {
            return "[newMasterBroker=" + this.newmaster + ", oldMasterBroker=" + this.oldmaster + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return (this.newmaster == null ? "" : "[newMasterBroker=" + this.newmaster) + (this.oldmaster == null ? "" : "[oldMasterBroker=" + this.oldmaster) + ", xid=" + this.getXid() + ", ts=" + this.getTimestamp() + ", uuid=" + this.getUUID() + "]";
    }

    public static Long getReplyPacketXid(GPacket gPacket) {
        return (Long)gPacket.getProp("X");
    }
}

