/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.NativeRemoteCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="setup-ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public final class SetupSshKey
extends NativeRemoteCommandsBase {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    int port;
    @Param(optional=true)
    String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=true, defaultValue="false")
    private boolean generatekey;
    @Inject
    private Habitat habitat;

    protected void validate() throws CommandException {
        super.validate();
        Globals.setDefaultHabitat((Habitat)this.habitat);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile();
                if (this.promptForKeyGeneration()) {
                    this.generatekey = true;
                }
            } else {
                this.promptPass = true;
                this.sshkeyfile = existingKey;
                if (SSHUtil.isEncryptedKey((String)this.sshkeyfile)) {
                    this.sshkeypassphrase = this.getSSHPassphrase(false);
                }
            }
        } else {
            this.promptPass = SSHUtil.validateKeyFile((String)this.sshkeyfile);
            if (SSHUtil.isEncryptedKey((String)this.sshkeyfile)) {
                this.sshkeypassphrase = this.getSSHPassphrase(false);
            }
        }
        if (this.sshpublickeyfile != null) {
            SSHUtil.validateKeyFile((String)this.sshpublickeyfile);
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        String previousPassword = null;
        boolean status = false;
        for (String node : this.hosts) {
            block8: {
                sshL.init(this.getRemoteUser(), node, this.getRemotePort(), this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                if (this.generatekey || this.promptPass) {
                    if ((this.sshkeyfile != null || SSHUtil.getExistingKeyFile() != null) && sshL.checkConnection()) {
                        logger.info(Strings.get("SSHAlreadySetup", this.getRemoteUser(), node));
                        continue;
                    }
                    if (previousPassword != null) {
                        status = sshL.checkPasswordAuth();
                    }
                    if (!status) {
                        previousPassword = this.sshpassword = this.getSSHPassword(node);
                    }
                }
                try {
                    sshL.setupKey(node, this.sshpublickeyfile, this.generatekey, this.sshpassword);
                }
                catch (IOException ce) {
                    throw new CommandException(Strings.get("KeySetupFailed", ce.getMessage()));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINER)) break block8;
                    logger.log(Level.FINER, "Keystore error: ", e);
                }
            }
            if (sshL.checkConnection()) continue;
            throw new CommandException(Strings.get("ConnFailed"));
        }
        return 0;
    }

    private boolean promptForKeyGeneration() {
        if (this.generatekey) {
            return true;
        }
        if (!this.programOpts.isInteractive()) {
            return false;
        }
        Console cons = System.console();
        if (cons != null) {
            String val = null;
            do {
                cons.printf("%s", Strings.get("GenerateKeyPairPrompt", this.getRemoteUser(), Arrays.toString(this.hosts)));
                val = cons.readLine();
                if (val == null || !val.equalsIgnoreCase("yes") && !val.equalsIgnoreCase("y")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Generate key!");
                }
                return true;
            } while ((val == null || !val.equalsIgnoreCase("no") && !val.equalsIgnoreCase("n")) && val != null && !this.isValidAnswer(val));
        }
        return false;
    }

    final String getRawRemoteUser() {
        return this.user;
    }

    int getRawRemotePort() {
        return this.port;
    }

    String getSshKeyFile() {
        return this.sshkeyfile;
    }
}

