/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.LineWrapType;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.WrapInfo;
import org.netbeans.modules.editor.lib2.view.WrapLine;

final class WrapInfoUpdater {
    private static final Logger LOG = Logger.getLogger(WrapInfoUpdater.class.getName());
    private static final long serialVersionUID = 0L;
    private final WrapInfo wrapInfo;
    private final ParagraphView pView;
    private final DocumentView docView;
    private List<WrapLine> wrapLines;
    private WrapLine wrapLine;
    private int childIndex;
    private float x;
    private EditorView childViewOrPart;
    private boolean childViewFragmented;
    private float childViewOrPartWidth;
    private double childX;
    private double nextChildX;
    private float childViewPartRelX;
    private float startPartWidth;
    private EditorView endPart;
    private float availableWidth;
    private float maxWrapLineWidth;
    private boolean wrapLineNonEmpty;
    private boolean wrapTypeWords;
    private StringBuilder logMsgBuilder;

    WrapInfoUpdater(WrapInfo wrapInfo, ParagraphView paragraphView) {
        this.wrapInfo = wrapInfo;
        this.pView = paragraphView;
        this.docView = paragraphView.getDocumentView();
        assert (this.docView != null) : "Null documentView";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWrapInfo() {
        this.wrapLines = new ArrayList<WrapLine>(2);
        this.wrapTypeWords = this.docView.op.getLineWrapType() == LineWrapType.WORD_BOUND;
        float visibleWidth = this.docView.op.getVisibleRect().width;
        TextLayout lineContinuationTextLayout = this.docView.op.getLineContinuationCharTextLayout();
        this.availableWidth = Math.max(visibleWidth - lineContinuationTextLayout.getAdvance(), this.docView.op.getDefaultCharWidth() * 4.0f);
        StringBuilder stringBuilder = this.logMsgBuilder = LOG.isLoggable(Level.FINE) ? new StringBuilder(100) : null;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("Building wrapLines: availWidth=").append(this.availableWidth);
            this.logMsgBuilder.append(", lineContCharWidth=").append(lineContinuationTextLayout.getAdvance());
            this.logMsgBuilder.append("\n");
        }
        try {
            this.initChildVars(0, 0.0);
            do {
                if (this.x + this.childViewOrPartWidth <= this.availableWidth) {
                    this.addCurrentAndFetchNextView();
                    continue;
                }
                boolean regularBreak = false;
                if (this.wrapTypeWords) {
                    int startOffset;
                    int currentStartOffset = this.childViewOrPart.getStartOffset();
                    int currentEndOffset = this.childViewOrPart.getEndOffset();
                    if (this.wrapLine != null) {
                        EditorView wrapLineStartView = this.wrapLine.startPart != null ? this.wrapLine.startPart : this.pView.getEditorView(this.wrapLine.firstViewIndex);
                        startOffset = wrapLineStartView.getStartOffset();
                    } else {
                        startOffset = currentStartOffset;
                    }
                    WordInfo wordInfo = this.getWordInfo(startOffset, currentStartOffset);
                    if (wordInfo != null) {
                        EditorView startPart = this.breakView(false);
                        if (startPart != null) {
                            this.childViewFragmented = true;
                            this.childViewOrPart = startPart;
                            this.childViewOrPartWidth = this.startPartWidth;
                            this.addCurrentAndFetchNextView();
                            this.finishWrapLine();
                        } else {
                            int wordEndOffset = wordInfo.wordEndOffset();
                            if (startOffset == wordInfo.wordStartOffset()) {
                                this.addCurrentAndFetchNextView();
                                while (this.childViewOrPart != null && wordEndOffset > currentEndOffset) {
                                    currentEndOffset = this.childViewOrPart.getEndOffset();
                                    this.addCurrentAndFetchNextView();
                                }
                            } else {
                                this.removeViewsToWordStart(wordInfo.wordStartOffset());
                            }
                            this.finishWrapLine();
                        }
                    } else {
                        regularBreak = true;
                    }
                } else {
                    regularBreak = true;
                }
                if (!regularBreak) continue;
                EditorView startPart = this.breakView(false);
                if (startPart != null) {
                    this.childViewFragmented = true;
                    this.childViewOrPart = startPart;
                    this.childViewOrPartWidth = this.startPartWidth;
                    this.addCurrentAndFetchNextView();
                    this.finishWrapLine();
                    continue;
                }
                if (!this.wrapLineNonEmpty) {
                    this.addCurrentAndFetchNextView();
                }
                this.finishWrapLine();
            } while (this.childIndex < this.pView.getViewCount());
            this.finishWrapLine();
        }
        finally {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append('\n');
                LOG.fine(this.logMsgBuilder.toString());
            }
        }
        this.wrapInfo.addAll(this.wrapLines);
        this.wrapInfo.checkIntegrity(this.pView);
        if (this.logMsgBuilder != null) {
            LOG.fine("Resulting wrapInfo:" + this.wrapInfo.toString(this.pView) + "\n");
        }
        this.wrapInfo.setWidth(this.maxWrapLineWidth);
    }

    private WrapLine wrapLine() {
        if (this.wrapLine == null) {
            this.wrapLine = new WrapLine();
        }
        return this.wrapLine;
    }

    private void finishWrapLine() {
        if (this.wrapLine != null) {
            if (this.wrapLineNonEmpty) {
                if (this.x > this.maxWrapLineWidth) {
                    this.maxWrapLineWidth = this.x;
                }
                this.wrapLines.add(this.wrapLine);
            }
            this.wrapLine = null;
            this.wrapLineNonEmpty = false;
            this.x = 0.0f;
        }
    }

    private void initChildVars(int childIndex, double childX) {
        this.childIndex = childIndex;
        this.childX = childX;
        this.assignChild();
    }

    private void fetchNextChild() {
        ++this.childIndex;
        if (this.childIndex < this.pView.getViewCount()) {
            this.childX = this.nextChildX;
            this.assignChild();
        } else {
            this.childViewOrPart = null;
        }
    }

    private void assignChild() {
        this.nextChildX = this.pView.children.startVisualOffset(this.childIndex + 1);
        this.childViewFragmented = false;
        this.childViewOrPart = this.pView.getEditorView(this.childIndex);
        this.childViewOrPartWidth = (float)(this.nextChildX - this.childX);
        this.checkLogChild();
    }

    private void checkLogChild() {
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("child[").append(this.childIndex).append("]:").append(this.childViewOrPart.getDumpId());
            int startOffset = this.childViewOrPart.getStartOffset();
            this.logMsgBuilder.append(" <").append(startOffset).append(",").append(startOffset + this.childViewOrPart.getLength());
            this.logMsgBuilder.append("> W=").append(this.childViewOrPartWidth);
            this.logMsgBuilder.append(":\n");
        }
    }

    private void addCurrentAndFetchNextView() {
        if (!this.childViewFragmented) {
            WrapLine wl = this.wrapLine();
            if (!wl.hasFullViews()) {
                wl.firstViewIndex = this.childIndex;
            }
            wl.endViewIndex = this.childIndex + 1;
            this.wrapLineNonEmpty = true;
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("  added");
                this.logWrapLineAndX(this.x, this.x + this.childViewOrPartWidth);
            }
            this.x += this.childViewOrPartWidth;
            this.fetchNextChild();
        } else {
            if (this.wrapLineNonEmpty) {
                this.addCurrentAsEndPart();
            } else {
                this.addCurrentAsStartPart();
            }
            if (this.endPart != null) {
                this.childViewOrPart = this.endPart;
                this.childViewOrPartWidth = this.endPart.getPreferredSpan(0);
                this.endPart = null;
            } else {
                this.fetchNextChild();
            }
        }
    }

    private void removeChildren(int startIndex) {
        assert (this.wrapLine.hasFullViews()) : "No full views";
        assert (this.wrapLine.endPart == null);
        assert (this.wrapLine.firstViewIndex <= startIndex && startIndex < this.wrapLine.endViewIndex) : "startIndex=" + startIndex + " not in WL " + this.wrapLine;
        double startChildX = this.pView.children.startVisualOffset(startIndex);
        this.x = (float)((double)this.x - (this.childX - startChildX));
        this.wrapLine.endViewIndex = startIndex;
        if (!this.wrapLine.hasFullViews() && this.wrapLine.startPart == null) {
            this.wrapLineNonEmpty = false;
        }
        this.initChildVars(startIndex, startChildX);
    }

    private void addCurrentAsStartPart() {
        assert (!this.wrapLineNonEmpty);
        assert (this.wrapLine().startPart == null);
        assert (!this.wrapLine().hasFullViews());
        assert (this.x == 0.0f);
        this.wrapLine().startPart = this.childViewOrPart;
        this.wrapLine().firstViewX = this.childViewOrPartWidth;
        this.x += this.childViewOrPartWidth;
        this.childViewPartRelX += this.childViewOrPartWidth;
        this.wrapLineNonEmpty = true;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  WrapLine's startViewPart ");
            this.logWrapLineAndX(0.0, this.x);
        }
    }

    private void undoStartPart() {
        assert (this.wrapLine.startPart != null);
        assert (!this.wrapLine.hasFullViews());
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  Removed startViewPart x=" + this.x + " => 0.");
            this.logWrapLineAndX(0.0, this.x);
        }
        this.childViewFragmented = true;
        this.childViewOrPart = this.wrapLine.startPart;
        this.childViewOrPartWidth = this.wrapLine.firstViewX;
        this.childViewPartRelX -= this.wrapLine.firstViewX;
        this.wrapLine.startPart = null;
        this.wrapLine.firstViewX = 0.0f;
        this.x = 0.0f;
        this.wrapLineNonEmpty = false;
    }

    private void addCurrentAsEndPart() {
        assert (this.wrapLine().endPart == null);
        this.wrapLine().endPart = this.childViewOrPart;
        float oldX = this.x;
        this.x += this.childViewOrPartWidth;
        this.childViewPartRelX += this.childViewOrPartWidth;
        this.wrapLineNonEmpty = true;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  WrapLine's endViewPart ");
            this.logWrapLineAndX(oldX, this.x);
        }
    }

    private void removeViewsToWordStart(int wordStartOffset) {
        assert (this.wrapLineNonEmpty) : "Empty wrap line";
        assert (this.wrapLine.endPart == null);
        boolean removeInStartPart = false;
        if (this.wrapLine.hasFullViews()) {
            for (int i = this.wrapLine.endViewIndex - 1; i >= this.wrapLine.firstViewIndex; --i) {
                int viewStartOffset = this.pView.getEditorView(i).getStartOffset();
                boolean bl = removeInStartPart = wordStartOffset < viewStartOffset;
                if (removeInStartPart) continue;
                this.removeChildren(i);
                if (wordStartOffset > viewStartOffset) {
                    EditorView startPart = this.createFragment(wordStartOffset, true);
                    if (startPart != null) {
                        this.childViewFragmented = true;
                        this.childViewOrPart = startPart;
                        this.childViewOrPartWidth = this.startPartWidth;
                        this.addCurrentAndFetchNextView();
                    } else {
                        this.addCurrentAndFetchNextView();
                    }
                }
                break;
            }
        } else {
            removeInStartPart = true;
        }
        if (removeInStartPart) {
            this.undoStartPart();
            EditorView startPart = this.createFragment(wordStartOffset, true);
            if (startPart != null) {
                this.childViewFragmented = true;
                this.childViewOrPart = startPart;
                this.childViewOrPartWidth = this.startPartWidth;
                this.addCurrentAndFetchNextView();
            } else {
                this.addCurrentAndFetchNextView();
            }
        }
    }

    private EditorView breakView(boolean allowWider) {
        EditorView startPart;
        assert (this.endPart == null) : "Non-null endPart";
        EditorView view = this.childViewOrPart;
        int viewStartOffset = view.getStartOffset();
        float breakViewX = (float)(this.childX + (double)this.childViewPartRelX);
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  breakView<").append(viewStartOffset).append(",").append(viewStartOffset + view.getLength()).append("> x=").append(breakViewX).append(" W=").append(this.availableWidth - this.x).append(" => ");
        }
        if ((startPart = (EditorView)view.breakView(0, viewStartOffset, breakViewX, this.availableWidth - this.x)) != null && startPart != view) {
            int viewLength;
            assert (startPart.getStartOffset() == viewStartOffset) : "startPart.getStartOffset()=" + startPart.getStartOffset() + " != viewStartOffset=" + viewStartOffset;
            int startPartLength = startPart.getLength();
            if (startPartLength != (viewLength = view.getLength())) {
                if (this.logMsgBuilder != null) {
                    this.logMsgBuilder.append("startPart<").append(startPart.getStartOffset()).append(",").append(startPart.getEndOffset()).append(">");
                }
                this.startPartWidth = startPart.getPreferredSpan(0);
                if (allowWider || this.startPartWidth <= this.availableWidth - this.x) {
                    this.endPart = (EditorView)view.createFragment(viewStartOffset + startPartLength, viewStartOffset + viewLength);
                    if (this.endPart != null && this.endPart != view && this.endPart.getLength() == viewLength - startPartLength) {
                        if (this.logMsgBuilder != null) {
                            this.logMsgBuilder.append("\n");
                        }
                    } else {
                        if (this.logMsgBuilder != null) {
                            this.logMsgBuilder.append("createFragment <" + (viewStartOffset + startPartLength) + "," + (viewStartOffset + viewLength) + "> not allowed by view\n");
                        }
                        startPart = null;
                        this.endPart = null;
                    }
                } else {
                    if (this.logMsgBuilder != null) {
                        this.logMsgBuilder.append("Fragment too wide(pW=" + this.startPartWidth + ">aW=" + this.availableWidth + "-x=" + this.x + ")\n");
                    }
                    startPart = null;
                }
            } else {
                if (this.logMsgBuilder != null) {
                    this.logMsgBuilder.append("startPart same length as view\n");
                }
                startPart = null;
            }
        } else {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("Break not allowed by view\n");
            }
            startPart = null;
        }
        return startPart;
    }

    private EditorView createFragment(int breakOffset, boolean allowWider) {
        EditorView view = this.childViewOrPart;
        int viewStartOffset = view.getStartOffset();
        int viewEndOffset = viewStartOffset + view.getLength();
        assert (viewStartOffset < breakOffset) : "viewStartOffset=" + viewStartOffset + " >= breakOffset" + breakOffset;
        assert (breakOffset < viewEndOffset) : "breakOffset=" + breakOffset + " >= viewEndOffset" + viewEndOffset;
        assert (this.endPart == null) : "Non-null endPart";
        EditorView startPart = (EditorView)view.createFragment(viewStartOffset, breakOffset);
        assert (startPart != null);
        if (startPart != view) {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append(" breakView<").append(startPart.getStartOffset()).append(",").append(startPart.getEndOffset()).append(">");
            }
            this.startPartWidth = startPart.getPreferredSpan(0);
            if (allowWider || this.startPartWidth <= this.availableWidth - this.x) {
                this.endPart = (EditorView)view.createFragment(breakOffset, viewEndOffset);
                assert (this.endPart != null) : "EndPart == null";
                if (this.endPart == view) {
                    startPart = null;
                    this.endPart = null;
                }
            } else {
                startPart = null;
            }
        } else {
            startPart = null;
        }
        return startPart;
    }

    private WordInfo getWordInfo(int boundaryOffset, int startOffset) {
        boolean nextCharIsWordPart;
        boolean prevCharIsWordPart;
        CharSequence docText = DocumentUtilities.getText((Document)this.docView.getDocument());
        boolean bl = prevCharIsWordPart = boundaryOffset > startOffset && Character.isLetterOrDigit(docText.charAt(boundaryOffset - 1));
        if (prevCharIsWordPart && (nextCharIsWordPart = Character.isLetterOrDigit(docText.charAt(boundaryOffset)))) {
            int wordEndOffset;
            int docTextLength = docText.length();
            for (wordEndOffset = boundaryOffset + 1; wordEndOffset < docTextLength && Character.isLetterOrDigit(docText.charAt(wordEndOffset)); ++wordEndOffset) {
            }
            return new WordInfo(docText, boundaryOffset, startOffset, wordEndOffset);
        }
        return null;
    }

    private void logWrapLineAndX(double oldX, double newX) {
        this.logMsgBuilder.append(" to WL[").append(this.wrapLines.size()).append("] at x=").append(oldX).append(";newX=").append(newX).append('\n');
    }

    private static final class WordInfo {
        private CharSequence docText;
        private int boundaryOffset;
        private int startOffset;
        private int wordEndOffset;
        private int wordStartOffset = -1;

        WordInfo(CharSequence docText, int boundaryOffset, int startOffset, int wordEndOffset) {
            this.docText = docText;
            this.boundaryOffset = boundaryOffset;
            this.startOffset = startOffset;
            this.wordEndOffset = wordEndOffset;
        }

        int wordEndOffset() {
            return this.wordEndOffset;
        }

        int wordStartOffset() {
            if (this.wordStartOffset == -1) {
                this.wordStartOffset = this.boundaryOffset - 2;
                while (this.wordStartOffset >= this.startOffset && Character.isLetterOrDigit(this.docText.charAt(this.wordStartOffset))) {
                    --this.wordStartOffset;
                }
                ++this.wordStartOffset;
            }
            return this.wordStartOffset;
        }
    }
}

