/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.typinghooks;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.typinghooks.TypingHooksSpiAccessor;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;

public final class DeletedTextInterceptorsManager {
    private static final Logger LOG = Logger.getLogger(DeletedTextInterceptorsManager.class.getName());
    private static DeletedTextInterceptorsManager instance;
    private Transaction transaction = null;
    private final Map<MimePath, Reference<Collection<DeletedTextInterceptor>>> cache = new WeakHashMap<MimePath, Reference<Collection<DeletedTextInterceptor>>>();

    public static DeletedTextInterceptorsManager getInstance() {
        if (instance == null) {
            instance = new DeletedTextInterceptorsManager();
        }
        return instance;
    }

    public Transaction openTransaction(JTextComponent c, int offset, String removedText, boolean backwardDelete) {
        DeletedTextInterceptorsManager deletedTextInterceptorsManager = this;
        synchronized (deletedTextInterceptorsManager) {
            if (this.transaction == null) {
                this.transaction = new Transaction(c, offset, removedText, backwardDelete);
                return this.transaction;
            }
            throw new IllegalStateException("Too many transactions; only one at a time is allowed!");
        }
    }

    private DeletedTextInterceptorsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends DeletedTextInterceptor> getInterceptors(Document doc, int offset) {
        List seqs = TokenHierarchy.get((Document)doc).embeddedTokenSequences(offset, true);
        TokenSequence seq = seqs.isEmpty() ? null : (TokenSequence)seqs.get(seqs.size() - 1);
        seq = seq == null ? TokenHierarchy.get((Document)doc).tokenSequence() : seq;
        MimePath mimePath = seq == null ? MimePath.parse((String)DocumentUtilities.getMimeType((Document)doc)) : MimePath.parse((String)seq.languagePath().mimePath());
        Map<MimePath, Reference<Collection<DeletedTextInterceptor>>> map = this.cache;
        synchronized (map) {
            Collection<DeletedTextInterceptor> interceptors;
            Reference<Collection<DeletedTextInterceptor>> ref = this.cache.get(mimePath);
            Collection<DeletedTextInterceptor> collection = interceptors = ref == null ? null : ref.get();
            if (interceptors == null) {
                Collection factories = MimeLookup.getLookup((MimePath)mimePath).lookupAll(DeletedTextInterceptor.Factory.class);
                interceptors = new HashSet<DeletedTextInterceptor>(factories.size());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "DeletedTextInterceptor.Factory instances for {0}:", mimePath.getPath());
                }
                for (DeletedTextInterceptor.Factory f : factories) {
                    DeletedTextInterceptor interceptor = f.createDeletedTextInterceptor(mimePath);
                    if (interceptor != null) {
                        interceptors.add(interceptor);
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "    {0} created: {1}", new Object[]{f, interceptor});
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("");
                }
                this.cache.put(mimePath, new SoftReference<Collection<DeletedTextInterceptor>>(interceptors));
            }
            return interceptors;
        }
    }

    public final class Transaction {
        private final DeletedTextInterceptor.Context context;
        private final Collection<? extends DeletedTextInterceptor> interceptors;
        private int phase = 0;

        public boolean beforeRemove() {
            for (DeletedTextInterceptor deletedTextInterceptor : this.interceptors) {
                try {
                    if (!deletedTextInterceptor.beforeRemove(this.context)) continue;
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "DeletedTextInterceptor crashed in beforeRemove(): " + deletedTextInterceptor, e);
                }
            }
            ++this.phase;
            return false;
        }

        public void textDeleted() {
            Object data = null;
            for (DeletedTextInterceptor deletedTextInterceptor : this.interceptors) {
                try {
                    deletedTextInterceptor.remove(this.context);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "DeletedTextInterceptor crashed in remove(): " + deletedTextInterceptor, e);
                }
            }
            ++this.phase;
        }

        public void afterRemove() {
            for (DeletedTextInterceptor deletedTextInterceptor : this.interceptors) {
                try {
                    deletedTextInterceptor.afterRemove(this.context);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "DeletedTextInterceptor crashed in afterRemove(): " + deletedTextInterceptor, e);
                }
            }
            ++this.phase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.phase < 3) {
                for (DeletedTextInterceptor deletedTextInterceptor : this.interceptors) {
                    try {
                        deletedTextInterceptor.cancelled(this.context);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "DeletedTextInterceptor crashed in cancelled(): " + deletedTextInterceptor, e);
                    }
                }
            }
            DeletedTextInterceptorsManager deletedTextInterceptorsManager = DeletedTextInterceptorsManager.this;
            synchronized (deletedTextInterceptorsManager) {
                DeletedTextInterceptorsManager.this.transaction = null;
            }
        }

        private Transaction(JTextComponent c, int offset, String removedText, boolean backwardDelete) {
            this.context = TypingHooksSpiAccessor.get().createDtiContext(c, offset, removedText, backwardDelete);
            this.interceptors = DeletedTextInterceptorsManager.this.getInterceptors(c.getDocument(), offset);
        }
    }
}

