/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.validator.ExpressionValidatorVariableResolver;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ExpressionValidator
implements Validator,
StateHolder {
    public static String ALPHABET_ONLY_MESSAGE;
    public static String DIGIT_ONLY_MESSAGE;
    public static String ALPHABET_NUMBER_ONLY_MESSAGE;
    public static String REGEX_IS_INVALID_MESSAGE;
    public static String NULL_MESSAGE;
    private String expression;
    private ResourceBundle rb;
    private boolean transientFlag = false;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String string) {
        this.setExpression(string);
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (object == null) {
            return;
        }
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        this.rb = ResourceHandler.getBundle(facesContext);
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        boolean bl = true;
        FacesMessage facesMessage = null;
        VariableResolver variableResolver = facesContext.getApplication().getVariableResolver();
        ExpressionValidatorVariableResolver expressionValidatorVariableResolver = new ExpressionValidatorVariableResolver(variableResolver, object);
        facesContext.getApplication().setVariableResolver((VariableResolver)expressionValidatorVariableResolver);
        Object object2 = null;
        try {
            object2 = facesContext.getApplication().createValueBinding(this.expression).getValue(facesContext);
        }
        catch (EvaluationException evaluationException) {
            facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.InvalidExpression"));
            bl = false;
        }
        if (!(object2 instanceof Boolean)) {
            facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.NotBoolean"));
            bl = false;
        } else {
            Boolean bl2 = (Boolean)object2;
            if (bl2 != Boolean.TRUE) {
                facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.FalseExpression"));
                bl = false;
            }
        }
        facesContext.getApplication().setVariableResolver(variableResolver);
        if (!bl) {
            facesContext.addMessage(uIComponent.getClientId(facesContext), facesMessage);
            ((UIInput)uIComponent).setValid(false);
        }
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.expression};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.expression = (String)objectArray[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }
}

