/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheHashMap
extends HashMap {
    private LinkedValueNode mruNode = null;
    private int maxSize = 16;

    public CacheHashMap() {
    }

    public CacheHashMap(int n) {
        this.maxSize = n;
    }

    public CacheHashMap(int n, int n2) {
        super(n2);
        this.maxSize = n;
    }

    public CacheHashMap(int n, int n2, float f) {
        super(n2, f);
        this.maxSize = n;
    }

    public Object get(Object object) {
        LinkedValueNode linkedValueNode = (LinkedValueNode)super.get(object);
        if (null != linkedValueNode) {
            this.removeNode(linkedValueNode);
            this.addNode(linkedValueNode);
            return linkedValueNode.value;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        LinkedValueNode linkedValueNode;
        this.remove(object);
        if (this.size() == this.maxSize) {
            this.remove(this.mruNode.previous.key);
        }
        return null != (linkedValueNode = super.put(object, this.addNode(new LinkedValueNode(object, object2)))) ? linkedValueNode.value : null;
    }

    public void putAll(Map map) {
        if (null == map) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        LinkedValueNode linkedValueNode = (LinkedValueNode)super.get(object);
        if (null != linkedValueNode) {
            this.removeNode(linkedValueNode);
            if (this.mruNode == linkedValueNode) {
                this.mruNode = linkedValueNode.next;
            }
            return linkedValueNode.value;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    public Collection values() {
        return new CacheCollection(this);
    }

    public void clear() {
        this.mruNode = null;
        super.clear();
    }

    private LinkedValueNode removeNode(LinkedValueNode linkedValueNode) {
        LinkedValueNode linkedValueNode2 = linkedValueNode.next;
        if (null != linkedValueNode2) {
            linkedValueNode2.previous = linkedValueNode.previous;
        }
        if (null != (linkedValueNode2 = linkedValueNode.previous)) {
            linkedValueNode2.next = linkedValueNode.next;
        }
        return linkedValueNode;
    }

    private LinkedValueNode addNode(LinkedValueNode linkedValueNode) {
        linkedValueNode.next = this.mruNode;
        if (null != this.mruNode) {
            linkedValueNode.previous = this.mruNode.previous;
            this.mruNode.previous = linkedValueNode;
        } else {
            linkedValueNode.previous = null;
        }
        this.mruNode = linkedValueNode;
        return this.mruNode;
    }

    public static void main(String[] stringArray) {
    }

    class CacheCollection
    implements Collection {
        private CacheHashMap cache;

        public CacheCollection(CacheHashMap cacheHashMap2) {
            this.cache = cacheHashMap2;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException("add is unsupported");
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException("addAll is unsupported");
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean contains(Object object) {
            return this.cache.containsValue(object);
        }

        public boolean containsAll(Collection collection) {
            if (null == collection) {
                return true;
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.cache.containsValue(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public boolean remove(Object object) {
            if (null == this.cache.mruNode) {
                return false;
            }
            LinkedValueNode linkedValueNode = CacheHashMap.this.mruNode;
            do {
                if (linkedValueNode.equals(object)) {
                    this.cache.remove(linkedValueNode.key);
                    return true;
                }
                linkedValueNode = linkedValueNode.next;
            } while (linkedValueNode.next != CacheHashMap.this.mruNode && null != linkedValueNode);
            return false;
        }

        public boolean removeAll(Collection collection) {
            if (null == collection) {
                return false;
            }
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return false;
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException("retainAll is not supported");
        }

        public int size() {
            return this.cache.size();
        }

        public Object[] toArray() {
            Object[] objectArray = new Object[this.cache.size()];
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            return objectArray;
        }

        public Object[] toArray(Object[] objectArray) {
            int n = 0;
            Class<?> clazz = objectArray.getClass();
            if (objectArray.length < this.cache.size()) {
                objectArray = (Object[])Array.newInstance(clazz, this.cache.size());
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (null != e && !objectArray.getClass().equals(e.getClass())) continue;
                objectArray[n++] = iterator.next();
            }
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        public Iterator iterator() {
            return new CacheIterator(this.cache);
        }
    }

    class CacheIterator
    implements Iterator {
        private CacheHashMap cache;
        private LinkedValueNode nextNode;
        private boolean hasNext;

        public CacheIterator(CacheHashMap cacheHashMap2) {
            this.cache = cacheHashMap2;
            this.nextNode = (LinkedValueNode)cacheHashMap2.mruNode.clone();
            this.hasNext = this.nextNode != null;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            Object object = this.nextNode.value;
            this.nextNode = this.nextNode.next;
            this.hasNext = this.nextNode != null && this.nextNode != CacheHashMap.this.mruNode;
            return object;
        }

        public void remove() {
            if (null != this.nextNode.previous) {
                this.cache.remove(this.nextNode.previous.key);
            }
            throw new UnsupportedOperationException("remove is unsupported");
        }
    }

    private class LinkedValueNode {
        LinkedValueNode next;
        LinkedValueNode previous;
        Object key;
        Object value;

        LinkedValueNode(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public boolean equals(Object object) {
            return object == null ? this.value == null : this.value.equals(object);
        }

        public Object clone() {
            LinkedValueNode linkedValueNode = new LinkedValueNode(this.key, this.value);
            linkedValueNode.next = this.next;
            linkedValueNode.previous = this.previous;
            return linkedValueNode;
        }
    }
}

