/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.taglib.html_extended;

import com.ibm.faces.validator.DateTimeRangeValidator;
import com.sun.faces.taglib.jsf_core.MaxMinValidatorTag;
import com.sun.faces.util.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.convert.ConverterException;
import javax.faces.validator.Validator;
import javax.servlet.jsp.JspException;

public class ValidateDateTimeRangeTag
extends MaxMinValidatorTag {
    protected String maximum = null;
    protected String minimum = null;
    protected Date maxDate = null;
    protected Date minDate = null;
    private static final String DATE_ATTR_TODAY = "today";
    private static final String DATE_ATTR_TOMORROW = "tomorrow";
    private static final String DATE_ATTR_YESTERDAY = "yesterday";
    private static final String TIME_ATTR_NOW = "now";

    public ValidateDateTimeRangeTag() {
        super.setId("DateTimeRange");
        super.setValidatorId("DateTimeRange");
    }

    public String getMaximum() {
        return this.maximum;
    }

    public void setMaximum(String string) {
        this.maximumSet = true;
        this.maximum = string;
    }

    public String getMinimum() {
        return this.minimum;
    }

    public void setMinimum(String string) {
        this.minimumSet = true;
        this.minimum = string;
    }

    protected Validator createValidator() throws JspException {
        DateTimeRangeValidator dateTimeRangeValidator = null;
        dateTimeRangeValidator = (DateTimeRangeValidator)super.createValidator();
        Util.doAssert((null != dateTimeRangeValidator ? 1 : 0) != 0);
        this.evaluateExpressions();
        if (this.maximumSet) {
            dateTimeRangeValidator.setMaximum(this.maxDate);
        }
        if (this.minimumSet) {
            dateTimeRangeValidator.setMinimum(this.minDate);
        }
        return dateTimeRangeValidator;
    }

    private void evaluateExpressions() {
        Comparable<Date> comparable;
        Object object;
        if (this.minimumSet) {
            if (Util.isVBExpression((String)this.minimum)) {
                this.minimum = this.changeKeywordsToLong(this.minimum);
                object = Util.evaluateVBExpression((String)this.minimum);
                Util.doAssert((null != object ? 1 : 0) != 0);
                if (object instanceof Date) {
                    comparable = (Date)object;
                    this.minimum = new Long(((Date)comparable).getTime()).toString();
                    this.minDate = comparable;
                } else {
                    comparable = (Long)object;
                    this.minimum = new Long((Long)comparable).toString();
                    this.minDate = new Date((Long)comparable);
                }
            } else {
                this.minimum = this.changeDateToLong(this.minimum);
                this.minDate = new Date(Long.parseLong(this.minimum));
            }
        }
        if (this.maximumSet) {
            if (Util.isVBExpression((String)this.maximum)) {
                this.maximum = this.changeKeywordsToLong(this.maximum);
                object = Util.evaluateVBExpression((String)this.maximum);
                Util.doAssert((null != object ? 1 : 0) != 0);
                if (object instanceof Date) {
                    comparable = (Date)object;
                    this.maximum = new Long(((Date)comparable).getTime()).toString();
                    this.maxDate = comparable;
                } else {
                    comparable = (Long)object;
                    this.maximum = new Long((Long)comparable).toString();
                    this.maxDate = new Date((Long)comparable);
                }
            } else {
                this.maximum = this.changeDateToLong(this.maximum);
                this.maxDate = new Date(Long.parseLong(this.maximum));
            }
        }
    }

    private String changeDateToLong(String string) {
        String string2 = "yyyy/MM/dd HH:mm:ss";
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            string2 = "yyyy/MM/dd";
            try {
                simpleDateFormat.applyPattern(string2);
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException2) {
                string2 = "HH:mm:ss";
                try {
                    simpleDateFormat.applyPattern(string2);
                    date = simpleDateFormat.parse(string);
                }
                catch (ParseException parseException3) {
                    throw new ConverterException(parseException.getMessage() + "\n" + parseException2.getMessage() + "\n" + parseException3.getMessage());
                }
            }
        }
        return new Long(date.getTime()).toString();
    }

    private String changeKeywordsToLong(String string) {
        String string2 = string;
        while (true) {
            String string3 = null;
            Date date = null;
            if (string2.indexOf(TIME_ATTR_NOW) != -1) {
                string3 = TIME_ATTR_NOW;
                date = new Date();
            } else if (string2.indexOf(DATE_ATTR_TODAY) != -1) {
                string3 = DATE_ATTR_TODAY;
                date = new Date();
            } else if (string2.indexOf(DATE_ATTR_TOMORROW) != -1) {
                string3 = DATE_ATTR_TOMORROW;
                date = new Date(System.currentTimeMillis() + 86400000L);
            } else if (string2.indexOf(DATE_ATTR_YESTERDAY) != -1) {
                string3 = DATE_ATTR_YESTERDAY;
                date = new Date(System.currentTimeMillis() - 86400000L);
            } else {
                return string2;
            }
            int n = 0;
            int n2 = 0;
            n = string2.indexOf(string3);
            n2 = n + string3.length();
            String string4 = string2.substring(0, n);
            string4 = string4 + " " + new Long(date.getTime()).toString();
            string2 = string4 = string4 + " " + string2.substring(n2, string2.length());
        }
    }
}

