/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.renderkit.html_extended.RenderKitImpl;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.faces.render.Renderer;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;

public class RenderKitUtil {
    private RenderKitImpl m_renderKit;
    private ClassLoader m_loader;
    private List m_attributeList = new ArrayList();

    public static void addToRenderKit(RenderKitImpl renderKitImpl, String string, ClassLoader classLoader) {
        try {
            URL uRL = classLoader.getResource(string);
            System.out.println(uRL.toExternalForm());
            InputSource inputSource = new InputSource(uRL.toExternalForm());
            inputSource.setByteStream(classLoader.getResourceAsStream(string));
            Digester digester = RenderKitUtil.initConfig();
            digester.push((Object)new RenderKitUtil(renderKitImpl, classLoader));
            digester.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Digester initConfig() {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.addCallMethod("*/component", "addComponent", 1);
        digester.addCallParam("*/component/type", 0);
        digester.addCallMethod("*/renderer", "addRenderer", 2);
        digester.addCallParam("*/renderer/type", 0);
        digester.addCallParam("*/renderer/class", 1);
        digester.addCallMethod("*/renderer/attribute", "addRendererAttributes", 4);
        digester.addCallParam("*/renderer/attribute/name", 0);
        digester.addCallParam("*/renderer/attribute/display-name", 1);
        digester.addCallParam("*/renderer/attribute/description", 2);
        digester.addCallParam("*/renderer/attribute/type", 3);
        return digester;
    }

    private RenderKitUtil(RenderKitImpl renderKitImpl, ClassLoader classLoader) {
        this.m_renderKit = renderKitImpl;
        this.m_loader = classLoader;
    }

    public void addComponent(String string) {
        try {
            Class<?> clazz = this.m_loader.loadClass(string);
            this.m_renderKit.addComponentClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void addRenderer(String string, String string2, String string3) {
        try {
            Class<?> clazz = this.m_loader.loadClass(string3);
            HtmlBasicRenderer htmlBasicRenderer = (HtmlBasicRenderer)clazz.newInstance();
            this.m_renderKit.addRenderer(string, string2, (Renderer)htmlBasicRenderer);
            this.m_attributeList.clear();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    public void addRendererAttributes(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string, string2, string3, string4};
        this.m_attributeList.add(stringArray);
    }
}

