/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.fileupload.util;

import com.ibm.faces.fileupload.util.ContentLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLineReader {
    protected InputStream reader;
    private boolean eof;
    private static final char lf = '\n';
    private boolean debug;
    private String encoding;
    private ByteArrayOutputStream dump;

    public ContentLineReader(InputStream inputStream, String string) {
        this.reader = inputStream;
        this.eof = false;
        this.encoding = string;
        this.debug = false;
    }

    public ContentLineReader(InputStream inputStream, String string, boolean bl) {
        this.reader = inputStream;
        this.debug = bl;
        this.encoding = string;
        this.eof = false;
        if (this.debug) {
            this.dump = new ByteArrayOutputStream();
        }
    }

    public ContentLine readLine() throws IOException {
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.eof) {
            return null;
        }
        while (!bl && !this.eof) {
            int n = this.reader.read();
            if (n == -1) {
                this.eof = true;
                continue;
            }
            if (this.debug) {
                this.dump.write(n);
            }
            byteArrayOutputStream.write(n);
            if (n != 10) continue;
            bl = true;
        }
        return new ContentLine(byteArrayOutputStream.toByteArray(), this.encoding);
    }

    public byte[] getDump() {
        if (!this.debug) {
            return null;
        }
        return this.dump.toByteArray();
    }
}

