/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.fileupload.util;

import com.ibm.faces.fileupload.util.ContentLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class ContentElement {
    private static String TAG_CONTENT_TYPE = "Content-Type";
    private static String TAG_CONTENT_DISP = "Content-Disposition";
    private static String TAG_NAME = "name";
    private static String TAG_FILENAME = "filename";
    private String name;
    private String fileName;
    private String mimeType;
    boolean headerSection = true;
    private String encoding;
    private ByteArrayOutputStream contentValue = new ByteArrayOutputStream();
    private byte[] content = null;

    public ContentElement(String string) {
        this.encoding = string;
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public String getName() {
        return this.name;
    }

    public void setFileName(String string) {
        this.fileName = new String(string);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMimeType(String string) {
        this.mimeType = new String(string);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getContentValue() {
        if (this.content == null) {
            int n = this.getContentSize();
            this.content = new byte[n];
            System.arraycopy(this.contentValue.toByteArray(), 0, this.content, 0, n);
            this.contentValue = null;
        }
        return this.content;
    }

    public String getContentValueAsString() {
        String string = null;
        try {
            string = new String(this.getContentValue(), 0, this.getContentSize(), this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public int getContentSize() {
        int n = 0;
        if (this.content == null) {
            this.content = this.contentValue.toByteArray();
        }
        if (this.content != null) {
            n = this.content.length >= 2 && this.content[this.content.length - 2] == 13 && this.content[this.content.length - 1] == 10 ? this.content.length - 2 : this.content.length;
        }
        return n;
    }

    public void addToContent(ContentLine contentLine) {
        block13: {
            block11: {
                String string;
                int n;
                block15: {
                    String string2;
                    block14: {
                        block12: {
                            if (!this.headerSection) break block11;
                            String string3 = contentLine.getString();
                            n = string3.indexOf(58);
                            if (n < 0) {
                                string = string3;
                                string2 = "";
                            } else {
                                string = string3.substring(0, n);
                                string2 = string3.substring(n + 1, string3.length());
                            }
                            if (!string.equals("") || string2 != "") break block12;
                            this.headerSection = false;
                            break block13;
                        }
                        if (!string.equalsIgnoreCase(TAG_CONTENT_TYPE)) break block14;
                        this.mimeType = string2.trim();
                        break block13;
                    }
                    if (!string.equalsIgnoreCase(TAG_CONTENT_DISP)) break block15;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4;
                        String string5 = stringTokenizer.nextToken().trim();
                        n = string5.indexOf(61);
                        if (n < 0) {
                            string = string5;
                            string4 = "";
                        } else {
                            string = string5.substring(0, n);
                            string4 = string5.substring(n + 1, string5.length());
                        }
                        if (string.equalsIgnoreCase(TAG_NAME)) {
                            this.name = new String(string4.trim());
                        }
                        if (!string.equalsIgnoreCase(TAG_FILENAME)) continue;
                        this.fileName = new String(string4.trim());
                    }
                    break block13;
                }
                if (!string.startsWith(" ") && !string.startsWith("\t")) break block13;
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6;
                    String string7 = stringTokenizer.nextToken().trim();
                    n = string7.indexOf(61);
                    if (n < 0) {
                        string = string7;
                        string6 = "";
                    } else {
                        string = string7.substring(0, n);
                        string6 = string7.substring(n + 1, string7.length());
                    }
                    if (!string.equalsIgnoreCase(TAG_FILENAME)) continue;
                    this.fileName = new String(string6.trim());
                }
                break block13;
            }
            try {
                this.contentValue.write(contentLine.getBytes());
            }
            catch (IOException iOException) {
                System.err.println("Exception!");
            }
        }
    }

    public String toString() {
        return TAG_CONTENT_TYPE + "=" + this.mimeType + "; " + TAG_NAME + "=" + this.name;
    }
}

