/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.converter;

import com.ibm.faces.ResourceHandler;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class MaskConverter
implements Converter,
StateHolder {
    private String mask;
    private boolean asis;
    private String sourceObjType;
    public static final String CONVERTER_ID = "com.ibm.faces.Mask";
    private boolean transientFlag = false;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        ResourceBundle resourceBundle = ResourceHandler.getBundle(facesContext);
        if (facesContext == null) throw new NullPointerException(ResourceHandler.getString(resourceBundle, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        if (uIComponent == null) {
            throw new NullPointerException(ResourceHandler.getString(resourceBundle, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (string == null) return null;
        if (string.length() < 1) {
            return null;
        }
        try {
            if (this.asis) {
                this.removeNonDataCharacter(string, this.mask, resourceBundle);
                return string;
            }
            String string2 = this.removeNonDataCharacter(string, this.mask, resourceBundle);
            if (this.sourceObjType != null) return this.convertToOrignType(this.sourceObjType, string2, resourceBundle);
            ValueBinding valueBinding = uIComponent.getValueBinding("value");
            if (valueBinding == null) return this.removeNonDataCharacter(string, this.mask, resourceBundle);
            String string3 = valueBinding.getType(facesContext).getName();
            if (string3 == null) {
                MessageFormat messageFormat = new MessageFormat(ResourceHandler.getString(resourceBundle, "MaskConverter.Failed_to_convert___{0}___to_the_object_due_to_unknown_data_type._1"));
                Object[] objectArray = new Object[]{string};
                throw new ConverterException(messageFormat.format(objectArray));
            }
            this.sourceObjType = string3;
            return this.convertToOrignType(this.sourceObjType, string2, resourceBundle);
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        ResourceBundle resourceBundle = ResourceHandler.getBundle(facesContext);
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(ResourceHandler.getString(resourceBundle, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (object == null) {
            return "";
        }
        try {
            String string;
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Number) {
                string = object.toString();
                int n = this.getNumberOfDigitsInMask();
                if (string.length() < n) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n - string.length(); ++i) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                    string = stringBuffer.toString();
                }
            } else {
                string = object.toString();
            }
            this.sourceObjType = object.getClass().getName();
            return this.getMaskedString(this.mask, string, resourceBundle, facesContext, uIComponent);
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String removeNonDataCharacter(String string, String string2, ResourceBundle resourceBundle) {
        boolean bl = true;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray.length != cArray2.length) {
            bl = false;
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                String string3 = String.valueOf(cArray2[i]);
                if (string3.equals("?") || string3.equals("#")) {
                    boolean bl2 = this.isValidType(string3, cArray[i]);
                    if (!bl2) {
                        bl = false;
                        break;
                    }
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                if (cArray2[i] == cArray[i]) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return stringBuffer.toString();
        }
        throw new ConverterException(ResourceHandler.getString(resourceBundle, "MaskConverter.Data_String_and_mask_pattern_are_mismatched._1"));
    }

    private Object convertToOrignType(String string, String string2, ResourceBundle resourceBundle) {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MaskConverter.class$("java.lang.String")) : class$java$lang$String};
        Object[] objectArray = new String[]{string2};
        try {
            Constructor<?> constructor = Class.forName(string).getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            return obj;
        }
        catch (Exception exception) {
            throw new ConverterException(ResourceHandler.getString(resourceBundle, "MaskConverter.Error__Fail_to_covert_original_Object_type._2"));
        }
    }

    private String getMaskedString(String string, String string2, ResourceBundle resourceBundle, FacesContext facesContext, UIComponent uIComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = 0;
        int n2 = cArray2.length;
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            String string3 = String.valueOf(cArray[i]);
            if (string3.equals("?") || string3.equals("#")) {
                if (n2 > n) {
                    if (Character.isLetterOrDigit(cArray2[n])) {
                        boolean bl = this.isValidType(string3, cArray2[n]);
                        if (bl) {
                            stringBuffer.append(cArray2[n]);
                            ++n;
                            continue;
                        }
                        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(resourceBundle, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"), ResourceHandler.getString(resourceBundle, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"));
                        facesContext.addMessage(uIComponent.getClientId(facesContext), facesMessage);
                        return string2;
                    }
                    if (Character.isSpaceChar(cArray2[n])) {
                        return string2;
                    }
                    FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(resourceBundle, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._4"), ResourceHandler.getString(resourceBundle, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._4"));
                    facesContext.addMessage(uIComponent.getClientId(facesContext), facesMessage);
                    return string2;
                }
                return string2;
            }
            if (n2 > n) {
                if (Character.isSpaceChar(cArray2[n])) {
                    stringBuffer.append(cArray[i]);
                    ++n;
                    continue;
                }
                if (Character.isLetterOrDigit(cArray2[n])) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                stringBuffer.append(cArray[i]);
                ++n;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private boolean isValidType(String string, char c) {
        if (string.equals("?")) {
            return Character.isLetter(c);
        }
        if (string.equals("#")) {
            return Character.isDigit(c);
        }
        return false;
    }

    private int getNumberOfDigitsInMask() {
        int n = 0;
        char[] cArray = this.mask.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = String.valueOf(cArray[i]);
            if (!string.equals("#")) continue;
            ++n;
        }
        return n;
    }

    public boolean isAsis() {
        return this.asis;
    }

    public String getMask() {
        return this.mask;
    }

    public void setAsis(boolean bl) {
        this.asis = bl;
    }

    public void setMask(String string) {
        this.mask = string;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.mask = (String)objectArray[0];
        this.asis = (Boolean)objectArray[2];
        this.sourceObjType = (String)objectArray[3];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.mask;
        objectArray[2] = new Boolean(this.asis);
        objectArray[3] = this.sourceObjType;
        return objectArray;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

