/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;

public class ResourceHandler {
    public static final String PROPERTIES_FILE = "runtimeibm";

    public static ResourceBundle getBundle(FacesContext facesContext) {
        if (facesContext == null) {
            facesContext = FacesContext.getCurrentInstance();
        }
        if (facesContext != null) {
            return ResourceBundle.getBundle(PROPERTIES_FILE, facesContext.getViewRoot().getLocale());
        }
        return ResourceBundle.getBundle(PROPERTIES_FILE);
    }

    public static String getServerString(String string) {
        try {
            return ResourceBundle.getBundle(PROPERTIES_FILE).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            resourceBundle = ResourceHandler.getBundle(null);
        }
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return "!" + string + "!";
            }
        }
        return "!" + string + "!";
    }

    public static String getString(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        try {
            return MessageFormat.format(ResourceHandler.getString(resourceBundle, string), objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ResourceHandler.getString(resourceBundle, string);
        }
    }

    public static String buildLocalizedLibName(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            resourceBundle = ResourceHandler.getBundle(null);
        }
        if (resourceBundle == null) {
            return string;
        }
        String string2 = resourceBundle.getString("Locale.suffix");
        if (string2 == null || string2.trim().length() == 0 || string2.equals("!Locale.suffix!")) {
            return string;
        }
        int n = string.lastIndexOf(".js");
        return string.substring(0, n) + "_" + string2 + ".js";
    }
}

