/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.modules.xml.DTDDataObject;
import org.netbeans.modules.xml.EntityDataObject;
import org.netbeans.modules.xml.XMLDataObject;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.cookies.DataObjectCookieManager;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.DTDTextRepresentation;
import org.netbeans.modules.xml.text.EntityTextRepresentation;
import org.netbeans.modules.xml.text.TextEditorComponent;
import org.netbeans.modules.xml.text.XMLTextRepresentation;
import org.netbeans.modules.xml.util.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class TextEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
OpenCookie,
EditCookie,
CloseCookie,
PrintCookie {
    public static final String PROP_DOCUMENT_URL = "doc-url";
    private Timer timer;
    private static Container awtLock;
    private Representation rep;
    private String mimeType;

    protected TextEditorSupport(XMLDataObjectLook xmlDO, Env env, String mime_type) {
        super((DataObject)xmlDO, null, (CloneableEditorSupport.Env)env);
        this.mimeType = mime_type;
        this.initTimer();
        this.initListeners();
    }

    public void setMIMEType(String s) {
        super.setMIMEType(s);
        this.mimeType = s;
    }

    public TextEditorSupport(XMLDataObjectLook xmlDO, String mime_type) {
        this(xmlDO, new Env(xmlDO), mime_type);
    }

    private final void syncMimeType() {
        super.setMIMEType(this.mimeType);
    }

    private void initTimer() {
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("$$ TextEditorSupport::initTimer::actionPerformed: event = " + e);
                }
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TextEditorSupport.this.syncDocument(false);
                    }
                });
            }
        });
        this.timer.setInitialDelay(this.getAutoParsingDelay());
        this.timer.setRepeats(false);
    }

    protected CloneableEditorSupport.Pane createPane() {
        this.syncMimeType();
        if (this.getDataObject().getClass() == XMLDataObject.class && !this.mimeType.equals("text/plain+xml") && !this.hasMultiTextEditor()) {
            return this.createCloneableEditor();
        }
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)this.mimeType, (Serializable)this.getDataObject());
    }

    boolean hasMultiTextEditor() {
        Collection all = MimeLookup.getLookup((String)this.mimeType).lookupAll(MultiViewDescription.class);
        for (MultiViewDescription d : all) {
            if (!d.preferredID().startsWith("xml.text")) continue;
            return true;
        }
        return false;
    }

    private void initListeners() {
        final DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::insertUpdate: event = " + e);
                }
                this.restartTime();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::changedUpdate: event = " + e);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::removeUpdate: event = " + e);
                }
                this.restartTime();
            }

            private void restartTime() {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::restartTime: isInSync = " + TextEditorSupport.this.getXMLDataObjectLook().getSyncInterface().isInSync());
                }
                if (TextEditorSupport.this.getXMLDataObjectLook().getSyncInterface().isInSync()) {
                    return;
                }
                TextEditorSupport.this.restartTimer(false);
            }
        };
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (TextEditorSupport.this.isDocumentLoaded()) {
                    StyledDocument doc = TextEditorSupport.this.getDocument();
                    if (doc == null) {
                        return;
                    }
                    doc.addDocumentListener(WeakListeners.document((DocumentListener)docListener, (Object)doc));
                    if (TextEditorSupport.this.rep == null) {
                        XMLDataObjectLook dobj = (XMLDataObjectLook)TextEditorSupport.this.getDataObject();
                        Synchronizator sync = dobj.getSyncInterface();
                        if (dobj instanceof XMLDataObject) {
                            TextEditorSupport.this.rep = new XMLTextRepresentation(TextEditorSupport.this, sync);
                        } else if (dobj instanceof DTDDataObject) {
                            TextEditorSupport.this.rep = new DTDTextRepresentation(TextEditorSupport.this, sync);
                        } else if (dobj instanceof EntityDataObject) {
                            TextEditorSupport.this.rep = new EntityTextRepresentation(TextEditorSupport.this, sync);
                        }
                        if (TextEditorSupport.this.rep != null) {
                            sync.addRepresentation(TextEditorSupport.this.rep);
                        }
                    }
                }
            }
        });
    }

    protected void notifyClosed() {
        super.notifyClosed();
        if (((Object)((Object)this)).getClass() != TextEditorSupport.class) {
            return;
        }
        XMLDataObjectLook dobj = (XMLDataObjectLook)this.getDataObject();
        Synchronizator sync = dobj.getSyncInterface();
        Representation oldRep = this.rep;
        this.rep = null;
        if (oldRep != null) {
            sync.removeRepresentation(oldRep);
        }
    }

    Env getEnv() {
        return (Env)this.env;
    }

    protected XMLDataObjectLook getXMLDataObjectLook() {
        return this.getEnv().getXMLDataObjectLook();
    }

    protected boolean notifyModified() {
        if (this.getEnv().isModified()) {
            return true;
        }
        if (!super.notifyModified()) {
            return false;
        }
        DataObjectCookieManager manager = this.getEnv().getXMLDataObjectLook().getCookieManager();
        manager.addCookie((Node.Cookie)this.getEnv());
        XMLDataObjectLook obj = (XMLDataObjectLook)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieManager().addCookie((Node.Cookie)new SaveCookie(){

                public void save() throws IOException {
                    try {
                        TextEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void notifyUnmodified() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Notifing unmodified");
        }
        super.notifyUnmodified();
        DataObjectCookieManager manager = this.getEnv().getXMLDataObjectLook().getCookieManager();
        manager.removeCookie((Node.Cookie)this.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream out) throws IOException, BadLocationException {
        String enc = EncodingUtil.detectEncoding((Document)doc);
        Charset cs = enc != null ? Charset.forName(enc) : FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Saving using encoding");
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("!!! TextEditorSupport::saveFromKitToStream: enc = " + enc);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("!!!                  ::saveFromKitToStream: after first test -> OK");
        }
        FilterOutputStream fos = new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };
        CharsetEncoder encoder = cs.newEncoder();
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, encoder);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("!!!                  ::saveFromKitToStream: writer = " + w);
        }
        try {
            kit.write(w, (Document)doc, 0, doc.getLength());
        }
        finally {
            ((Writer)w).close();
        }
    }

    public void saveDocument() throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("saveDocument()...");
        }
        StyledDocument doc = this.getDocument();
        String enc = EncodingUtil.detectEncoding((Document)doc);
        try {
            Charset cs = enc == null ? FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()) : Charset.forName(enc);
            if (!cs.newEncoder().canEncode(doc.getText(0, doc.getLength()))) {
                this.handleUnsupportedEncoding(doc, enc);
            }
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify(1, (Throwable)ble);
        }
        catch (UnsupportedCharsetException ex) {
            this.handleUnsupportedEncoding(doc, enc);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("!!! TextEditorSupport::saveDocument: enc = " + enc);
        }
        try {
            super.saveDocument();
            this.getDataObject().setModified(false);
            this.getXMLDataObjectLook().getSyncInterface().representationChanged(Document.class);
        }
        catch (UnmappableCharacterException ex) {
            this.handleUnsupportedEncoding(doc, enc);
        }
        catch (UnsupportedEncodingException ex) {
            this.handleUnsupportedEncoding(doc, enc);
        }
    }

    private void handleUnsupportedEncoding(StyledDocument doc, String enc) throws IOException {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(Util.THIS.getString(TextEditorSupport.class, enc == null ? "TEXT_SAVE_AS_UTF_DEFAULT" : "TEXT_SAVE_AS_UTF"), enc));
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (!res.equals(NotifyDescriptor.YES_OPTION)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Let unsaved.");
            }
            throw new UserCancelException("Content could not be saved using the current encoding");
        }
        this.updateDocumentWithNewEncoding(doc);
    }

    private void updateDocumentWithNewEncoding(final StyledDocument doc) throws IOException {
        try {
            int MAX_PROLOG = 1000;
            int maxPrologLen = Math.min(1000, doc.getLength());
            final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
            int prologLen = -1;
            if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                for (int i = 3; i < maxPrologLen; ++i) {
                    if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                    prologLen = i + 1;
                    break;
                }
            }
            final int passPrologLen = prologLen;
            Runnable edit = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (passPrologLen > 0) {
                                doc.remove(0, passPrologLen + 1);
                                doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                            } else {
                                doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: no XML declaration present -->\n", null);
                            }
                        }
                        catch (BadLocationException e) {
                            if (System.getProperty("netbeans.debug.exceptions") == null) break block4;
                            e.printStackTrace();
                        }
                    }
                }
            };
            NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
            super.saveDocument();
            this.getDataObject().setModified(false);
            this.getXMLDataObjectLook().getSyncInterface().representationChanged(Document.class);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Saved.");
            }
        }
        catch (BadLocationException lex) {
            ErrorManager.getDefault().notify((Throwable)lex);
        }
    }

    protected void syncDocument(boolean fromFocus) {
        XMLDataObjectLook sync;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@ TextEditorSupport::syncDocument: fromFocus = " + fromFocus);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@                  ::syncDocument: timer.isRunning = " + this.timer.isRunning());
        }
        if (fromFocus && !this.timer.isRunning()) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if ((sync = this.getXMLDataObjectLook()) != null) {
            sync.getSyncInterface().representationChanged(Document.class);
        }
    }

    int getAutoParsingDelay() {
        return 3000;
    }

    void restartTimer(boolean onlyIfRunning) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("## TextEditorSupport::restartTimer: onlyIfRunning = " + onlyIfRunning);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("##                  ::restartTimer: timer.isRunning = " + this.timer.isRunning());
        }
        if (onlyIfRunning && !this.timer.isRunning()) {
            return;
        }
        int delay = this.getAutoParsingDelay();
        if (delay > 0) {
            this.timer.setInitialDelay(delay);
            this.timer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CloneableEditor openCloneableEditor() {
        CloneableEditor ret = null;
        Object object = this.getLock();
        synchronized (object) {
            CloneableTopComponent editor;
            String msg = this.messageOpening();
            if (msg != null) {
                StatusDisplayer.getDefault().setStatusText(msg);
            }
            Enumeration en = this.allEditors.getComponents();
            while (en.hasMoreElements()) {
                editor = (CloneableTopComponent)en.nextElement();
                if (!(editor instanceof CloneableEditor)) continue;
                editor.open();
                ret = (CloneableEditor)editor;
            }
            if (ret == null) {
                editor = (CloneableEditor)this.createCloneableTopComponent();
                editor.setReference(this.allEditors);
                editor.open();
                ret = editor;
            }
            if ((msg = this.messageOpened()) == null) {
                msg = "";
            }
            StatusDisplayer.getDefault().setStatusText(msg);
            return ret;
        }
    }

    protected Object getLock() {
        if (awtLock == null) {
            awtLock = new Container();
        }
        return awtLock.getTreeLock();
    }

    protected CloneableEditor createCloneableEditor() {
        this.syncMimeType();
        return new TextEditorComponent(this);
    }

    protected final CloneableTopComponent createCloneableTopComponent() {
        this.syncMimeType();
        return super.createCloneableTopComponent();
    }

    public static final TextEditorSupportFactory findEditorSupportFactory(XMLDataObjectLook xmlDO, String mime) {
        return new TextEditorSupportFactory(xmlDO, mime);
    }

    String getMIMEType() {
        return this.mimeType;
    }

    protected static class Env
    extends DataEditorSupport.Env
    implements SaveCookie {
        private static final long serialVersionUID = -5285524519399090028L;

        public Env(XMLDataObjectLook obj) {
            super((DataObject)obj);
        }

        protected XMLDataObjectLook getXMLDataObjectLook() {
            return (XMLDataObjectLook)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public synchronized void save() throws IOException {
            this.findTextEditorSupport().saveDocument();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findTextEditorSupport();
        }

        public TextEditorSupport findTextEditorSupport() {
            EditCookie cookie = (EditCookie)this.getDataObject().getCookie(EditCookie.class);
            if (cookie instanceof TextEditorSupport) {
                return (TextEditorSupport)cookie;
            }
            return null;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("primaryFile".equals(ev.getPropertyName())) {
                this.changeFile();
            }
            super.propertyChange(ev);
        }
    }

    public static class TextEditorSupportFactory
    implements CookieSet.Factory {
        private WeakReference editorRef;
        private final XMLDataObjectLook dataObject;
        private String mime;

        public TextEditorSupportFactory(XMLDataObjectLook dobj, String mime) {
            if (mime == null && !(dobj instanceof DataObject)) {
                throw new IllegalArgumentException("DataObject is needed to lazy-resolve MIME type");
            }
            this.dataObject = dobj;
            this.mime = mime;
        }

        protected Class[] supportedCookies() {
            return new Class[]{EditorCookie.Observable.class, OpenCookie.class, EditCookie.class, CloseCookie.class, PrintCookie.class, CloneableEditorSupport.class};
        }

        public final void registerCookies(CookieSet cookieSet) {
            cookieSet.add(this.supportedCookies(), (CookieSet.Factory)this);
        }

        public final Node.Cookie createCookie(Class klass) {
            Class[] supportedCookies = this.supportedCookies();
            for (int i = 0; i < supportedCookies.length; ++i) {
                if (!supportedCookies[i].isAssignableFrom(klass)) continue;
                return this.createEditor();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final TextEditorSupport createEditor() {
            TextEditorSupport editorSupport = null;
            TextEditorSupportFactory textEditorSupportFactory = this;
            synchronized (textEditorSupportFactory) {
                if (this.editorRef != null) {
                    editorSupport = (TextEditorSupport)((Object)this.editorRef.get());
                }
                if (editorSupport != null) {
                    return editorSupport;
                }
                editorSupport = this.prepareEditor();
                this.editorRef = new WeakReference<TextEditorSupport>(editorSupport);
            }
            editorSupport.syncMimeType();
            return editorSupport;
        }

        protected TextEditorSupport prepareEditor() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Initializing TextEditorSupport ...");
            }
            return new TextEditorSupport(this.getDataObject(), this.getMIMEType());
        }

        protected final XMLDataObjectLook getDataObject() {
            return this.dataObject;
        }

        protected final String getMIMEType() {
            if (this.mime == null) {
                this.mime = this.findMIMEtype();
            }
            return this.mime;
        }

        private String findMIMEtype() {
            FileObject fo = ((DataObject)this.dataObject).getPrimaryFile();
            String mimetype = null;
            if (fo.isValid()) {
                mimetype = fo.getMIMEType();
            }
            if (mimetype == null || mimetype.indexOf("xml") == -1) {
                mimetype = "text/xml";
            }
            if ("text/xml".equals(mimetype)) {
                mimetype = "text/plain+xml";
            }
            return mimetype;
        }
    }
}

