/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;

public class SQLHistoryManager {
    JAXBContext context;
    private static final String SQL_HISTORY_DIRECTORY = "Databases/SQLHISTORY";
    private static final String SQL_HISTORY_FILE = "sql_history.xml";
    public static final String OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY = "SQL_STATEMENTS_SAVED_FOR_HISTORY";
    public static final int DEFAULT_SQL_STATEMENTS_SAVED_FOR_HISTORY = 100;
    public static final int MAX_SQL_STATEMENTS_SAVED_FOR_HISTORY = 10000;
    private static SQLHistoryManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(SQLHistoryEntry.class.getName());
    private SQLHistory sqlHistory;

    protected SQLHistoryManager() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SQLHistoryManager.class.getClassLoader());
        try {
            this.context = JAXBContext.newInstance((String)"org.netbeans.modules.db.sql.history", (ClassLoader)SQLHistoryManager.class.getClassLoader());
            this.loadHistory();
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public static SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return NbPreferences.forModule(SQLHistoryPanel.class).getInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", 100);
    }

    protected FileObject getHistoryRoot(boolean create) throws IOException {
        FileObject result = null;
        FileObject historyRootDir = this.getConfigRoot().getFileObject(this.getRelativeHistoryPath());
        if (historyRootDir != null || create) {
            FileObject historyRoot;
            if (historyRootDir == null) {
                historyRootDir = FileUtil.createFolder((FileObject)this.getConfigRoot(), (String)this.getRelativeHistoryPath());
            }
            if ((historyRoot = historyRootDir.getFileObject(this.getHistoryFilename())) != null || create) {
                if (historyRoot == null) {
                    historyRoot = historyRootDir.createData(this.getHistoryFilename());
                }
                result = historyRoot;
            }
        }
        return result;
    }

    protected FileObject getConfigRoot() {
        return FileUtil.getConfigRoot();
    }

    protected String getRelativeHistoryPath() {
        return SQL_HISTORY_DIRECTORY;
    }

    protected String getHistoryFilename() {
        return SQL_HISTORY_FILE;
    }

    public void setListSize(int listSize) {
        NbPreferences.forModule(SQLHistoryPanel.class).putInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", listSize);
        this.sqlHistory.setHistoryLimit(listSize);
    }

    public void saveSQL(SQLHistoryEntry sqlStored) {
        this.sqlHistory.add(sqlStored);
    }

    private void loadHistory() {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            InputStream is = this.getHistoryRoot(false).getInputStream();
            this.sqlHistory = (SQLHistory)unmarshaller.unmarshal(is);
            this.sqlHistory.setHistoryLimit(this.getListSize());
            is.close();
        }
        catch (Exception ex) {
            this.sqlHistory = new SQLHistory();
            this.sqlHistory.setHistoryLimit(this.getListSize());
            LOGGER.log(Level.INFO, ex.getMessage());
        }
    }

    public void save() {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            OutputStream os = this.getHistoryRoot(true).getOutputStream();
            marshaller.marshal((Object)this.sqlHistory, os);
            os.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage());
        }
    }

    public SQLHistory getSQLHistory() {
        return this.sqlHistory;
    }
}

