/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;

@XmlRootElement(name="history")
public class SQLHistory
implements Set<SQLHistoryEntry> {
    @XmlTransient
    private int historyLimit = 100;
    @XmlElement(name="sql")
    private Set<SQLHistoryEntry> history = new HashSet<SQLHistoryEntry>();

    public String toString() {
        return this.history.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.history.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.history.toArray();
    }

    @Override
    public int size() {
        return this.history.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.history.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.history.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.history.remove(o);
    }

    @Override
    public Iterator<SQLHistoryEntry> iterator() {
        return this.history.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public int hashCode() {
        return ((Object)this.history).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.history).equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.history.containsAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.history.contains(o);
    }

    @Override
    public void clear() {
        this.history.clear();
    }

    @Override
    public boolean addAll(Collection<? extends SQLHistoryEntry> c) {
        boolean changed = false;
        for (SQLHistoryEntry sQLHistoryEntry : c) {
            changed |= this.add(sQLHistoryEntry);
        }
        return changed;
    }

    @Override
    public boolean add(SQLHistoryEntry e) {
        boolean result = this.history.add(e);
        if (!result) {
            this.history.remove(e);
            result = this.history.add(e);
        }
        this.enforceLimit();
        return result;
    }

    public void enforceLimit() {
        if (this.size() > this.historyLimit) {
            ArrayList<SQLHistoryEntry> list = new ArrayList<SQLHistoryEntry>(this.history);
            Collections.sort(list, new Comparator<SQLHistoryEntry>(){

                @Override
                public int compare(SQLHistoryEntry o1, SQLHistoryEntry o2) {
                    return o2.getDate().compareTo(o1.getDate());
                }
            });
            this.history.clear();
            this.history.addAll(list.subList(0, this.historyLimit));
        }
    }

    @XmlTransient
    public int getHistoryLimit() {
        return this.historyLimit;
    }

    public void setHistoryLimit(int historyLimit) {
        this.historyLimit = historyLimit;
        this.enforceLimit();
    }
}

