/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.primefaces.PrimefacesImplementation;
import org.netbeans.modules.web.primefaces.ui.Bundle;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PrimefacesCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOGGER = Logger.getLogger(PrimefacesCustomizerPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton createLibraryButton;
    private JLabel noteLabel;
    private JComboBox primefacesLibrariesComboBox;
    private JLabel primefacesLibraryLabel;

    public PrimefacesCustomizerPanel(ChangeListener changeListener) {
        this.initComponents();
        this.changeSupport.addChangeListener(changeListener);
        this.initLibraries(true);
        this.primefacesLibrariesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrimefacesCustomizerPanel.this.changeSupport.fireChange();
            }
        });
    }

    public final void initLibraries(final boolean bl) {
        long l = System.currentTimeMillis();
        final ArrayList arrayList = new ArrayList();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (Library library : PrimefacesImplementation.getAllRegisteredPrimefaces()) {
                    arrayList.add(library);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrimefacesCustomizerPanel.this.setPrimefacesLibrariesComboBox(arrayList);
                        if (bl && !arrayList.isEmpty()) {
                            PrimefacesCustomizerPanel.this.setDefaultPrimefacesComboBoxValue(arrayList);
                        }
                        PrimefacesCustomizerPanel.this.changeSupport.fireChange();
                    }
                });
            }
        });
        LOGGER.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - l});
    }

    public Library getPrimefacesLibrary() {
        Object object = this.primefacesLibrariesComboBox.getSelectedItem();
        if (object != null && object instanceof Library) {
            return (Library)object;
        }
        return null;
    }

    private void setPrimefacesLibrariesComboBox(List<Library> list) {
        this.primefacesLibrariesComboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.primefacesLibrariesComboBox.setRenderer(new LibraryComboBoxRenderer());
        this.primefacesLibrariesComboBox.setEnabled(!list.isEmpty());
    }

    private void setDefaultPrimefacesComboBoxValue(List<Library> list) {
        Preferences preferences = PrimefacesImplementation.getPrimefacesPreferences();
        String string = preferences.get("preferred-library", "");
        for (Library library : list) {
            if (!library.getName().equals(string)) continue;
            this.primefacesLibrariesComboBox.setSelectedItem(library);
        }
    }

    public String getErrorMessage() {
        if (this.getPrimefacesLibrary() == null) {
            return Bundle.PrimefacesCustomizerPanel_MissingLibraries_label();
        }
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    private void initComponents() {
        this.primefacesLibraryLabel = new JLabel();
        this.primefacesLibrariesComboBox = new JComboBox();
        this.createLibraryButton = new JButton();
        this.noteLabel = new JLabel();
        this.primefacesLibraryLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/primefaces/ui/Bundle").getString("PrimefacesCustomizerPanel.primefacesLibraryLabel.mnemonics").charAt(0));
        this.primefacesLibraryLabel.setFont(new Font("Dialog", 0, 12));
        this.primefacesLibraryLabel.setLabelFor(this.primefacesLibrariesComboBox);
        this.primefacesLibraryLabel.setText(NbBundle.getMessage(PrimefacesCustomizerPanel.class, (String)"PrimefacesCustomizerPanel.primefacesLibraryLabel.text"));
        this.primefacesLibrariesComboBox.setFont(new Font("Dialog", 0, 12));
        this.primefacesLibrariesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Searching Primefaces Libraries..."}));
        this.createLibraryButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/primefaces/ui/Bundle").getString("PrimefacesCustomizerPanel.createLibraryButton.mnemonic").charAt(0));
        this.createLibraryButton.setText(NbBundle.getMessage(PrimefacesCustomizerPanel.class, (String)"PrimefacesCustomizerPanel.createLibraryButton.text"));
        this.createLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrimefacesCustomizerPanel.this.createLibraryButtonActionPerformed(actionEvent);
            }
        });
        this.noteLabel.setFont(new Font("Dialog", 2, 12));
        this.noteLabel.setText(NbBundle.getMessage(PrimefacesCustomizerPanel.class, (String)"PrimefacesCustomizerPanel.noteLabel.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.primefacesLibraryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.primefacesLibrariesComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createLibraryButton, GroupLayout.Alignment.TRAILING).addComponent(this.noteLabel, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.primefacesLibraryLabel).addComponent(this.primefacesLibrariesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createLibraryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.noteLabel, -2, 15, -2)));
    }

    private void createLibraryButtonActionPerformed(ActionEvent actionEvent) {
        LibrariesCustomizer.showCreateNewLibraryCustomizer((LibraryManager)LibraryManager.getDefault());
        this.initLibraries(false);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class LibraryComboBoxRenderer
    extends DefaultListCellRenderer {
        private LibraryComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Library) {
                ((JLabel)component).setText(((Library)object).getDisplayName());
            } else {
                ((JLabel)component).setText((String)object);
            }
            return component;
        }
    }
}

