/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.modules.web.primefaces.PrimefacesCustomizer;
import org.netbeans.modules.web.primefaces.PrimefacesProvider;
import org.netbeans.modules.web.primefaces.ui.PrimefacesCustomizerPanel;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class PrimefacesImplementation
implements JsfComponentImplementation {
    private PrimefacesCustomizer customizer;
    private final String name = NbBundle.getMessage(PrimefacesProvider.class, (String)"LBL_PrimeFaces");
    private final String description = NbBundle.getMessage(PrimefacesProvider.class, (String)"LBL_PrimeFaces_Description");
    private static final Logger LOGGER = Logger.getLogger(PrimefacesImplementation.class.getName());
    private static final String PRIMEFACES_SPECIFIC_PRIME_RESOURCE = "org.primefaces.application.PrimeResource";
    private static final String PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER = "org.primefaces.application.PrimeResourceHandler";
    private static final String PREFERENCES_NODE = "primefaces";
    private static final String POM_PROPERTIES_PATH = "META-INF/maven/org.primefaces/primefaces/pom.properties";
    public static final String PROP_PREFERRED_LIBRARY = "preferred-library";

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        Library library;
        try {
            library = PrimefacesImplementation.getPreferredLibrary(jsfComponentCustomizer);
            if (library == null) {
                LOGGER.log(Level.SEVERE, "No PrimeFaces library found.");
            } else {
                List<URI> list;
                Object object;
                Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
                AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
                if (antArtifactProvider == null && ((object = library.getContent("maven-pom")) == null || object.isEmpty()) && !(list = PrimefacesImplementation.getPomURIs(library)).isEmpty()) {
                    library = JsfComponentUtils.enhanceLibraryWithPomContent((Library)library, list);
                }
                object = webModule.getJavaSources();
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)object[0], (String)"classpath/compile");
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", unsupportedOperationException);
        }
        try {
            library = PrimefacesImplementation.generateWelcomePage(webModule);
            return Collections.singleton(library);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during creating welcome page and extending index", iOException);
            return Collections.emptySet();
        }
    }

    public Set<JSFVersion> getJsfVersion() {
        return EnumSet.of(JSFVersion.JSF_2_0, JSFVersion.JSF_2_1);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        return this.hasPrimeFacesResource(classPath);
    }

    private boolean hasPrimeFacesResource(ClassPath classPath) {
        return classPath.findResource(PRIMEFACES_SPECIFIC_PRIME_RESOURCE.replace('.', '/') + ".class") != null || classPath.findResource(PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER.replace('.', '/') + ".class") != null;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new PrimefacesCustomizer();
        }
        return this.customizer;
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> list = PrimefacesImplementation.getAllRegisteredPrimefaces();
            ProjectClassPathModifier.removeLibraries((Library[])list.toArray(new Library[list.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", unsupportedOperationException);
        }
    }

    public static List<Library> getAllRegisteredPrimefaces() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !PrimefacesImplementation.isValidPrimefacesLibrary(list = library.getContent("classpath"))) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public static boolean isValidPrimefacesLibrary(List<URL> list) {
        try {
            return Util.containsClass(list, (String)PRIMEFACES_SPECIFIC_PRIME_RESOURCE) || Util.containsClass(list, (String)PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
    }

    public static Preferences getPrimefacesPreferences() {
        return NbPreferences.forModule(PrimefacesImplementation.class).node(PREFERENCES_NODE);
    }

    private static List<URI> getPomURIs(Library library) {
        String string = "http://repository.primefaces.org/org/primefaces/primefaces/<VERSION>/primefaces-<VERSION>.pom";
        String string2 = "version=";
        LinkedList<URI> linkedList = new LinkedList<URI>();
        for (URI uRI : library.getURIContent("classpath")) {
            try {
                URL uRL = FileUtil.getArchiveFile((URL)uRI.toURL());
                JarFileSystem jarFileSystem = new JarFileSystem(new File(uRL.toURI()));
                FileObject fileObject = jarFileSystem.findResource(POM_PROPERTIES_PATH);
                if (fileObject == null) continue;
                String string3 = fileObject.asText();
                int n = string3.indexOf(string2);
                String string4 = string3.substring(n + string2.length());
                string4 = string4.substring(0, string4.indexOf("\n"));
                linkedList.add(new URI(string.replaceAll("<VERSION>", string4.trim())));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.log(Level.WARNING, "Primefaces version wasn't parsed", uRISyntaxException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Primefaces version wasn't parsed", iOException);
            }
        }
        return linkedList;
    }

    private static Library getPreferredLibrary(JsfComponentCustomizer jsfComponentCustomizer) {
        PrimefacesCustomizerPanel primefacesCustomizerPanel;
        Library library;
        if (jsfComponentCustomizer != null && (library = (primefacesCustomizerPanel = (PrimefacesCustomizerPanel)jsfComponentCustomizer.getComponent()).getPrimefacesLibrary()) != null) {
            return LibraryManager.getDefault().getLibrary(library.getName());
        }
        primefacesCustomizerPanel = LibraryManager.getDefault().getLibrary(PrimefacesImplementation.getPrimefacesPreferences().get(PROP_PREFERRED_LIBRARY, ""));
        if (primefacesCustomizerPanel != null) {
            return primefacesCustomizerPanel;
        }
        return PrimefacesImplementation.getAllRegisteredPrimefaces().get(0);
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/Other/welcomePrimefaces.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        DataObject dataObject2 = dataObject.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomePrimefaces");
        JsfComponentUtils.reformat((DataObject)dataObject2);
        PrimefacesImplementation.updateIndexPage(webModule);
        return dataObject2.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject fileObject = webModule.getDocumentBase().getFileObject("index.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        JsfComponentUtils.enhanceFileBody((DataObject)dataObject, (String)"</h:body>", (String)"<br />\n<h:link outcome=\"welcomePrimefaces\" value=\"Primefaces welcome page\" />");
        if (fileObject.isValid() && fileObject.canWrite()) {
            JsfComponentUtils.reformat((DataObject)dataObject);
        }
    }
}

