/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.primefaces.PrimefacesImplementation;
import org.netbeans.modules.web.primefaces.ui.PrimefacesCustomizerPanel;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class PrimefacesCustomizer
implements JsfComponentCustomizer {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PrimefacesCustomizerPanel panel;

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    private synchronized PrimefacesCustomizerPanel getPanel() {
        if (this.panel == null) {
            this.panel = new PrimefacesCustomizerPanel(new PrimefacesPanelChangeListener());
        }
        return this.panel;
    }

    public boolean isValid() {
        Preferences preferences = PrimefacesImplementation.getPrimefacesPreferences();
        String string = preferences.get("preferred-library", "");
        if (LibraryManager.getDefault().getLibrary(string) != null) {
            return true;
        }
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !PrimefacesImplementation.isValidPrimefacesLibrary(list = library.getContent("classpath"))) continue;
            return true;
        }
        return false;
    }

    public String getErrorMessage() {
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = PrimefacesImplementation.getPrimefacesPreferences();
        if (this.panel.getPrimefacesLibrary() != null) {
            preferences.put("preferred-library", this.panel.getPrimefacesLibrary().getName());
        }
    }

    public HelpCtx getHelpCtx() {
        return this.panel.getHelpCtx();
    }

    private class PrimefacesPanelChangeListener
    implements ChangeListener {
        private PrimefacesPanelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            PrimefacesCustomizer.this.changeSupport.fireChange();
        }
    }
}

