/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.modules.localhistory.ui.view.HistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.ui.history.History;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class ShowHistoryAction
extends NodeAction {
    public ShowHistoryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        File[] files = rootSet.toArray(new File[rootSet.size()]);
        if (!files[0].isFile()) {
            return;
        }
        File file = files[0];
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                History.LOG.log(Level.WARNING, null, ex);
            }
            if (dataObject != null) {
                if (!this.hasHistoryElement(dataObject)) {
                    this.openLocalHistoryTC(files);
                    return;
                }
                Set tcs = TopComponent.getRegistry().getOpened();
                for (TopComponent tc : tcs) {
                    MultiViewHandler handler;
                    Lookup l = tc.getLookup();
                    DataObject tcDataObject = (DataObject)l.lookup(DataObject.class);
                    if (tcDataObject == null || !dataObject.equals(tcDataObject) || (handler = MultiViews.findMultiViewHandler((TopComponent)tc)) == null || !this.activateHistoryTab(handler, tc)) continue;
                    return;
                }
                EditCookie cookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                if (cookie != null) {
                    TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new TCOpenedListener(dataObject, files));
                    cookie.edit();
                    return;
                }
            }
        }
        this.openLocalHistoryTC(files);
    }

    private void openLocalHistoryTC(final File[] files) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryTopComponent tc = new HistoryTopComponent(files);
                tc.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_LocalHistoryTopComponent", (Object)files[0].getName()));
                tc.open();
                tc.requestActive();
            }
        });
    }

    private boolean hasHistoryElement(DataObject dataObject) {
        String mime = dataObject.getPrimaryFile().getMIMEType();
        Lookup l = MimeLookup.getLookup((MimePath)MimePath.get((String)mime));
        Collection descs = l.lookupAll(MultiViewDescription.class);
        for (MultiViewDescription desc : descs) {
            if (!desc.preferredID().equals("text.history")) continue;
            return true;
        }
        return false;
    }

    private boolean activateHistoryTab(final MultiViewHandler handler, final TopComponent tc) {
        if (handler != null) {
            MultiViewPerspective[] perspectives;
            for (final MultiViewPerspective p : perspectives = handler.getPerspectives()) {
                if (!p.preferredID().equals("text.history")) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tc.open();
                        tc.requestActive();
                        handler.requestActive(p);
                    }
                });
                return true;
            }
        }
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null || rootSet.isEmpty()) {
            return false;
        }
        for (File file : rootSet) {
            if (file == null || file.isFile()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowHistory");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowHistoryAction.class);
    }

    private class TCOpenedListener
    implements PropertyChangeListener {
        private final DataObject dataObject;
        private final File[] files;

        private TCOpenedListener(DataObject dataObject, File[] files) {
            this.dataObject = dataObject;
            this.files = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activated".equals(evt.getPropertyName())) {
                try {
                    MultiViewHandler handler;
                    TopComponent tc = (TopComponent)evt.getNewValue();
                    Lookup l = tc.getLookup();
                    DataObject tcDataObject = (DataObject)l.lookup(DataObject.class);
                    if (tcDataObject != null && this.dataObject.equals(tcDataObject) && ((handler = MultiViews.findMultiViewHandler((TopComponent)tc)) == null || !ShowHistoryAction.this.activateHistoryTab(handler, tc))) {
                        tc.close();
                        ShowHistoryAction.this.openLocalHistoryTC(this.files);
                    }
                }
                finally {
                    TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }
}

