/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.localhistory.utils.Utils;
import org.netbeans.modules.versioning.history.HistoryAction;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.LifecycleManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LocalHistoryProvider
implements VCSHistoryProvider,
VersioningListener {
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private Action[] actions;

    public LocalHistoryProvider() {
        LocalHistory.getInstance().getLocalHistoryStore().addVersioningListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public VCSHistoryProvider.HistoryEntry[] getHistory(File[] files, Date fromDate) {
        if (files == null || files.length == 0) {
            LocalHistory.LOG.log(Level.FINE, "LocalHistory requested for no files {0}", files != null ? Integer.valueOf(files.length) : null);
            return new VCSHistoryProvider.HistoryEntry[0];
        }
        this.logFiles(files);
        HashMap<Long, VCSHistoryProvider.HistoryEntry> storeEntries = new HashMap<Long, VCSHistoryProvider.HistoryEntry>();
        for (File f : files) {
            StoreEntry[] ses;
            for (StoreEntry se : ses = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntries(f)) {
                if (storeEntries.keySet().contains(se.getTimestamp())) continue;
                VCSHistoryProvider.HistoryEntry e = new VCSHistoryProvider.HistoryEntry(files, (Date)se.getDate(), se.getLabel(), "", "", NbBundle.getMessage(LocalHistoryProvider.class, (String)"LBL_Local"), NbBundle.getMessage(LocalHistoryProvider.class, (String)"LBL_Local"), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(se), (VCSHistoryProvider.MessageEditProvider)new MessageEditImpl(se));
                storeEntries.put(se.getTimestamp(), e);
            }
        }
        this.logEntries(storeEntries.values());
        return storeEntries.values().toArray(new VCSHistoryProvider.HistoryEntry[storeEntries.size()]);
    }

    public Action createShowHistoryAction(File[] files) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(File file) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        for (VCSHistoryProvider.HistoryChangeListener l : la) {
            l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)this, new File[]{file}));
        }
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new RevertFileAction(), new DeleteAction()};
        }
        return this.actions;
    }

    public void versioningEvent(VersioningEvent event) {
        Object[] params = event.getParams();
        if (params[0] != null) {
            this.fireHistoryChange((File)params[0]);
        }
    }

    private void logFiles(File[] files) {
        if (LocalHistory.LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("LocalHistory requested for files: ");
            sb.append(this.toString(files));
            LocalHistory.LOG.fine(sb.toString());
        }
    }

    private void logEntries(Collection<VCSHistoryProvider.HistoryEntry> entries) {
        LocalHistory.LOG.log(Level.FINE, "LocalHistory returns {0} entries", entries.size());
        if (LocalHistory.LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            Iterator<VCSHistoryProvider.HistoryEntry> it = entries.iterator();
            while (it.hasNext()) {
                VCSHistoryProvider.HistoryEntry entry = it.next();
                sb.append("[");
                sb.append(DateFormat.getDateTimeInstance().format(entry.getDateTime()));
                sb.append(",[");
                sb.append(this.toString(entry.getFiles()));
                sb.append("]]");
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            LocalHistory.LOG.finest(sb.toString());
        }
    }

    private String toString(File[] files) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i] != null ? files[i].getAbsolutePath() : "null");
            if (i >= files.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private class DeleteAction
    extends LHAction {
        private DeleteAction() {
        }

        @Override
        void perform(StoreEntry se) {
            LocalHistory.getInstance().getLocalHistoryStore().deleteEntry(se.getFile(), se.getTimestamp());
        }

        public String getName() {
            return NbBundle.getMessage(LocalHistoryProvider.class, (String)"LBL_DeleteAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.localhistory.ui.view.DeleteAction");
        }
    }

    private abstract class LHAction
    extends HistoryAction {
        private LHAction() {
        }

        protected void perform(final VCSHistoryProvider.HistoryEntry entry, final Set<File> files) {
            LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    for (File file : files) {
                        StoreEntry se = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntry(file, entry.getDateTime().getTime());
                        if (se == null) continue;
                        LHAction.this.perform(se);
                    }
                }
            });
        }

        abstract void perform(StoreEntry var1);
    }

    private class MessageEditImpl
    implements VCSHistoryProvider.MessageEditProvider {
        private final StoreEntry se;

        public MessageEditImpl(StoreEntry se) {
            this.se = se;
        }

        public void setMessage(String message) throws IOException {
            LocalHistory.getInstance().getLocalHistoryStore().setLabel(this.se.getFile(), this.se.getTimestamp(), message);
        }
    }

    private class RevertFileAction
    extends LHAction {
        private RevertFileAction() {
        }

        @Override
        void perform(StoreEntry se) {
            Utils.revert(se);
        }

        @Override
        protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
            LifecycleManager.getDefault().saveAll();
            super.perform(entry, files);
        }

        protected boolean isMultipleHistory() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.localhistory.ui.view.RevertFileAction");
        }

        public String getName() {
            return NbBundle.getMessage(LocalHistoryProvider.class, (String)"LBL_RevertFileAction");
        }
    }

    private class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private final StoreEntry se;

        public RevisionProviderImpl(StoreEntry se) {
            this.se = se;
        }

        public void getRevisionFile(File originalFile, File revisionFile) {
            assert (originalFile != null);
            if (originalFile == null) {
                LocalHistory.LOG.log(Level.FINE, "revision {0} requested for null file", this.se.getDate().getTime());
                return;
            }
            LocalHistory.LOG.log(Level.FINE, "revision {0} requested for file {1}", new Object[]{this.se.getDate().getTime(), originalFile.getAbsolutePath()});
            try {
                long ts = this.se.getTimestamp();
                StoreEntry storeEntry = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntry(originalFile, ts);
                if (storeEntry != null) {
                    FileUtils.copy(storeEntry.getStoreFileInputStream(), revisionFile);
                } else {
                    LocalHistory.LOG.log(Level.WARNING, "No entry in Local History for file {0} {1} {2}", new Object[]{originalFile, new Date(ts), ts});
                }
            }
            catch (IOException e) {
                LocalHistory.LOG.log(Level.WARNING, "Error while retrieving history for file {0} stored as {1}", new Object[]{this.se.getFile(), this.se.getStoreFile()});
            }
        }
    }
}

