/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.refactoring.CssElementContext;
import org.netbeans.modules.css.refactoring.CssRefactoringExtraInfo;
import org.netbeans.modules.css.refactoring.WhereUsedElement;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CssWhereUsedQueryPlugin
implements RefactoringPlugin {
    private WhereUsedQuery refactoring;
    private boolean cancelled = false;

    public CssWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        block19: {
            CssElementContext context;
            block18: {
                RefactoringElementType type;
                ElementKind kind;
                Collection<FileObject> files;
                if (this.cancelled) {
                    return null;
                }
                Lookup lookup = this.refactoring.getRefactoringSource();
                context = (CssElementContext)lookup.lookup(CssElementContext.class);
                if (!(context instanceof CssElementContext.Editor)) break block18;
                CssElementContext.Editor econtext = (CssElementContext.Editor)context;
                CssProjectSupport sup = CssProjectSupport.findFor(context.getFileObject());
                if (sup == null) {
                    return null;
                }
                CssIndex index = sup.getIndex();
                Node element = econtext.getElement();
                if (element.type() != NodeType.cssClass && element.type() != NodeType.cssId && element.type() != NodeType.hexColor) break block19;
                String elementImage = econtext.getElementName();
                switch (element.type()) {
                    case cssClass: {
                        elementImage = elementImage.substring(1);
                        files = index.findClasses(elementImage);
                        kind = ElementKind.CLASS;
                        type = RefactoringElementType.CLASS;
                        break;
                    }
                    case cssId: {
                        elementImage = elementImage.substring(1);
                        files = index.findIds(elementImage);
                        kind = ElementKind.ATTRIBUTE;
                        type = RefactoringElementType.ID;
                        break;
                    }
                    case hexColor: {
                        files = index.findColor(elementImage);
                        kind = ElementKind.FIELD;
                        type = RefactoringElementType.COLOR;
                        break;
                    }
                    default: {
                        files = null;
                        kind = null;
                        type = null;
                    }
                }
                LinkedList<FileObject> involvedFiles = new LinkedList<FileObject>(files);
                DependenciesGraph deps = index.getDependencies(context.getFileObject());
                Collection relatedFiles = deps.getAllRelatedFiles();
                CssRefactoringExtraInfo extraInfo = (CssRefactoringExtraInfo)lookup.lookup(CssRefactoringExtraInfo.class);
                if (extraInfo == null || !extraInfo.isRefactorAll()) {
                    involvedFiles.retainAll(relatedFiles);
                }
                for (FileObject file : involvedFiles) {
                    try {
                        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                        Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                        CssFileModel model = CssFileModel.create(source);
                        Collection<Entry> entries = model.get(type);
                        boolean related = relatedFiles.contains(file);
                        for (Entry entry : entries) {
                            if (!entry.isValidInSourceDocument() || !LexerUtils.equals((CharSequence)elementImage, (CharSequence)entry.getName(), (type == RefactoringElementType.COLOR ? 1 : 0) != 0, (boolean)false)) continue;
                            WhereUsedElement elem = WhereUsedElement.create(file, entry, kind, related);
                            elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                        }
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                break block19;
            }
            if (context instanceof CssElementContext.File) {
                CssElementContext.File fcontext = (CssElementContext.File)context;
                CssProjectSupport sup = CssProjectSupport.findFor(context.getFileObject());
                if (sup == null) {
                    return null;
                }
                FileObject base = fcontext.getFileObject();
                CssIndex index = sup.getIndex();
                DependenciesGraph deps = index.getDependencies(base);
                String baseFileName = base.getNameExt();
                for (DependenciesGraph.Node referingNode : deps.getSourceNode().getReferingNodes()) {
                    try {
                        FileObject file = referingNode.getFile();
                        CssFileModel model = CssFileModel.create(Source.create((FileObject)file));
                        Collection<Entry> imports = model.getImports();
                        for (Entry e : imports) {
                            if (!e.isValidInSourceDocument() || e.getName().indexOf(baseFileName) == -1) continue;
                            WhereUsedElement elem = WhereUsedElement.create(file, e, ElementKind.FILE);
                            elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                        }
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
        this.cancelled = true;
    }
}

