/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.editor.ui.CssRuleCreateActionDialog;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CssCodeGenerators {

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            return Collections.singletonList(new GenerateCssRule());
        }
    }

    public static class GenerateCssRule
    implements CodeGenerator {
        public String getDisplayName() {
            return NbBundle.getMessage(CssCodeGenerators.class, (String)"MSG_CreateCssRule");
        }

        public void invoke() {
            final JTextComponent target = EditorRegistry.lastFocusedComponent();
            CssRuleCreateActionDialog cssRuleCreateActionDialog = new CssRuleCreateActionDialog();
            cssRuleCreateActionDialog.showDialog();
            final String styleRuleName = cssRuleCreateActionDialog.getStyleRuleName();
            if (styleRuleName != null && !styleRuleName.equals("")) {
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        int searchPos = target.getCaret().getDot() - 1;
                        int insertPos = doc.getLength() + 1;
                        try {
                            if (searchPos > 0) {
                                String txtBefore = doc.getText(searchPos, 1);
                                while (!(txtBefore.equals("{") || txtBefore.equals("}") || txtBefore.equals("/") && searchPos - 1 >= 0 && (doc.getText(searchPos - 1, 1).equals("*") || searchPos + 1 <= doc.getLength() && doc.getText(searchPos + 1, 1).equals("*")) || --searchPos < 0)) {
                                    txtBefore = doc.getText(searchPos, 1);
                                }
                                if (searchPos < 0) {
                                    insertPos = 0;
                                } else if (txtBefore.equals("}")) {
                                    insertPos = searchPos + 1;
                                } else if (txtBefore.equals("/")) {
                                    if (searchPos - 1 >= 0) {
                                        if (doc.getText(searchPos - 1, 1).equals("*")) {
                                            insertPos = searchPos + 1;
                                        } else if (searchPos + 1 <= doc.getLength() && doc.getText(searchPos + 1, 1).equals("*")) {
                                            insertPos = searchPos - 1;
                                        }
                                    }
                                } else if (txtBefore.equals("{")) {
                                    searchPos = target.getCaret().getDot();
                                    String txtAfter = doc.getText(searchPos, 1);
                                    while (!txtAfter.equals("}") && ++searchPos <= doc.getLength()) {
                                        txtAfter = doc.getText(searchPos, 1);
                                    }
                                    if (txtAfter.equals("}")) {
                                        insertPos = searchPos + 1;
                                    }
                                }
                            } else {
                                insertPos = 0;
                            }
                            doc.insertString(insertPos, "\n" + styleRuleName + " {\n\n}", null);
                            searchPos = insertPos;
                            String txtAfter = doc.getText(searchPos, 1);
                            while (!txtAfter.equals("{") && ++searchPos <= doc.getLength()) {
                                txtAfter = doc.getText(searchPos, 1);
                            }
                            target.setCaretPosition(searchPos += 2);
                        }
                        catch (BadLocationException exc) {
                            exc.printStackTrace();
                        }
                    }
                });
            }
        }
    }
}

