/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.CssIndexer;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssIndex {
    private static final Logger LOGGER = Logger.getLogger(CssIndex.class.getSimpleName());
    private final QuerySupport querySupport;
    private final Collection<FileObject> sourceRoots;
    private AllDependenciesMaps allDepsCache;
    private long allDepsCache_hashCode;
    private static final String REGEXP_CHARS_TO_ENCODE = ".\\?*+&:{}[]()^$";

    public static CssIndex create(Project project) throws IOException {
        return new CssIndex(project);
    }

    private CssIndex(Project project) throws IOException {
        this.sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
        this.querySupport = QuerySupport.forRoots((String)"css", (int)2, (FileObject[])this.sourceRoots.toArray(new FileObject[0]));
    }

    public Collection<FileObject> findIds(String id) {
        return this.find(RefactoringElementType.ID, id);
    }

    public Collection<FileObject> findIdDeclarations(String id) {
        return this.find(RefactoringElementType.ID, id, false);
    }

    public Map<FileObject, Collection<String>> findAllIdDeclarations() {
        return this.findAll(RefactoringElementType.ID, false);
    }

    public Collection<FileObject> findClasses(String clazz) {
        return this.find(RefactoringElementType.CLASS, clazz);
    }

    public Map<FileObject, Collection<String>> findAllClassDeclarations() {
        return this.findAll(RefactoringElementType.CLASS, false);
    }

    public Collection<FileObject> findClassDeclarations(String clazz) {
        return this.find(RefactoringElementType.CLASS, clazz, false);
    }

    public Collection<FileObject> findHtmlElement(String htmlElement) {
        return this.find(RefactoringElementType.ELEMENT, htmlElement);
    }

    public Collection<FileObject> findColor(String colorCode) {
        return this.find(RefactoringElementType.COLOR, colorCode);
    }

    public Map<FileObject, Collection<String>> findClassesByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.CLASS, prefix);
    }

    public Map<FileObject, Collection<String>> findIdsByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.ID, prefix);
    }

    public Map<FileObject, Collection<String>> findColorsByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.COLOR, prefix);
    }

    public Map<FileObject, Collection<String>> findByPrefix(RefactoringElementType type, String prefix) {
        String keyName = type.getIndexKey();
        HashMap<FileObject, Collection<String>> map = new HashMap<FileObject, Collection<String>>();
        try {
            Collection results;
            if (prefix.length() == 0) {
                results = this.querySupport.query(keyName, "", QuerySupport.Kind.PREFIX, new String[]{keyName});
            } else {
                String searchExpression = ".*(" + CssIndex.encodeValueForRegexp(prefix) + ").*";
                results = this.querySupport.query(keyName, searchExpression, QuerySupport.Kind.REGEXP, new String[]{keyName});
            }
            String VIRTUAL_ELEMENT_MARKER_STR = Character.toString('!');
            for (IndexResult result : results) {
                Collection<String> elements = this.decodeListValue(result.getValue(keyName));
                for (String e : elements) {
                    FileObject file;
                    if (!e.startsWith(prefix)) continue;
                    if (e.endsWith(VIRTUAL_ELEMENT_MARKER_STR)) {
                        e = e.substring(0, e.length() - 1);
                    }
                    if ((file = result.getFile()) == null) continue;
                    LinkedList<String> col = (LinkedList<String>)map.get(file);
                    if (col == null) {
                        col = new LinkedList<String>();
                        map.put(file, col);
                    }
                    col.add(e);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public Map<FileObject, Collection<String>> findAll(RefactoringElementType type) {
        return this.findAll(type, true);
    }

    private Map<FileObject, Collection<String>> findAll(RefactoringElementType type, boolean includeVirtualElements) {
        String keyName = type.getIndexKey();
        HashMap<FileObject, Collection<String>> map = new HashMap<FileObject, Collection<String>>();
        try {
            Collection results = this.querySupport.query(keyName, "", QuerySupport.Kind.PREFIX, new String[]{keyName});
            String VIRTUAL_ELEMENT_MARKER_STR = Character.toString('!');
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                Collection<String> elements = this.decodeListValue(indexResult.getValue(keyName));
                for (String e : elements) {
                    LinkedList<String> col;
                    if (e.endsWith(VIRTUAL_ELEMENT_MARKER_STR)) {
                        if (!includeVirtualElements) continue;
                        e = e.substring(0, e.length() - 1);
                    }
                    if ((col = (LinkedList<String>)map.get(indexResult.getFile())) == null) {
                        col = new LinkedList<String>();
                        map.put(indexResult.getFile(), col);
                    }
                    col.add(e);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public Collection<FileObject> find(RefactoringElementType type, String value) {
        return this.find(type, value, true);
    }

    private Collection<FileObject> find(RefactoringElementType type, String value, boolean includeVirtualElements) {
        String keyName = type.getIndexKey();
        try {
            StringBuilder searchExpression = new StringBuilder();
            searchExpression.append(".*(");
            searchExpression.append(CssIndex.encodeValueForRegexp(value));
            if (includeVirtualElements) {
                searchExpression.append('!');
                searchExpression.append('?');
            }
            searchExpression.append(")[,;].*");
            LinkedList<FileObject> matchedFiles = new LinkedList<FileObject>();
            Collection results = this.querySupport.query(keyName, searchExpression.toString(), QuerySupport.Kind.REGEXP, new String[]{keyName});
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                matchedFiles.add(indexResult.getFile());
            }
            return matchedFiles;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<FileObject> getAllIndexedFiles() {
        try {
            Collection results = this.querySupport.query("cssContent", "", QuerySupport.Kind.PREFIX, new String[]{"cssContent"});
            LinkedList<FileObject> stylesheets = new LinkedList<FileObject>();
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                if (!indexResult.getFile().getMIMEType().equals("text/x-css")) continue;
                stylesheets.add(indexResult.getFile());
            }
            return stylesheets;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public DependenciesGraph getDependencies(FileObject cssFile) {
        try {
            DependenciesGraph deps = new DependenciesGraph(cssFile);
            AllDependenciesMaps alldeps = this.getAllDependencies();
            this.resolveDependencies(deps.getSourceNode(), alldeps.getSource2dest(), alldeps.getDest2source());
            return deps;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public AllDependenciesMaps getAllDependencies() throws IOException {
        long freshAllDeps_hashCode = CssIndexer.getImportsHashCodeForRoots(this.sourceRoots);
        if (this.allDepsCache != null) {
            if (this.allDepsCache_hashCode == freshAllDeps_hashCode) {
                LOGGER.fine("Refreshing dependencies maps cache");
                return this.allDepsCache;
            }
        } else {
            LOGGER.fine("Creating dependencies maps cache");
        }
        this.allDepsCache = this.createAllDependencies();
        this.allDepsCache_hashCode = freshAllDeps_hashCode;
        return this.allDepsCache;
    }

    private AllDependenciesMaps createAllDependencies() throws IOException {
        Collection<? extends IndexResult> results = this.filterDeletedFiles(this.querySupport.query("imports", "", QuerySupport.Kind.PREFIX, new String[]{"imports"}));
        HashMap<FileObject, Collection<FileReference>> source2dests = new HashMap<FileObject, Collection<FileReference>>();
        HashMap<FileObject, Collection<FileReference>> dest2sources = new HashMap<FileObject, Collection<FileReference>>();
        for (IndexResult indexResult : results) {
            String importsValue = indexResult.getValue("imports");
            FileObject file = indexResult.getFile();
            Collection<String> imports = this.decodeListValue(importsValue);
            HashSet<FileReference> imported = new HashSet<FileReference>();
            for (String importedFileName : imports) {
                FileReference resolvedReference = WebUtils.resolveToReference((FileObject)file, (String)importedFileName);
                if (resolvedReference == null) continue;
                imported.add(resolvedReference);
                HashSet<FileReference> sources = (HashSet<FileReference>)dest2sources.get(resolvedReference.target());
                if (sources == null) {
                    sources = new HashSet<FileReference>();
                    dest2sources.put(resolvedReference.target(), sources);
                }
                sources.add(resolvedReference);
            }
            source2dests.put(file, imported);
        }
        return new AllDependenciesMaps(source2dests, dest2sources);
    }

    private void resolveDependencies(DependenciesGraph.Node base, Map<FileObject, Collection<FileReference>> source2dests, Map<FileObject, Collection<FileReference>> dest2sources) {
        Collection<FileReference> sources;
        FileObject baseFile = base.getFile();
        Collection<FileReference> destinations = source2dests.get(baseFile);
        if (destinations != null) {
            for (FileReference destinationReference : destinations) {
                FileObject destination = destinationReference.target();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(destination);
                if (!base.addReferedNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
        if ((sources = dest2sources.get(baseFile)) != null) {
            for (FileReference sourceReference : sources) {
                FileObject source = sourceReference.source();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(source);
                if (!base.addReferingNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
    }

    private Collection<String> decodeListValue(String value) {
        assert (value.charAt(value.length() - 1) == ';');
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value.substring(0, value.length() - 1), ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private Collection<? extends IndexResult> filterDeletedFiles(Collection<? extends IndexResult> queryResult) {
        ArrayList<IndexResult> filtered = new ArrayList<IndexResult>();
        for (IndexResult indexResult : queryResult) {
            if (indexResult.getFile() == null) continue;
            filtered.add(indexResult);
        }
        return filtered;
    }

    static String encodeValueForRegexp(String value) {
        StringBuilder encoded = new StringBuilder();
        block0: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            for (int j = 0; j < REGEXP_CHARS_TO_ENCODE.length(); ++j) {
                if (c != REGEXP_CHARS_TO_ENCODE.charAt(j)) continue;
                encoded.append('\\');
                encoded.append(c);
                continue block0;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static class AllDependenciesMaps {
        Map<FileObject, Collection<FileReference>> source2dest;
        Map<FileObject, Collection<FileReference>> dest2source;

        public AllDependenciesMaps(Map<FileObject, Collection<FileReference>> source2dest, Map<FileObject, Collection<FileReference>> dest2source) {
            this.source2dest = source2dest;
            this.dest2source = dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getDest2source() {
            return this.dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getSource2dest() {
            return this.source2dest;
        }
    }
}

