/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.editor.properties.parser.GrammarResolver;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.editor.properties.parser.ResolvedToken;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;

public class PropertyValue {
    private String value;
    private GroupGrammarElement groupGrammarElement;
    private GrammarResolver grammarResolver;
    private static final Pattern FILTER_COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/");

    public PropertyValue(PropertyModel property, String value) {
        this(property.getGrammar(), property.getPropertyName(), PropertyValue.filterComments(value));
    }

    public PropertyValue(String grammar, String propertyName, String value) {
        this(GrammarParser.parse(grammar, propertyName), value);
    }

    public PropertyValue(GroupGrammarElement groupGrammarElement, String value) {
        this.groupGrammarElement = groupGrammarElement;
        this.value = value;
        this.grammarResolver = GrammarResolver.resolve(groupGrammarElement, value);
    }

    public PropertyValue(String grammar, String value) {
        this(GrammarParser.parse(grammar), value);
    }

    public GroupGrammarElement getGroupGrammarElement() {
        return this.groupGrammarElement;
    }

    public List<String> getTokens() {
        return this.grammarResolver.tokens();
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getUnresolvedTokens() {
        return this.grammarResolver.left();
    }

    public List<ResolvedToken> getResolvedTokens() {
        return this.grammarResolver.resolved();
    }

    public boolean isResolved() {
        return this.grammarResolver.success();
    }

    public Set<ValueGrammarElement> getAlternatives() {
        return this.grammarResolver.getAlternatives();
    }

    GrammarResolver getGrammarResolver() {
        return this.grammarResolver;
    }

    private static String filterComments(String text) {
        Matcher m = FILTER_COMMENTS_PATTERN.matcher(text);
        StringBuilder b = new StringBuilder(text);
        while (m.find()) {
            int to;
            int from = m.start();
            if (from == (to = m.end())) continue;
            char[] spaces = new char[to - from];
            Arrays.fill(spaces, ' ');
            String replacement = new String(spaces);
            b.replace(from, to, replacement);
        }
        return b.toString();
    }
}

