/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;

public class PropertyModel {
    private GroupGrammarElement values;
    private Collection<Property> properties;
    private String grammar;
    private String propertyName;

    public PropertyModel(String propertyName, Collection<Property> properties) {
        assert (!properties.isEmpty());
        this.propertyName = propertyName;
        this.properties = properties;
    }

    public Collection<Property> getProperties() {
        return this.properties;
    }

    public Property getProperty() {
        return this.properties.iterator().next();
    }

    public synchronized GroupGrammarElement getGrammarElement() {
        if (this.values == null) {
            this.values = GrammarParser.parse(this.getGrammar(), this.propertyName);
        }
        return this.values;
    }

    public synchronized String getGrammar() {
        if (this.grammar == null) {
            if (this.properties.size() == 1) {
                return this.getProperty().getValueGrammar();
            }
            StringBuilder sb = new StringBuilder();
            Iterator<Property> i = this.getProperties().iterator();
            while (i.hasNext()) {
                Property p = i.next();
                sb.append(" [ ");
                sb.append(p.getValueGrammar());
                sb.append(" ] ");
                if (!i.hasNext()) continue;
                sb.append(" | ");
            }
            this.grammar = sb.toString();
        }
        return this.grammar;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

