/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.GrammarElementKind;

public class GroupGrammarElement
extends GrammarElement {
    int index;
    String referenceName = null;
    private List<GrammarElement> elements = new ArrayList<GrammarElement>(5);
    private Type type;

    GroupGrammarElement(GroupGrammarElement parent, int index, String referenceName) {
        this(parent, index);
        this.referenceName = referenceName;
    }

    GroupGrammarElement(GroupGrammarElement parent, int index) {
        super(parent);
        this.index = index;
        this.type = Type.LIST;
    }

    @Override
    public GrammarElementKind getKind() {
        return GrammarElementKind.GROUP;
    }

    public Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
    }

    public List<GrammarElement> elements() {
        return this.elements;
    }

    void addElement(GrammarElement element) {
        this.elements.add(element);
    }

    public List<GrammarElement> getAllPossibleValues() {
        ArrayList<GrammarElement> all = new ArrayList<GrammarElement>(10);
        if (this.getType() == Type.LIST) {
            GrammarElement e = this.elements.get(0);
            if (e instanceof GroupGrammarElement) {
                all.addAll(((GroupGrammarElement)e).getAllPossibleValues());
            } else {
                all.add(e);
            }
        } else {
            for (GrammarElement e : this.elements()) {
                if (e instanceof GroupGrammarElement) {
                    all.addAll(((GroupGrammarElement)e).getAllPossibleValues());
                    continue;
                }
                all.add(e);
            }
        }
        return all;
    }

    @Override
    public String toString2(int level) {
        StringBuilder sb = new StringBuilder();
        String heading = this.toString();
        heading = heading.substring(0, heading.length() - 1);
        sb.append(this.indentString(level)).append(heading);
        if (this.referenceName != null) {
            sb.append("(").append(this.referenceName).append(") ");
        }
        sb.append('\n');
        for (GrammarElement e : this.elements()) {
            sb.append(e.toString2(level + 1));
            sb.append('\n');
        }
        sb.append(this.indentString(level));
        sb.append(']');
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getType().name().charAt(0));
        sb.append(this.index);
        if (this.referenceName != null) {
            sb.append("|").append(this.referenceName);
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        SET,
        COLLECTION,
        LIST,
        ALL;

    }
}

